/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class BankTransaction {
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact = null;
    @JsonProperty(value="Lineitems")
    private List<LineItem> lineitems = new ArrayList<LineItem>();
    @JsonProperty(value="BankAccount")
    private Account bankAccount = null;
    @JsonProperty(value="IsReconciled")
    private Boolean isReconciled;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode = null;
    @JsonProperty(value="CurrencyRate")
    private Float currencyRate;
    @JsonProperty(value="Url")
    private String url;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes = null;
    @JsonProperty(value="SubTotal")
    private Float subTotal;
    @JsonProperty(value="TotalTax")
    private Float totalTax;
    @JsonProperty(value="Total")
    private Float total;
    @JsonProperty(value="BankTransactionID")
    private UUID bankTransactionID;
    @JsonProperty(value="PrepaymentID")
    private UUID prepaymentID;
    @JsonProperty(value="OverpaymentID")
    private UUID overpaymentID;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;

    public BankTransaction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="See Bank Transaction Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BankTransaction contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public BankTransaction lineitems(List<LineItem> lineitems) {
        this.lineitems = lineitems;
        return this;
    }

    public BankTransaction addLineitemsItem(LineItem lineitemsItem) {
        this.lineitems.add(lineitemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="See LineItems")
    public List<LineItem> getLineitems() {
        return this.lineitems;
    }

    public void setLineitems(List<LineItem> lineitems) {
        this.lineitems = lineitems;
    }

    public BankTransaction bankAccount(Account bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Account getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(Account bankAccount) {
        this.bankAccount = bankAccount;
    }

    public BankTransaction isReconciled(Boolean isReconciled) {
        this.isReconciled = isReconciled;
        return this;
    }

    @ApiModelProperty(value="Boolean to show if transaction is reconciled")
    public Boolean getIsReconciled() {
        return this.isReconciled;
    }

    public void setIsReconciled(Boolean isReconciled) {
        this.isReconciled = isReconciled;
    }

    public BankTransaction date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date of transaction \u2013 YYYY-MM-DD")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public BankTransaction reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Reference for the transaction. Only supported for SPEND and RECEIVE transactions.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BankTransaction currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BankTransaction currencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="Exchange rate to base currency when money is spent or received. e.g.0.7500 Only used for bank transactions in non base currency. If this isn\u2019t specified for non base currency accounts then either the user-defined rate (preference) or the XE.com day rate will be used. Setting currency is only supported on overpayments.")
    public Float getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
    }

    public BankTransaction url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="URL link to a source document \u2013 shown as \u201cGo to App Name\u201d")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public BankTransaction status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Bank Transaction Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BankTransaction lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public BankTransaction subTotal(Float subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="Total of bank transaction excluding taxes")
    public Float getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Float subTotal) {
        this.subTotal = subTotal;
    }

    public BankTransaction totalTax(Float totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="Total tax on bank transaction")
    public Float getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Float totalTax) {
        this.totalTax = totalTax;
    }

    public BankTransaction total(Float total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total of bank transaction tax inclusive")
    public Float getTotal() {
        return this.total;
    }

    public void setTotal(Float total) {
        this.total = total;
    }

    public BankTransaction bankTransactionID(UUID bankTransactionID) {
        this.bankTransactionID = bankTransactionID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for bank transaction")
    public UUID getBankTransactionID() {
        return this.bankTransactionID;
    }

    public void setBankTransactionID(UUID bankTransactionID) {
        this.bankTransactionID = bankTransactionID;
    }

    @ApiModelProperty(value="Xero generated unique identifier for a Prepayment. This will be returned on BankTransactions with a Type of SPEND-PREPAYMENT or RECEIVE-PREPAYMENT")
    public UUID getPrepaymentID() {
        return this.prepaymentID;
    }

    @ApiModelProperty(value="Xero generated unique identifier for an Overpayment. This will be returned on BankTransactions with a Type of SPEND-OVERPAYMENT or RECEIVE-OVERPAYMENT")
    public UUID getOverpaymentID() {
        return this.overpaymentID;
    }

    @ApiModelProperty(value="Last modified date UTC format")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    @ApiModelProperty(value="Boolean to indicate if a bank transaction has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransaction bankTransaction = (BankTransaction)o;
        return Objects.equals((Object)this.type, (Object)bankTransaction.type) && Objects.equals(this.contact, bankTransaction.contact) && Objects.equals(this.lineitems, bankTransaction.lineitems) && Objects.equals(this.bankAccount, bankTransaction.bankAccount) && Objects.equals(this.isReconciled, bankTransaction.isReconciled) && Objects.equals(this.date, bankTransaction.date) && Objects.equals(this.reference, bankTransaction.reference) && Objects.equals((Object)this.currencyCode, (Object)bankTransaction.currencyCode) && Objects.equals(this.currencyRate, bankTransaction.currencyRate) && Objects.equals(this.url, bankTransaction.url) && Objects.equals((Object)this.status, (Object)bankTransaction.status) && Objects.equals((Object)this.lineAmountTypes, (Object)bankTransaction.lineAmountTypes) && Objects.equals(this.subTotal, bankTransaction.subTotal) && Objects.equals(this.totalTax, bankTransaction.totalTax) && Objects.equals(this.total, bankTransaction.total) && Objects.equals(this.bankTransactionID, bankTransaction.bankTransactionID) && Objects.equals(this.prepaymentID, bankTransaction.prepaymentID) && Objects.equals(this.overpaymentID, bankTransaction.overpaymentID) && Objects.equals(this.updatedDateUTC, bankTransaction.updatedDateUTC) && Objects.equals(this.hasAttachments, bankTransaction.hasAttachments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.lineitems, this.bankAccount, this.isReconciled, this.date, this.reference, this.currencyCode, this.currencyRate, this.url, this.status, this.lineAmountTypes, this.subTotal, this.totalTax, this.total, this.bankTransactionID, this.prepaymentID, this.overpaymentID, this.updatedDateUTC, this.hasAttachments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransaction {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    lineitems: ").append(this.toIndentedString(this.lineitems)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    isReconciled: ").append(this.toIndentedString(this.isReconciled)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    bankTransactionID: ").append(this.toIndentedString(this.bankTransactionID)).append("\n");
        sb.append("    prepaymentID: ").append(this.toIndentedString(this.prepaymentID)).append("\n");
        sb.append("    overpaymentID: ").append(this.toIndentedString(this.overpaymentID)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        AUTHORISED("AUTHORISED"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum TypeEnum {
        RECEIVE("RECEIVE"),
        RECEIVE_OVERPAYMENT("RECEIVE-OVERPAYMENT"),
        RECEIVE_PREPAYMENT("RECEIVE-PREPAYMENT"),
        SPEND("SPEND"),
        SPEND_OVERPAYMENT("SPEND-OVERPAYMENT"),
        SPEND_PREPAYMENT("SPEND-PREPAYMENT"),
        RECEIVE_TRANSFER("RECEIVE-TRANSFER"),
        SPEND_TRANSFER("SPEND-TRANSFER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

