/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Account;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class BankTransfer {
    @JsonProperty(value="FromBankAccount")
    private Account fromBankAccount = null;
    @JsonProperty(value="ToBankAccount")
    private Account toBankAccount = null;
    @JsonProperty(value="Amount")
    private String amount;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="BankTransferID")
    private UUID bankTransferID;
    @JsonProperty(value="CurrencyRate")
    private Float currencyRate;
    @JsonProperty(value="FromBankTransactionID")
    private UUID fromBankTransactionID;
    @JsonProperty(value="ToBankTransactionID")
    private UUID toBankTransactionID;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="CreatedDateUTC")
    private OffsetDateTime createdDateUTC;

    public BankTransfer fromBankAccount(Account fromBankAccount) {
        this.fromBankAccount = fromBankAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Account getFromBankAccount() {
        return this.fromBankAccount;
    }

    public void setFromBankAccount(Account fromBankAccount) {
        this.fromBankAccount = fromBankAccount;
    }

    public BankTransfer toBankAccount(Account toBankAccount) {
        this.toBankAccount = toBankAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Account getToBankAccount() {
        return this.toBankAccount;
    }

    public void setToBankAccount(Account toBankAccount) {
        this.toBankAccount = toBankAccount;
    }

    public BankTransfer amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="amount of the transaction")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public BankTransfer date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="The date of the Transfer YYYY-MM-DD")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    @ApiModelProperty(value="The identifier of the Bank Transfer")
    public UUID getBankTransferID() {
        return this.bankTransferID;
    }

    @ApiModelProperty(value="The currency rate")
    public Float getCurrencyRate() {
        return this.currencyRate;
    }

    @ApiModelProperty(value="The Bank Transaction ID for the source account")
    public UUID getFromBankTransactionID() {
        return this.fromBankTransactionID;
    }

    @ApiModelProperty(value="The Bank Transaction ID for the destination account")
    public UUID getToBankTransactionID() {
        return this.toBankTransactionID;
    }

    @ApiModelProperty(value="Boolean to indicate if a Bank Transfer has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(value="UTC timestamp of creation date of bank transfer")
    public OffsetDateTime getCreatedDateUTC() {
        return this.createdDateUTC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransfer bankTransfer = (BankTransfer)o;
        return Objects.equals(this.fromBankAccount, bankTransfer.fromBankAccount) && Objects.equals(this.toBankAccount, bankTransfer.toBankAccount) && Objects.equals(this.amount, bankTransfer.amount) && Objects.equals(this.date, bankTransfer.date) && Objects.equals(this.bankTransferID, bankTransfer.bankTransferID) && Objects.equals(this.currencyRate, bankTransfer.currencyRate) && Objects.equals(this.fromBankTransactionID, bankTransfer.fromBankTransactionID) && Objects.equals(this.toBankTransactionID, bankTransfer.toBankTransactionID) && Objects.equals(this.hasAttachments, bankTransfer.hasAttachments) && Objects.equals(this.createdDateUTC, bankTransfer.createdDateUTC);
    }

    public int hashCode() {
        return Objects.hash(this.fromBankAccount, this.toBankAccount, this.amount, this.date, this.bankTransferID, this.currencyRate, this.fromBankTransactionID, this.toBankTransactionID, this.hasAttachments, this.createdDateUTC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransfer {\n");
        sb.append("    fromBankAccount: ").append(this.toIndentedString(this.fromBankAccount)).append("\n");
        sb.append("    toBankAccount: ").append(this.toIndentedString(this.toBankAccount)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    bankTransferID: ").append(this.toIndentedString(this.bankTransferID)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    fromBankTransactionID: ").append(this.toIndentedString(this.fromBankTransactionID)).append("\n");
        sb.append("    toBankTransactionID: ").append(this.toIndentedString(this.toBankTransactionID)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    createdDateUTC: ").append(this.toIndentedString(this.createdDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

