/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.Payment;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class BatchPayment {
    @JsonProperty(value="Account")
    private Account account = null;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="Particulars")
    private String particulars;
    @JsonProperty(value="Code")
    private String code;
    @JsonProperty(value="Details")
    private String details;
    @JsonProperty(value="Narrative")
    private String narrative;
    @JsonProperty(value="BatchPaymentID")
    private UUID batchPaymentID;
    @JsonProperty(value="DateString")
    private String dateString;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="Amount")
    private Float amount;
    @JsonProperty(value="Payments")
    private List<Payment> payments = null;
    @JsonProperty(value="Type")
    private String type;
    @JsonProperty(value="Status")
    private String status;
    @JsonProperty(value="TotalAmount")
    private String totalAmount;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="IsReconciled")
    private String isReconciled;

    public BatchPayment account(Account account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(value="")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public BatchPayment reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="(NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BatchPayment particulars(String particulars) {
        this.particulars = particulars;
        return this;
    }

    @ApiModelProperty(value="(NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.")
    public String getParticulars() {
        return this.particulars;
    }

    public void setParticulars(String particulars) {
        this.particulars = particulars;
    }

    public BatchPayment code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="(NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BatchPayment details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(value="(Non-NZ Only) These details are sent to the org\u2019s bank as a reference for the batch payment transaction. They will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement imported into Xero. Maximum field length = 18")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public BatchPayment narrative(String narrative) {
        this.narrative = narrative;
        return this;
    }

    @ApiModelProperty(value="(UK Only) Only shows on the statement line in Xero. Max length =18")
    public String getNarrative() {
        return this.narrative;
    }

    public void setNarrative(String narrative) {
        this.narrative = narrative;
    }

    @ApiModelProperty(value="The Xero generated unique identifier for the bank transaction (read-only)")
    public UUID getBatchPaymentID() {
        return this.batchPaymentID;
    }

    public BatchPayment dateString(String dateString) {
        this.dateString = dateString;
        return this;
    }

    @ApiModelProperty(value="Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06")
    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public BatchPayment date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public BatchPayment amount(Float amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount of the payment. Must be less than or equal to the outstanding amount owing on the invoice e.g. 200.00")
    public Float getAmount() {
        return this.amount;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }

    public BatchPayment payments(List<Payment> payments) {
        this.payments = payments;
        return this;
    }

    public BatchPayment addPaymentsItem(Payment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    @ApiModelProperty(value="PAYBATCH for bill payments or RECBATCH for sales invoice payments (read-only)")
    public String getType() {
        return this.type;
    }

    @ApiModelProperty(value="AUTHORISED or DELETED (read-only). New batch payments will have a status of AUTHORISED. It is not possible to delete batch payments via the API.")
    public String getStatus() {
        return this.status;
    }

    @ApiModelProperty(value="The total of the payments that make up the batch (read-only)")
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @ApiModelProperty(value="UTC timestamp of last update to the payment")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    @ApiModelProperty(value="Booelan that tells you if the batch payment has been reconciled (read-only)")
    public String getIsReconciled() {
        return this.isReconciled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPayment batchPayment = (BatchPayment)o;
        return Objects.equals(this.account, batchPayment.account) && Objects.equals(this.reference, batchPayment.reference) && Objects.equals(this.particulars, batchPayment.particulars) && Objects.equals(this.code, batchPayment.code) && Objects.equals(this.details, batchPayment.details) && Objects.equals(this.narrative, batchPayment.narrative) && Objects.equals(this.batchPaymentID, batchPayment.batchPaymentID) && Objects.equals(this.dateString, batchPayment.dateString) && Objects.equals(this.date, batchPayment.date) && Objects.equals(this.amount, batchPayment.amount) && Objects.equals(this.payments, batchPayment.payments) && Objects.equals(this.type, batchPayment.type) && Objects.equals(this.status, batchPayment.status) && Objects.equals(this.totalAmount, batchPayment.totalAmount) && Objects.equals(this.updatedDateUTC, batchPayment.updatedDateUTC) && Objects.equals(this.isReconciled, batchPayment.isReconciled);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.reference, this.particulars, this.code, this.details, this.narrative, this.batchPaymentID, this.dateString, this.date, this.amount, this.payments, this.type, this.status, this.totalAmount, this.updatedDateUTC, this.isReconciled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchPayment {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    particulars: ").append(this.toIndentedString(this.particulars)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    narrative: ").append(this.toIndentedString(this.narrative)).append("\n");
        sb.append("    batchPaymentID: ").append(this.toIndentedString(this.batchPaymentID)).append("\n");
        sb.append("    dateString: ").append(this.toIndentedString(this.dateString)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    isReconciled: ").append(this.toIndentedString(this.isReconciled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

