/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Bank details for use on a batch payment stored with each contact")
public class BatchPaymentDetails {
    @JsonProperty(value="BankAccountNumber")
    private String bankAccountNumber;
    @JsonProperty(value="BankAccountName")
    private String bankAccountName;
    @JsonProperty(value="Details")
    private String details;
    @JsonProperty(value="Code")
    private String code;
    @JsonProperty(value="Reference")
    private String reference;

    public BatchPaymentDetails bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @ApiModelProperty(example="123-456-1111111", value="Bank account number for use with Batch Payments")
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public BatchPaymentDetails bankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
        return this;
    }

    @ApiModelProperty(example="ACME Bank", value="Name of bank for use with Batch Payments")
    public String getBankAccountName() {
        return this.bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public BatchPaymentDetails details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(example="Hello World", value="(Non-NZ Only) These details are sent to the org\u2019s bank as a reference for the batch payment transaction. They will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement imported into Xero. Maximum field length = 18")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public BatchPaymentDetails code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(example="ABC", value="(NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BatchPaymentDetails reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(example="Foobar", value="(NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPaymentDetails batchPaymentDetails = (BatchPaymentDetails)o;
        return Objects.equals(this.bankAccountNumber, batchPaymentDetails.bankAccountNumber) && Objects.equals(this.bankAccountName, batchPaymentDetails.bankAccountName) && Objects.equals(this.details, batchPaymentDetails.details) && Objects.equals(this.code, batchPaymentDetails.code) && Objects.equals(this.reference, batchPaymentDetails.reference);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccountNumber, this.bankAccountName, this.details, this.code, this.reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchPaymentDetails {\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    bankAccountName: ").append(this.toIndentedString(this.bankAccountName)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

