/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class BrandingTheme {
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="SortOrder")
    private Integer sortOrder;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="CreatedDateUTC")
    private OffsetDateTime createdDateUTC;

    public BrandingTheme brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public BrandingTheme name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of branding theme")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BrandingTheme sortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(value="Integer \u2013 ranked order of branding theme. The default branding theme has a value of 0")
    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public BrandingTheme createdDateUTC(OffsetDateTime createdDateUTC) {
        this.createdDateUTC = createdDateUTC;
        return this;
    }

    @ApiModelProperty(value="UTC timestamp of creation date of branding theme")
    public OffsetDateTime getCreatedDateUTC() {
        return this.createdDateUTC;
    }

    public void setCreatedDateUTC(OffsetDateTime createdDateUTC) {
        this.createdDateUTC = createdDateUTC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandingTheme brandingTheme = (BrandingTheme)o;
        return Objects.equals(this.brandingThemeID, brandingTheme.brandingThemeID) && Objects.equals(this.name, brandingTheme.name) && Objects.equals(this.sortOrder, brandingTheme.sortOrder) && Objects.equals(this.createdDateUTC, brandingTheme.createdDateUTC);
    }

    public int hashCode() {
        return Objects.hash(this.brandingThemeID, this.name, this.sortOrder, this.createdDateUTC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrandingTheme {\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString(this.sortOrder)).append("\n");
        sb.append("    createdDateUTC: ").append(this.toIndentedString(this.createdDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

