/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Allocation;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Payment;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class CreditNote {
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact = null;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes = null;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = null;
    @JsonProperty(value="SubTotal")
    private Float subTotal;
    @JsonProperty(value="TotalTax")
    private Float totalTax;
    @JsonProperty(value="Total")
    private Float total;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode = null;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="FullyPaidOnDate")
    private LocalDate fullyPaidOnDate;
    @JsonProperty(value="CreditNoteID")
    private UUID creditNoteID;
    @JsonProperty(value="CreditNoteNumber")
    private String creditNoteNumber;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="SentToContact")
    private Boolean sentToContact;
    @JsonProperty(value="CurrencyRate")
    private Float currencyRate;
    @JsonProperty(value="RemainingCredit")
    private Float remainingCredit;
    @JsonProperty(value="Allocations")
    private List<Allocation> allocations = null;
    @JsonProperty(value="Payments")
    private List<Payment> payments = null;
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;

    public CreditNote type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="See Credit Note Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreditNote contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public CreditNote date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="The date the credit note is issued YYYY-MM-DD. If the Date element is not specified then it will default to the current date based on the timezone setting of the organisation")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public CreditNote status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Credit Note Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CreditNote lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public CreditNote lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public CreditNote addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="See Invoice Line Items")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public CreditNote subTotal(Float subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="The subtotal of the credit note excluding taxes")
    public Float getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Float subTotal) {
        this.subTotal = subTotal;
    }

    public CreditNote totalTax(Float totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="The total tax on the credit note")
    public Float getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Float totalTax) {
        this.totalTax = totalTax;
    }

    public CreditNote total(Float total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="The total of the Credit Note(subtotal + total tax)")
    public Float getTotal() {
        return this.total;
    }

    public void setTotal(Float total) {
        this.total = total;
    }

    public CreditNote updatedDateUTC(OffsetDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
        return this;
    }

    @ApiModelProperty(value="UTC timestamp of last update to the credit note")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public void setUpdatedDateUTC(OffsetDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
    }

    public CreditNote currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CreditNote fullyPaidOnDate(LocalDate fullyPaidOnDate) {
        this.fullyPaidOnDate = fullyPaidOnDate;
        return this;
    }

    @ApiModelProperty(value="Date when credit note was fully paid(UTC format)")
    public LocalDate getFullyPaidOnDate() {
        return this.fullyPaidOnDate;
    }

    public void setFullyPaidOnDate(LocalDate fullyPaidOnDate) {
        this.fullyPaidOnDate = fullyPaidOnDate;
    }

    public CreditNote creditNoteID(UUID creditNoteID) {
        this.creditNoteID = creditNoteID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier")
    public UUID getCreditNoteID() {
        return this.creditNoteID;
    }

    public void setCreditNoteID(UUID creditNoteID) {
        this.creditNoteID = creditNoteID;
    }

    public CreditNote creditNoteNumber(String creditNoteNumber) {
        this.creditNoteNumber = creditNoteNumber;
        return this;
    }

    @ApiModelProperty(value="ACCRECCREDIT \u2013 Unique alpha numeric code identifying credit note (when missing will auto-generate from your Organisation Invoice Settings)")
    public String getCreditNoteNumber() {
        return this.creditNoteNumber;
    }

    public void setCreditNoteNumber(String creditNoteNumber) {
        this.creditNoteNumber = creditNoteNumber;
    }

    public CreditNote reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="ACCRECCREDIT only \u2013 additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @ApiModelProperty(value="boolean to indicate if a credit note has been sent to a contact via  the Xero app (currently read only)")
    public Boolean getSentToContact() {
        return this.sentToContact;
    }

    public CreditNote currencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="The currency rate for a multicurrency invoice. If no rate is specified, the XE.com day rate is used")
    public Float getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
    }

    public CreditNote remainingCredit(Float remainingCredit) {
        this.remainingCredit = remainingCredit;
        return this;
    }

    @ApiModelProperty(value="The remaining credit balance on the Credit Note")
    public Float getRemainingCredit() {
        return this.remainingCredit;
    }

    public void setRemainingCredit(Float remainingCredit) {
        this.remainingCredit = remainingCredit;
    }

    public CreditNote allocations(List<Allocation> allocations) {
        this.allocations = allocations;
        return this;
    }

    public CreditNote addAllocationsItem(Allocation allocationsItem) {
        if (this.allocations == null) {
            this.allocations = new ArrayList<Allocation>();
        }
        this.allocations.add(allocationsItem);
        return this;
    }

    @ApiModelProperty(value="See Allocations")
    public List<Allocation> getAllocations() {
        return this.allocations;
    }

    public void setAllocations(List<Allocation> allocations) {
        this.allocations = allocations;
    }

    public CreditNote payments(List<Payment> payments) {
        this.payments = payments;
        return this;
    }

    public CreditNote addPaymentsItem(Payment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(value="See Payments")
    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    public CreditNote brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="See BrandingThemes")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public CreditNote hasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    @ApiModelProperty(value="boolean to indicate if a credit note has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public void setHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditNote creditNote = (CreditNote)o;
        return Objects.equals((Object)this.type, (Object)creditNote.type) && Objects.equals(this.contact, creditNote.contact) && Objects.equals(this.date, creditNote.date) && Objects.equals((Object)this.status, (Object)creditNote.status) && Objects.equals((Object)this.lineAmountTypes, (Object)creditNote.lineAmountTypes) && Objects.equals(this.lineItems, creditNote.lineItems) && Objects.equals(this.subTotal, creditNote.subTotal) && Objects.equals(this.totalTax, creditNote.totalTax) && Objects.equals(this.total, creditNote.total) && Objects.equals(this.updatedDateUTC, creditNote.updatedDateUTC) && Objects.equals((Object)this.currencyCode, (Object)creditNote.currencyCode) && Objects.equals(this.fullyPaidOnDate, creditNote.fullyPaidOnDate) && Objects.equals(this.creditNoteID, creditNote.creditNoteID) && Objects.equals(this.creditNoteNumber, creditNote.creditNoteNumber) && Objects.equals(this.reference, creditNote.reference) && Objects.equals(this.sentToContact, creditNote.sentToContact) && Objects.equals(this.currencyRate, creditNote.currencyRate) && Objects.equals(this.remainingCredit, creditNote.remainingCredit) && Objects.equals(this.allocations, creditNote.allocations) && Objects.equals(this.payments, creditNote.payments) && Objects.equals(this.brandingThemeID, creditNote.brandingThemeID) && Objects.equals(this.hasAttachments, creditNote.hasAttachments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.date, this.status, this.lineAmountTypes, this.lineItems, this.subTotal, this.totalTax, this.total, this.updatedDateUTC, this.currencyCode, this.fullyPaidOnDate, this.creditNoteID, this.creditNoteNumber, this.reference, this.sentToContact, this.currencyRate, this.remainingCredit, this.allocations, this.payments, this.brandingThemeID, this.hasAttachments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditNote {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    fullyPaidOnDate: ").append(this.toIndentedString(this.fullyPaidOnDate)).append("\n");
        sb.append("    creditNoteID: ").append(this.toIndentedString(this.creditNoteID)).append("\n");
        sb.append("    creditNoteNumber: ").append(this.toIndentedString(this.creditNoteNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    sentToContact: ").append(this.toIndentedString(this.sentToContact)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    remainingCredit: ").append(this.toIndentedString(this.remainingCredit)).append("\n");
        sb.append("    allocations: ").append(this.toIndentedString(this.allocations)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        SUBMITTED("SUBMITTED"),
        DELETED("DELETED"),
        AUTHORISED("AUTHORISED"),
        PAID("PAID"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum TypeEnum {
        ACCPAYCREDIT("ACCPAYCREDIT"),
        ACCRECCREDIT("ACCRECCREDIT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

