/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CreditNote;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Overpayment;
import com.xero.models.accounting.Payment;
import com.xero.models.accounting.Prepayment;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Invoice {
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact = null;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="DueDate")
    private LocalDate dueDate;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes = null;
    @JsonProperty(value="InvoiceNumber")
    private String invoiceNumber;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="Url")
    private String url;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode = null;
    @JsonProperty(value="CurrencyRate")
    private Float currencyRate;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="SentToContact")
    private Boolean sentToContact;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="ExpectedPaymentDate")
    private LocalDate expectedPaymentDate;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="PlannedPaymentDate")
    private LocalDate plannedPaymentDate;
    @JsonProperty(value="SubTotal")
    private Float subTotal;
    @JsonProperty(value="TotalTax")
    private Float totalTax;
    @JsonProperty(value="Total")
    private Float total;
    @JsonProperty(value="TotalDiscount")
    private Float totalDiscount;
    @JsonProperty(value="InvoiceID")
    private UUID invoiceID;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;
    @JsonProperty(value="Payments")
    private List<Payment> payments = null;
    @JsonProperty(value="Prepayments")
    private List<Prepayment> prepayments = null;
    @JsonProperty(value="Overpayments")
    private List<Overpayment> overpayments = null;
    @JsonProperty(value="AmountDue")
    private Float amountDue;
    @JsonProperty(value="AmountPaid")
    private Float amountPaid;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="FullyPaidOnDate")
    private LocalDate fullyPaidOnDate;
    @JsonProperty(value="AmountCredited")
    private Float amountCredited;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="CreditNotes")
    private List<CreditNote> creditNotes = null;

    public Invoice type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="See Invoice Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Invoice contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Invoice lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public Invoice addLineItemsItem(LineItem lineItemsItem) {
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="See LineItems")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public Invoice date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date invoice was issued \u2013 YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Invoice dueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(value="Date invoice is due \u2013 YYYY-MM-DD")
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public Invoice lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public Invoice invoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
        return this;
    }

    @ApiModelProperty(value="ACCREC \u2013 Unique alpha numeric code identifying invoice (when missing will auto-generate from your Organisation Invoice Settings) (max length = 255)")
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public Invoice reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="ACCREC only \u2013 additional reference number (max length = 255)")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Invoice brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="See BrandingThemes")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public Invoice url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="URL link to a source document \u2013 shown as \u201cGo to [appName]\u201d in the Xero app")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Invoice currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Invoice currencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="The currency rate for a multicurrency invoice. If no rate is specified, the XE.com day rate is used. (max length = [18].[6])")
    public Float getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
    }

    public Invoice status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Invoice Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Invoice sentToContact(Boolean sentToContact) {
        this.sentToContact = sentToContact;
        return this;
    }

    @ApiModelProperty(value="Boolean to set whether the invoice in the Xero app should be marked as \u201csent\u201d. This can be set only on invoices that have been approved")
    public Boolean getSentToContact() {
        return this.sentToContact;
    }

    public void setSentToContact(Boolean sentToContact) {
        this.sentToContact = sentToContact;
    }

    public Invoice expectedPaymentDate(LocalDate expectedPaymentDate) {
        this.expectedPaymentDate = expectedPaymentDate;
        return this;
    }

    @ApiModelProperty(value="Shown on sales invoices (Accounts Receivable) when this has been set")
    public LocalDate getExpectedPaymentDate() {
        return this.expectedPaymentDate;
    }

    public void setExpectedPaymentDate(LocalDate expectedPaymentDate) {
        this.expectedPaymentDate = expectedPaymentDate;
    }

    public Invoice plannedPaymentDate(LocalDate plannedPaymentDate) {
        this.plannedPaymentDate = plannedPaymentDate;
        return this;
    }

    @ApiModelProperty(value="Shown on bills (Accounts Payable) when this has been set")
    public LocalDate getPlannedPaymentDate() {
        return this.plannedPaymentDate;
    }

    public void setPlannedPaymentDate(LocalDate plannedPaymentDate) {
        this.plannedPaymentDate = plannedPaymentDate;
    }

    @ApiModelProperty(value="Total of invoice excluding taxes")
    public Float getSubTotal() {
        return this.subTotal;
    }

    @ApiModelProperty(value="Total tax on invoice")
    public Float getTotalTax() {
        return this.totalTax;
    }

    @ApiModelProperty(value="Total of Invoice tax inclusive (i.e. SubTotal + TotalTax). This will be ignored if it doesn\u2019t equal the sum of the LineAmounts")
    public Float getTotal() {
        return this.total;
    }

    @ApiModelProperty(value="Total of discounts applied on the invoice line items")
    public Float getTotalDiscount() {
        return this.totalDiscount;
    }

    public Invoice invoiceID(UUID invoiceID) {
        this.invoiceID = invoiceID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for invoice")
    public UUID getInvoiceID() {
        return this.invoiceID;
    }

    public void setInvoiceID(UUID invoiceID) {
        this.invoiceID = invoiceID;
    }

    @ApiModelProperty(value="boolean to indicate if an invoice has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(value="See Payments")
    public List<Payment> getPayments() {
        return this.payments;
    }

    @ApiModelProperty(value="See Prepayments")
    public List<Prepayment> getPrepayments() {
        return this.prepayments;
    }

    @ApiModelProperty(value="See Overpayments")
    public List<Overpayment> getOverpayments() {
        return this.overpayments;
    }

    @ApiModelProperty(value="Amount remaining to be paid on invoice")
    public Float getAmountDue() {
        return this.amountDue;
    }

    @ApiModelProperty(value="Sum of payments received for invoice")
    public Float getAmountPaid() {
        return this.amountPaid;
    }

    @ApiModelProperty(value="The date the invoice was fully paid. Only returned on fully paid invoices")
    public LocalDate getFullyPaidOnDate() {
        return this.fullyPaidOnDate;
    }

    @ApiModelProperty(value="Sum of all credit notes, over-payments and pre-payments applied to invoice")
    public Float getAmountCredited() {
        return this.amountCredited;
    }

    @ApiModelProperty(value="Last modified date UTC format")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    @ApiModelProperty(value="Details of credit notes that have been applied to an invoice")
    public List<CreditNote> getCreditNotes() {
        return this.creditNotes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return Objects.equals((Object)this.type, (Object)invoice.type) && Objects.equals(this.contact, invoice.contact) && Objects.equals(this.lineItems, invoice.lineItems) && Objects.equals(this.date, invoice.date) && Objects.equals(this.dueDate, invoice.dueDate) && Objects.equals((Object)this.lineAmountTypes, (Object)invoice.lineAmountTypes) && Objects.equals(this.invoiceNumber, invoice.invoiceNumber) && Objects.equals(this.reference, invoice.reference) && Objects.equals(this.brandingThemeID, invoice.brandingThemeID) && Objects.equals(this.url, invoice.url) && Objects.equals((Object)this.currencyCode, (Object)invoice.currencyCode) && Objects.equals(this.currencyRate, invoice.currencyRate) && Objects.equals((Object)this.status, (Object)invoice.status) && Objects.equals(this.sentToContact, invoice.sentToContact) && Objects.equals(this.expectedPaymentDate, invoice.expectedPaymentDate) && Objects.equals(this.plannedPaymentDate, invoice.plannedPaymentDate) && Objects.equals(this.subTotal, invoice.subTotal) && Objects.equals(this.totalTax, invoice.totalTax) && Objects.equals(this.total, invoice.total) && Objects.equals(this.totalDiscount, invoice.totalDiscount) && Objects.equals(this.invoiceID, invoice.invoiceID) && Objects.equals(this.hasAttachments, invoice.hasAttachments) && Objects.equals(this.payments, invoice.payments) && Objects.equals(this.prepayments, invoice.prepayments) && Objects.equals(this.overpayments, invoice.overpayments) && Objects.equals(this.amountDue, invoice.amountDue) && Objects.equals(this.amountPaid, invoice.amountPaid) && Objects.equals(this.fullyPaidOnDate, invoice.fullyPaidOnDate) && Objects.equals(this.amountCredited, invoice.amountCredited) && Objects.equals(this.updatedDateUTC, invoice.updatedDateUTC) && Objects.equals(this.creditNotes, invoice.creditNotes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.lineItems, this.date, this.dueDate, this.lineAmountTypes, this.invoiceNumber, this.reference, this.brandingThemeID, this.url, this.currencyCode, this.currencyRate, this.status, this.sentToContact, this.expectedPaymentDate, this.plannedPaymentDate, this.subTotal, this.totalTax, this.total, this.totalDiscount, this.invoiceID, this.hasAttachments, this.payments, this.prepayments, this.overpayments, this.amountDue, this.amountPaid, this.fullyPaidOnDate, this.amountCredited, this.updatedDateUTC, this.creditNotes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoice {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    invoiceNumber: ").append(this.toIndentedString(this.invoiceNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sentToContact: ").append(this.toIndentedString(this.sentToContact)).append("\n");
        sb.append("    expectedPaymentDate: ").append(this.toIndentedString(this.expectedPaymentDate)).append("\n");
        sb.append("    plannedPaymentDate: ").append(this.toIndentedString(this.plannedPaymentDate)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    totalDiscount: ").append(this.toIndentedString(this.totalDiscount)).append("\n");
        sb.append("    invoiceID: ").append(this.toIndentedString(this.invoiceID)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    prepayments: ").append(this.toIndentedString(this.prepayments)).append("\n");
        sb.append("    overpayments: ").append(this.toIndentedString(this.overpayments)).append("\n");
        sb.append("    amountDue: ").append(this.toIndentedString(this.amountDue)).append("\n");
        sb.append("    amountPaid: ").append(this.toIndentedString(this.amountPaid)).append("\n");
        sb.append("    fullyPaidOnDate: ").append(this.toIndentedString(this.fullyPaidOnDate)).append("\n");
        sb.append("    amountCredited: ").append(this.toIndentedString(this.amountCredited)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    creditNotes: ").append(this.toIndentedString(this.creditNotes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        SUBMITTED("SUBMITTED"),
        DELETED("DELETED"),
        AUTHORISED("AUTHORISED"),
        PAID("PAID"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum TypeEnum {
        ACCREC("ACCREC"),
        ACCPAY("ACCPAY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

