/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.JournalLine;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Journal {
    @JsonProperty(value="JournalID")
    private UUID journalID;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="JournalDate")
    private LocalDate journalDate;
    @JsonProperty(value="JournalNumber")
    private String journalNumber;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="CreatedDateUTC")
    private OffsetDateTime createdDateUTC;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="SourceID")
    private UUID sourceID;
    @JsonProperty(value="SourceType")
    private SourceTypeEnum sourceType;
    @JsonProperty(value="JournalLines")
    private List<JournalLine> journalLines = null;

    public Journal journalID(UUID journalID) {
        this.journalID = journalID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getJournalID() {
        return this.journalID;
    }

    public void setJournalID(UUID journalID) {
        this.journalID = journalID;
    }

    public Journal journalDate(LocalDate journalDate) {
        this.journalDate = journalDate;
        return this;
    }

    @ApiModelProperty(value="Date the journal was posted")
    public LocalDate getJournalDate() {
        return this.journalDate;
    }

    public void setJournalDate(LocalDate journalDate) {
        this.journalDate = journalDate;
    }

    public Journal journalNumber(String journalNumber) {
        this.journalNumber = journalNumber;
        return this;
    }

    @ApiModelProperty(value="Xero generated journal number")
    public String getJournalNumber() {
        return this.journalNumber;
    }

    public void setJournalNumber(String journalNumber) {
        this.journalNumber = journalNumber;
    }

    @ApiModelProperty(value="Created date UTC format")
    public OffsetDateTime getCreatedDateUTC() {
        return this.createdDateUTC;
    }

    public Journal reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="reference field for additional indetifying information")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Journal sourceID(UUID sourceID) {
        this.sourceID = sourceID;
        return this;
    }

    @ApiModelProperty(value="The identifier for the source transaction (e.g. InvoiceID)")
    public UUID getSourceID() {
        return this.sourceID;
    }

    public void setSourceID(UUID sourceID) {
        this.sourceID = sourceID;
    }

    public Journal sourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @ApiModelProperty(value="The journal source type. The type of transaction that created the journal")
    public SourceTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public Journal journalLines(List<JournalLine> journalLines) {
        this.journalLines = journalLines;
        return this;
    }

    public Journal addJournalLinesItem(JournalLine journalLinesItem) {
        if (this.journalLines == null) {
            this.journalLines = new ArrayList<JournalLine>();
        }
        this.journalLines.add(journalLinesItem);
        return this;
    }

    @ApiModelProperty(value="See JournalLines")
    public List<JournalLine> getJournalLines() {
        return this.journalLines;
    }

    public void setJournalLines(List<JournalLine> journalLines) {
        this.journalLines = journalLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Journal journal = (Journal)o;
        return Objects.equals(this.journalID, journal.journalID) && Objects.equals(this.journalDate, journal.journalDate) && Objects.equals(this.journalNumber, journal.journalNumber) && Objects.equals(this.createdDateUTC, journal.createdDateUTC) && Objects.equals(this.reference, journal.reference) && Objects.equals(this.sourceID, journal.sourceID) && Objects.equals((Object)this.sourceType, (Object)journal.sourceType) && Objects.equals(this.journalLines, journal.journalLines);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.journalID, this.journalDate, this.journalNumber, this.createdDateUTC, this.reference, this.sourceID, this.sourceType, this.journalLines});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Journal {\n");
        sb.append("    journalID: ").append(this.toIndentedString(this.journalID)).append("\n");
        sb.append("    journalDate: ").append(this.toIndentedString(this.journalDate)).append("\n");
        sb.append("    journalNumber: ").append(this.toIndentedString(this.journalNumber)).append("\n");
        sb.append("    createdDateUTC: ").append(this.toIndentedString(this.createdDateUTC)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    sourceID: ").append(this.toIndentedString(this.sourceID)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString((Object)this.sourceType)).append("\n");
        sb.append("    journalLines: ").append(this.toIndentedString(this.journalLines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceTypeEnum {
        ACCREC("ACCREC"),
        ACCPAY("ACCPAY"),
        ACCRECCREDIT("ACCRECCREDIT"),
        ACCPAYCREDIT("ACCPAYCREDIT"),
        ACCRECPAYMENT("ACCRECPAYMENT"),
        ACCPAYPAYMENT("ACCPAYPAYMENT"),
        ARCREDITPAYMENT("ARCREDITPAYMENT"),
        APCREDITPAYMENT("APCREDITPAYMENT"),
        CASHREC("CASHREC"),
        CASHPAID("CASHPAID"),
        TRANSFER("TRANSFER"),
        ARPREPAYMENT("ARPREPAYMENT"),
        APPREPAYMENT("APPREPAYMENT"),
        AROVERPAYMENT("AROVERPAYMENT"),
        APOVERPAYMENT("APOVERPAYMENT"),
        EXPCLAIM("EXPCLAIM"),
        EXPPAYMENT("EXPPAYMENT"),
        MANJOURNAL("MANJOURNAL"),
        PAYSLIP("PAYSLIP"),
        WAGEPAYABLE("WAGEPAYABLE"),
        INTEGRATEDPAYROLLPE("INTEGRATEDPAYROLLPE"),
        INTEGRATEDPAYROLLPT("INTEGRATEDPAYROLLPT"),
        EXTERNALSPENDMONEY("EXTERNALSPENDMONEY"),
        INTEGRATEDPAYROLLPTPAYMENT("INTEGRATEDPAYROLLPTPAYMENT"),
        INTEGRATEDPAYROLLCN("INTEGRATEDPAYROLLCN");

        private String value;

        private SourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceTypeEnum fromValue(String text) {
            for (SourceTypeEnum b : SourceTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

