/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.models.accounting.LineItemTracking;
import com.xero.models.accounting.TaxType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class LineItem {
    @JsonProperty(value="LineItemID")
    private UUID lineItemID;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="Quantity")
    private Float quantity;
    @JsonProperty(value="UnitAmount")
    private Float unitAmount;
    @JsonProperty(value="ItemCode")
    private String itemCode;
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="TaxType")
    private TaxType taxType = null;
    @JsonProperty(value="TaxAmount")
    private Float taxAmount;
    @JsonProperty(value="LineAmount")
    private Float lineAmount;
    @JsonProperty(value="Tracking")
    private List<LineItemTracking> tracking = null;
    @JsonProperty(value="DiscountRate")
    private String discountRate;
    @JsonProperty(value="RepeatingInvoiceID")
    private UUID repeatingInvoiceID;

    public LineItem lineItemID(UUID lineItemID) {
        this.lineItemID = lineItemID;
        return this;
    }

    @ApiModelProperty(value="LineItem unique ID")
    public UUID getLineItemID() {
        return this.lineItemID;
    }

    public void setLineItemID(UUID lineItemID) {
        this.lineItemID = lineItemID;
    }

    public LineItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description needs to be at least 1 char long. A line item with just a description (i.e no unit amount or quantity) can be created by specifying just a <Description> element that contains at least 1 character")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LineItem quantity(Float quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="LineItem Quantity")
    public Float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Float quantity) {
        this.quantity = quantity;
    }

    public LineItem unitAmount(Float unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @ApiModelProperty(value="LineItem Unit Amount")
    public Float getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(Float unitAmount) {
        this.unitAmount = unitAmount;
    }

    public LineItem itemCode(String itemCode) {
        this.itemCode = itemCode;
        return this;
    }

    @ApiModelProperty(value="See Items")
    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public LineItem accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="See Accounts")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public LineItem taxType(TaxType taxType) {
        this.taxType = taxType;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxType getTaxType() {
        return this.taxType;
    }

    public void setTaxType(TaxType taxType) {
        this.taxType = taxType;
    }

    public LineItem taxAmount(Float taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty(value="The tax amount is auto calculated as a percentage of the line amount (see below) based on the tax rate. This value can be overriden if the calculated <TaxAmount> is not correct.")
    public Float getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Float taxAmount) {
        this.taxAmount = taxAmount;
    }

    public LineItem lineAmount(Float lineAmount) {
        this.lineAmount = lineAmount;
        return this;
    }

    @ApiModelProperty(value="If you wish to omit either of the <Quantity> or <UnitAmount> you can provide a LineAmount and Xero will calculate the missing amount for you. The line amount reflects the discounted price if a DiscountRate has been used . i.e LineAmount = Quantity * Unit Amount * ((100 \u2013 DiscountRate)/100)")
    public Float getLineAmount() {
        return this.lineAmount;
    }

    public void setLineAmount(Float lineAmount) {
        this.lineAmount = lineAmount;
    }

    public LineItem tracking(List<LineItemTracking> tracking) {
        this.tracking = tracking;
        return this;
    }

    public LineItem addTrackingItem(LineItemTracking trackingItem) {
        if (this.tracking == null) {
            this.tracking = new ArrayList<LineItemTracking>();
        }
        this.tracking.add(trackingItem);
        return this;
    }

    @ApiModelProperty(value="Optional Tracking Category \u2013 see Tracking.  Any LineItem can have a  maximum of 2 <TrackingCategory> elements.")
    public List<LineItemTracking> getTracking() {
        return this.tracking;
    }

    public void setTracking(List<LineItemTracking> tracking) {
        this.tracking = tracking;
    }

    public LineItem discountRate(String discountRate) {
        this.discountRate = discountRate;
        return this;
    }

    @ApiModelProperty(value="Percentage discount being applied to a line item (only supported on  ACCREC invoices \u2013 ACC PAY invoices and credit notes in Xero do not support discounts")
    public String getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(String discountRate) {
        this.discountRate = discountRate;
    }

    public LineItem repeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a Repeating Invoicee.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9")
    public UUID getRepeatingInvoiceID() {
        return this.repeatingInvoiceID;
    }

    public void setRepeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineItem lineItem = (LineItem)o;
        return Objects.equals(this.lineItemID, lineItem.lineItemID) && Objects.equals(this.description, lineItem.description) && Objects.equals(this.quantity, lineItem.quantity) && Objects.equals(this.unitAmount, lineItem.unitAmount) && Objects.equals(this.itemCode, lineItem.itemCode) && Objects.equals(this.accountCode, lineItem.accountCode) && Objects.equals((Object)this.taxType, (Object)lineItem.taxType) && Objects.equals(this.taxAmount, lineItem.taxAmount) && Objects.equals(this.lineAmount, lineItem.lineAmount) && Objects.equals(this.tracking, lineItem.tracking) && Objects.equals(this.discountRate, lineItem.discountRate) && Objects.equals(this.repeatingInvoiceID, lineItem.repeatingInvoiceID);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lineItemID, this.description, this.quantity, this.unitAmount, this.itemCode, this.accountCode, this.taxType, this.taxAmount, this.lineAmount, this.tracking, this.discountRate, this.repeatingInvoiceID});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineItem {\n");
        sb.append("    lineItemID: ").append(this.toIndentedString(this.lineItemID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    itemCode: ").append(this.toIndentedString(this.itemCode)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    taxType: ").append(this.toIndentedString((Object)this.taxType)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    lineAmount: ").append(this.toIndentedString(this.lineAmount)).append("\n");
        sb.append("    tracking: ").append(this.toIndentedString(this.tracking)).append("\n");
        sb.append("    discountRate: ").append(this.toIndentedString(this.discountRate)).append("\n");
        sb.append("    repeatingInvoiceID: ").append(this.toIndentedString(this.repeatingInvoiceID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

