/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.ManualJournalLine;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class ManualJournal {
    @JsonProperty(value="Narration")
    private String narration;
    @JsonProperty(value="JournalLines")
    private List<ManualJournalLine> journalLines = new ArrayList<ManualJournalLine>();
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes = null;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="Url")
    private String url;
    @JsonProperty(value="ShowOnCashBasisReports")
    private Boolean showOnCashBasisReports;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="ManualJournalID")
    private UUID manualJournalID;

    public ManualJournal narration(String narration) {
        this.narration = narration;
        return this;
    }

    @ApiModelProperty(required=true, value="Description of journal being posted")
    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public ManualJournal journalLines(List<ManualJournalLine> journalLines) {
        this.journalLines = journalLines;
        return this;
    }

    public ManualJournal addJournalLinesItem(ManualJournalLine journalLinesItem) {
        this.journalLines.add(journalLinesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="See JournalLines")
    public List<ManualJournalLine> getJournalLines() {
        return this.journalLines;
    }

    public void setJournalLines(List<ManualJournalLine> journalLines) {
        this.journalLines = journalLines;
    }

    public ManualJournal date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date journal was posted \u2013 YYYY-MM-DD")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public ManualJournal lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public ManualJournal status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Manual Journal Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ManualJournal url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Url link to a source document \u2013 shown as \u201cGo to [appName]\u201d in the Xero app")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ManualJournal showOnCashBasisReports(Boolean showOnCashBasisReports) {
        this.showOnCashBasisReports = showOnCashBasisReports;
        return this;
    }

    @ApiModelProperty(value="Boolean \u2013 default is true if not specified")
    public Boolean getShowOnCashBasisReports() {
        return this.showOnCashBasisReports;
    }

    public void setShowOnCashBasisReports(Boolean showOnCashBasisReports) {
        this.showOnCashBasisReports = showOnCashBasisReports;
    }

    @ApiModelProperty(value="Boolean to indicate if a manual journal has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(value="Last modified date UTC format")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public ManualJournal manualJournalID(UUID manualJournalID) {
        this.manualJournalID = manualJournalID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a Manual Journal")
    public UUID getManualJournalID() {
        return this.manualJournalID;
    }

    public void setManualJournalID(UUID manualJournalID) {
        this.manualJournalID = manualJournalID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualJournal manualJournal = (ManualJournal)o;
        return Objects.equals(this.narration, manualJournal.narration) && Objects.equals(this.journalLines, manualJournal.journalLines) && Objects.equals(this.date, manualJournal.date) && Objects.equals((Object)this.lineAmountTypes, (Object)manualJournal.lineAmountTypes) && Objects.equals((Object)this.status, (Object)manualJournal.status) && Objects.equals(this.url, manualJournal.url) && Objects.equals(this.showOnCashBasisReports, manualJournal.showOnCashBasisReports) && Objects.equals(this.hasAttachments, manualJournal.hasAttachments) && Objects.equals(this.updatedDateUTC, manualJournal.updatedDateUTC) && Objects.equals(this.manualJournalID, manualJournal.manualJournalID);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.narration, this.journalLines, this.date, this.lineAmountTypes, this.status, this.url, this.showOnCashBasisReports, this.hasAttachments, this.updatedDateUTC, this.manualJournalID});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManualJournal {\n");
        sb.append("    narration: ").append(this.toIndentedString(this.narration)).append("\n");
        sb.append("    journalLines: ").append(this.toIndentedString(this.journalLines)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    showOnCashBasisReports: ").append(this.toIndentedString(this.showOnCashBasisReports)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    manualJournalID: ").append(this.toIndentedString(this.manualJournalID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        POSTED("POSTED"),
        DELETED("DELETED"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

