/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.models.accounting.TaxType;
import com.xero.models.accounting.TrackingCategory;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ManualJournalLine {
    @JsonProperty(value="LineAmount")
    private Float lineAmount;
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="TaxType")
    private TaxType taxType = null;
    @JsonProperty(value="Tracking")
    private List<TrackingCategory> tracking = null;
    @JsonProperty(value="TaxAmount")
    private Float taxAmount;
    @JsonProperty(value="IsBlank")
    private Boolean isBlank;

    public ManualJournalLine lineAmount(Float lineAmount) {
        this.lineAmount = lineAmount;
        return this;
    }

    @ApiModelProperty(example="-2569.0", value="total for line. Debits are positive, credits are negative value")
    public Float getLineAmount() {
        return this.lineAmount;
    }

    public void setLineAmount(Float lineAmount) {
        this.lineAmount = lineAmount;
    }

    public ManualJournalLine accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(example="720", value="See Accounts")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public ManualJournalLine description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Coded incorrectly Office Equipment should be Computer Equipment", value="Description for journal line")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ManualJournalLine taxType(TaxType taxType) {
        this.taxType = taxType;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxType getTaxType() {
        return this.taxType;
    }

    public void setTaxType(TaxType taxType) {
        this.taxType = taxType;
    }

    public ManualJournalLine tracking(List<TrackingCategory> tracking) {
        this.tracking = tracking;
        return this;
    }

    public ManualJournalLine addTrackingItem(TrackingCategory trackingItem) {
        if (this.tracking == null) {
            this.tracking = new ArrayList<TrackingCategory>();
        }
        this.tracking.add(trackingItem);
        return this;
    }

    @ApiModelProperty(value="Optional Tracking Category \u2013 see Tracking. Any JournalLine can have a maximum of 2 <TrackingCategory> elements.")
    public List<TrackingCategory> getTracking() {
        return this.tracking;
    }

    public void setTracking(List<TrackingCategory> tracking) {
        this.tracking = tracking;
    }

    @ApiModelProperty(example="0.0", value="The calculated tax amount based on the TaxType and LineAmount")
    public Float getTaxAmount() {
        return this.taxAmount;
    }

    public ManualJournalLine isBlank(Boolean isBlank) {
        this.isBlank = isBlank;
        return this;
    }

    @ApiModelProperty(value="is the line blank")
    public Boolean getIsBlank() {
        return this.isBlank;
    }

    public void setIsBlank(Boolean isBlank) {
        this.isBlank = isBlank;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualJournalLine manualJournalLine = (ManualJournalLine)o;
        return Objects.equals(this.lineAmount, manualJournalLine.lineAmount) && Objects.equals(this.accountCode, manualJournalLine.accountCode) && Objects.equals(this.description, manualJournalLine.description) && Objects.equals((Object)this.taxType, (Object)manualJournalLine.taxType) && Objects.equals(this.tracking, manualJournalLine.tracking) && Objects.equals(this.taxAmount, manualJournalLine.taxAmount) && Objects.equals(this.isBlank, manualJournalLine.isBlank);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lineAmount, this.accountCode, this.description, this.taxType, this.tracking, this.taxAmount, this.isBlank});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManualJournalLine {\n");
        sb.append("    lineAmount: ").append(this.toIndentedString(this.lineAmount)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    taxType: ").append(this.toIndentedString((Object)this.taxType)).append("\n");
        sb.append("    tracking: ").append(this.toIndentedString(this.tracking)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    isBlank: ").append(this.toIndentedString(this.isBlank)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

