/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Address;
import com.xero.models.accounting.CountryCode;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.ExternalLink;
import com.xero.models.accounting.PaymentTerm;
import com.xero.models.accounting.Phone;
import com.xero.models.accounting.TimeZone;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Organisation {
    @JsonProperty(value="OrganisationID")
    private UUID organisationID;
    @JsonProperty(value="APIKey")
    private String apIKey;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="LegalName")
    private String legalName;
    @JsonProperty(value="PaysTax")
    private Boolean paysTax;
    @JsonProperty(value="Version")
    private VersionEnum version;
    @JsonProperty(value="OrganisationType")
    private OrganisationTypeEnum organisationType;
    @JsonProperty(value="BaseCurrency")
    private CurrencyCode baseCurrency = null;
    @JsonProperty(value="CountryCode")
    private CountryCode countryCode = null;
    @JsonProperty(value="IsDemoCompany")
    private Boolean isDemoCompany;
    @JsonProperty(value="OrganisationStatus")
    private String organisationStatus;
    @JsonProperty(value="RegistrationNumber")
    private String registrationNumber;
    @JsonProperty(value="TaxNumber")
    private String taxNumber;
    @JsonProperty(value="FinancialYearEndDay")
    private Integer financialYearEndDay;
    @JsonProperty(value="FinancialYearEndMonth")
    private Integer financialYearEndMonth;
    @JsonProperty(value="SalesTaxBasis")
    private SalesTaxBasisEnum salesTaxBasis;
    @JsonProperty(value="SalesTaxPeriod")
    private SalesTaxPeriodEnum salesTaxPeriod;
    @JsonProperty(value="DefaultSalesTax")
    private String defaultSalesTax;
    @JsonProperty(value="DefaultPurchasesTax")
    private String defaultPurchasesTax;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="PeriodLockDate")
    private LocalDate periodLockDate;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="EndOfYearLockDate")
    private LocalDate endOfYearLockDate;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="CreatedDateUTC")
    private OffsetDateTime createdDateUTC;
    @JsonProperty(value="Timezone")
    private TimeZone timezone = null;
    @JsonProperty(value="OrganisationEntityType")
    private OrganisationEntityTypeEnum organisationEntityType;
    @JsonProperty(value="ShortCode")
    private String shortCode;
    @JsonProperty(value="Class")
    private PropertyClassEnum propertyClass;
    @JsonProperty(value="LineOfBusiness")
    private String lineOfBusiness;
    @JsonProperty(value="Addresses")
    private List<Address> addresses = null;
    @JsonProperty(value="Phones")
    private List<Phone> phones = null;
    @JsonProperty(value="ExternalLinks")
    private List<ExternalLink> externalLinks = null;
    @JsonProperty(value="PaymentTerms")
    private PaymentTerm paymentTerms = null;

    public Organisation organisationID(UUID organisationID) {
        this.organisationID = organisationID;
        return this;
    }

    @ApiModelProperty(example="8be9db36-3598-4755-ba5c-c2dbc8c4a7a2", value="Unique Xero identifier")
    public UUID getOrganisationID() {
        return this.organisationID;
    }

    public void setOrganisationID(UUID organisationID) {
        this.organisationID = organisationID;
    }

    public Organisation apIKey(String apIKey) {
        this.apIKey = apIKey;
        return this;
    }

    @ApiModelProperty(value="Display a unique key used for Xero-to-Xero transactions")
    public String getApIKey() {
        return this.apIKey;
    }

    public void setApIKey(String apIKey) {
        this.apIKey = apIKey;
    }

    public Organisation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Display name of organisation shown in Xero")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Organisation legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @ApiModelProperty(value="Organisation name shown on Reports")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public Organisation paysTax(Boolean paysTax) {
        this.paysTax = paysTax;
        return this;
    }

    @ApiModelProperty(value="Boolean to describe if organisation is registered with a local tax authority i.e. true, false")
    public Boolean getPaysTax() {
        return this.paysTax;
    }

    public void setPaysTax(Boolean paysTax) {
        this.paysTax = paysTax;
    }

    public Organisation version(VersionEnum version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="See Version Types")
    public VersionEnum getVersion() {
        return this.version;
    }

    public void setVersion(VersionEnum version) {
        this.version = version;
    }

    public Organisation organisationType(OrganisationTypeEnum organisationType) {
        this.organisationType = organisationType;
        return this;
    }

    @ApiModelProperty(value="Organisation Type")
    public OrganisationTypeEnum getOrganisationType() {
        return this.organisationType;
    }

    public void setOrganisationType(OrganisationTypeEnum organisationType) {
        this.organisationType = organisationType;
    }

    public Organisation baseCurrency(CurrencyCode baseCurrency) {
        this.baseCurrency = baseCurrency;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getBaseCurrency() {
        return this.baseCurrency;
    }

    public void setBaseCurrency(CurrencyCode baseCurrency) {
        this.baseCurrency = baseCurrency;
    }

    public Organisation countryCode(CountryCode countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CountryCode getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(CountryCode countryCode) {
        this.countryCode = countryCode;
    }

    public Organisation isDemoCompany(Boolean isDemoCompany) {
        this.isDemoCompany = isDemoCompany;
        return this;
    }

    @ApiModelProperty(value="Boolean to describe if organisation is a demo company.")
    public Boolean getIsDemoCompany() {
        return this.isDemoCompany;
    }

    public void setIsDemoCompany(Boolean isDemoCompany) {
        this.isDemoCompany = isDemoCompany;
    }

    public Organisation organisationStatus(String organisationStatus) {
        this.organisationStatus = organisationStatus;
        return this;
    }

    @ApiModelProperty(value="Will be set to ACTIVE if you can connect to organisation via the Xero API")
    public String getOrganisationStatus() {
        return this.organisationStatus;
    }

    public void setOrganisationStatus(String organisationStatus) {
        this.organisationStatus = organisationStatus;
    }

    public Organisation registrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
        return this;
    }

    @ApiModelProperty(value="Shows for New Zealand, Australian and UK organisations")
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public Organisation taxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
        return this;
    }

    @ApiModelProperty(value="Shown if set. Displays in the Xero UI as Tax File Number (AU), GST Number (NZ), VAT Number (UK) and Tax ID Number (US & Global).")
    public String getTaxNumber() {
        return this.taxNumber;
    }

    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public Organisation financialYearEndDay(Integer financialYearEndDay) {
        this.financialYearEndDay = financialYearEndDay;
        return this;
    }

    @ApiModelProperty(value="Calendar day e.g. 0-31")
    public Integer getFinancialYearEndDay() {
        return this.financialYearEndDay;
    }

    public void setFinancialYearEndDay(Integer financialYearEndDay) {
        this.financialYearEndDay = financialYearEndDay;
    }

    public Organisation financialYearEndMonth(Integer financialYearEndMonth) {
        this.financialYearEndMonth = financialYearEndMonth;
        return this;
    }

    @ApiModelProperty(value="Calendar Month e.g. 1-12")
    public Integer getFinancialYearEndMonth() {
        return this.financialYearEndMonth;
    }

    public void setFinancialYearEndMonth(Integer financialYearEndMonth) {
        this.financialYearEndMonth = financialYearEndMonth;
    }

    public Organisation salesTaxBasis(SalesTaxBasisEnum salesTaxBasis) {
        this.salesTaxBasis = salesTaxBasis;
        return this;
    }

    @ApiModelProperty(value="The accounting basis used for tax returns. See Sales Tax Basis")
    public SalesTaxBasisEnum getSalesTaxBasis() {
        return this.salesTaxBasis;
    }

    public void setSalesTaxBasis(SalesTaxBasisEnum salesTaxBasis) {
        this.salesTaxBasis = salesTaxBasis;
    }

    public Organisation salesTaxPeriod(SalesTaxPeriodEnum salesTaxPeriod) {
        this.salesTaxPeriod = salesTaxPeriod;
        return this;
    }

    @ApiModelProperty(value="The frequency with which tax returns are processed. See Sales Tax Period")
    public SalesTaxPeriodEnum getSalesTaxPeriod() {
        return this.salesTaxPeriod;
    }

    public void setSalesTaxPeriod(SalesTaxPeriodEnum salesTaxPeriod) {
        this.salesTaxPeriod = salesTaxPeriod;
    }

    public Organisation defaultSalesTax(String defaultSalesTax) {
        this.defaultSalesTax = defaultSalesTax;
        return this;
    }

    @ApiModelProperty(value="The default for LineAmountTypes on sales transactions")
    public String getDefaultSalesTax() {
        return this.defaultSalesTax;
    }

    public void setDefaultSalesTax(String defaultSalesTax) {
        this.defaultSalesTax = defaultSalesTax;
    }

    public Organisation defaultPurchasesTax(String defaultPurchasesTax) {
        this.defaultPurchasesTax = defaultPurchasesTax;
        return this;
    }

    @ApiModelProperty(value="The default for LineAmountTypes on purchase transactions")
    public String getDefaultPurchasesTax() {
        return this.defaultPurchasesTax;
    }

    public void setDefaultPurchasesTax(String defaultPurchasesTax) {
        this.defaultPurchasesTax = defaultPurchasesTax;
    }

    public Organisation periodLockDate(LocalDate periodLockDate) {
        this.periodLockDate = periodLockDate;
        return this;
    }

    @ApiModelProperty(value="Shown if set. See lock dates")
    public LocalDate getPeriodLockDate() {
        return this.periodLockDate;
    }

    public void setPeriodLockDate(LocalDate periodLockDate) {
        this.periodLockDate = periodLockDate;
    }

    public Organisation endOfYearLockDate(LocalDate endOfYearLockDate) {
        this.endOfYearLockDate = endOfYearLockDate;
        return this;
    }

    @ApiModelProperty(value="Shown if set. See lock dates")
    public LocalDate getEndOfYearLockDate() {
        return this.endOfYearLockDate;
    }

    public void setEndOfYearLockDate(LocalDate endOfYearLockDate) {
        this.endOfYearLockDate = endOfYearLockDate;
    }

    public Organisation createdDateUTC(OffsetDateTime createdDateUTC) {
        this.createdDateUTC = createdDateUTC;
        return this;
    }

    @ApiModelProperty(value="Timestamp when the organisation was created in Xero")
    public OffsetDateTime getCreatedDateUTC() {
        return this.createdDateUTC;
    }

    public void setCreatedDateUTC(OffsetDateTime createdDateUTC) {
        this.createdDateUTC = createdDateUTC;
    }

    public Organisation timezone(TimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    @ApiModelProperty(value="")
    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public Organisation organisationEntityType(OrganisationEntityTypeEnum organisationEntityType) {
        this.organisationEntityType = organisationEntityType;
        return this;
    }

    @ApiModelProperty(value="Organisation Type")
    public OrganisationEntityTypeEnum getOrganisationEntityType() {
        return this.organisationEntityType;
    }

    public void setOrganisationEntityType(OrganisationEntityTypeEnum organisationEntityType) {
        this.organisationEntityType = organisationEntityType;
    }

    public Organisation shortCode(String shortCode) {
        this.shortCode = shortCode;
        return this;
    }

    @ApiModelProperty(value="A unique identifier for the organisation. Potential uses.")
    public String getShortCode() {
        return this.shortCode;
    }

    public void setShortCode(String shortCode) {
        this.shortCode = shortCode;
    }

    public Organisation propertyClass(PropertyClassEnum propertyClass) {
        this.propertyClass = propertyClass;
        return this;
    }

    @ApiModelProperty(value="Organisation Classes describe which plan the Xero organisation is on (e.g. DEMO, TRIAL, PREMIUM)")
    public PropertyClassEnum getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(PropertyClassEnum propertyClass) {
        this.propertyClass = propertyClass;
    }

    public Organisation lineOfBusiness(String lineOfBusiness) {
        this.lineOfBusiness = lineOfBusiness;
        return this;
    }

    @ApiModelProperty(value="Description of business type as defined in Organisation settings")
    public String getLineOfBusiness() {
        return this.lineOfBusiness;
    }

    public void setLineOfBusiness(String lineOfBusiness) {
        this.lineOfBusiness = lineOfBusiness;
    }

    public Organisation addresses(List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    public Organisation addAddressesItem(Address addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Address>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @ApiModelProperty(value="Address details for organisation \u2013 see Addresses")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public Organisation phones(List<Phone> phones) {
        this.phones = phones;
        return this;
    }

    public Organisation addPhonesItem(Phone phonesItem) {
        if (this.phones == null) {
            this.phones = new ArrayList<Phone>();
        }
        this.phones.add(phonesItem);
        return this;
    }

    @ApiModelProperty(value="Phones details for organisation \u2013 see Phones")
    public List<Phone> getPhones() {
        return this.phones;
    }

    public void setPhones(List<Phone> phones) {
        this.phones = phones;
    }

    public Organisation externalLinks(List<ExternalLink> externalLinks) {
        this.externalLinks = externalLinks;
        return this;
    }

    public Organisation addExternalLinksItem(ExternalLink externalLinksItem) {
        if (this.externalLinks == null) {
            this.externalLinks = new ArrayList<ExternalLink>();
        }
        this.externalLinks.add(externalLinksItem);
        return this;
    }

    @ApiModelProperty(value="Organisation profile links for popular services such as Facebook,Twitter, GooglePlus and LinkedIn. You can also add link to your website here. Shown if Organisation settings  is updated in Xero. See ExternalLinks below")
    public List<ExternalLink> getExternalLinks() {
        return this.externalLinks;
    }

    public void setExternalLinks(List<ExternalLink> externalLinks) {
        this.externalLinks = externalLinks;
    }

    public Organisation paymentTerms(PaymentTerm paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentTerm getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(PaymentTerm paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organisation organisation = (Organisation)o;
        return Objects.equals(this.organisationID, organisation.organisationID) && Objects.equals(this.apIKey, organisation.apIKey) && Objects.equals(this.name, organisation.name) && Objects.equals(this.legalName, organisation.legalName) && Objects.equals(this.paysTax, organisation.paysTax) && Objects.equals((Object)this.version, (Object)organisation.version) && Objects.equals((Object)this.organisationType, (Object)organisation.organisationType) && Objects.equals((Object)this.baseCurrency, (Object)organisation.baseCurrency) && Objects.equals((Object)this.countryCode, (Object)organisation.countryCode) && Objects.equals(this.isDemoCompany, organisation.isDemoCompany) && Objects.equals(this.organisationStatus, organisation.organisationStatus) && Objects.equals(this.registrationNumber, organisation.registrationNumber) && Objects.equals(this.taxNumber, organisation.taxNumber) && Objects.equals(this.financialYearEndDay, organisation.financialYearEndDay) && Objects.equals(this.financialYearEndMonth, organisation.financialYearEndMonth) && Objects.equals((Object)this.salesTaxBasis, (Object)organisation.salesTaxBasis) && Objects.equals((Object)this.salesTaxPeriod, (Object)organisation.salesTaxPeriod) && Objects.equals(this.defaultSalesTax, organisation.defaultSalesTax) && Objects.equals(this.defaultPurchasesTax, organisation.defaultPurchasesTax) && Objects.equals(this.periodLockDate, organisation.periodLockDate) && Objects.equals(this.endOfYearLockDate, organisation.endOfYearLockDate) && Objects.equals(this.createdDateUTC, organisation.createdDateUTC) && Objects.equals((Object)this.timezone, (Object)organisation.timezone) && Objects.equals((Object)this.organisationEntityType, (Object)organisation.organisationEntityType) && Objects.equals(this.shortCode, organisation.shortCode) && Objects.equals((Object)this.propertyClass, (Object)organisation.propertyClass) && Objects.equals(this.lineOfBusiness, organisation.lineOfBusiness) && Objects.equals(this.addresses, organisation.addresses) && Objects.equals(this.phones, organisation.phones) && Objects.equals(this.externalLinks, organisation.externalLinks) && Objects.equals(this.paymentTerms, organisation.paymentTerms);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.organisationID, this.apIKey, this.name, this.legalName, this.paysTax, this.version, this.organisationType, this.baseCurrency, this.countryCode, this.isDemoCompany, this.organisationStatus, this.registrationNumber, this.taxNumber, this.financialYearEndDay, this.financialYearEndMonth, this.salesTaxBasis, this.salesTaxPeriod, this.defaultSalesTax, this.defaultPurchasesTax, this.periodLockDate, this.endOfYearLockDate, this.createdDateUTC, this.timezone, this.organisationEntityType, this.shortCode, this.propertyClass, this.lineOfBusiness, this.addresses, this.phones, this.externalLinks, this.paymentTerms});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organisation {\n");
        sb.append("    organisationID: ").append(this.toIndentedString(this.organisationID)).append("\n");
        sb.append("    apIKey: ").append(this.toIndentedString(this.apIKey)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    paysTax: ").append(this.toIndentedString(this.paysTax)).append("\n");
        sb.append("    version: ").append(this.toIndentedString((Object)this.version)).append("\n");
        sb.append("    organisationType: ").append(this.toIndentedString((Object)this.organisationType)).append("\n");
        sb.append("    baseCurrency: ").append(this.toIndentedString((Object)this.baseCurrency)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString((Object)this.countryCode)).append("\n");
        sb.append("    isDemoCompany: ").append(this.toIndentedString(this.isDemoCompany)).append("\n");
        sb.append("    organisationStatus: ").append(this.toIndentedString(this.organisationStatus)).append("\n");
        sb.append("    registrationNumber: ").append(this.toIndentedString(this.registrationNumber)).append("\n");
        sb.append("    taxNumber: ").append(this.toIndentedString(this.taxNumber)).append("\n");
        sb.append("    financialYearEndDay: ").append(this.toIndentedString(this.financialYearEndDay)).append("\n");
        sb.append("    financialYearEndMonth: ").append(this.toIndentedString(this.financialYearEndMonth)).append("\n");
        sb.append("    salesTaxBasis: ").append(this.toIndentedString((Object)this.salesTaxBasis)).append("\n");
        sb.append("    salesTaxPeriod: ").append(this.toIndentedString((Object)this.salesTaxPeriod)).append("\n");
        sb.append("    defaultSalesTax: ").append(this.toIndentedString(this.defaultSalesTax)).append("\n");
        sb.append("    defaultPurchasesTax: ").append(this.toIndentedString(this.defaultPurchasesTax)).append("\n");
        sb.append("    periodLockDate: ").append(this.toIndentedString(this.periodLockDate)).append("\n");
        sb.append("    endOfYearLockDate: ").append(this.toIndentedString(this.endOfYearLockDate)).append("\n");
        sb.append("    createdDateUTC: ").append(this.toIndentedString(this.createdDateUTC)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString((Object)this.timezone)).append("\n");
        sb.append("    organisationEntityType: ").append(this.toIndentedString((Object)this.organisationEntityType)).append("\n");
        sb.append("    shortCode: ").append(this.toIndentedString(this.shortCode)).append("\n");
        sb.append("    propertyClass: ").append(this.toIndentedString((Object)this.propertyClass)).append("\n");
        sb.append("    lineOfBusiness: ").append(this.toIndentedString(this.lineOfBusiness)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    phones: ").append(this.toIndentedString(this.phones)).append("\n");
        sb.append("    externalLinks: ").append(this.toIndentedString(this.externalLinks)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PropertyClassEnum {
        DEMO("DEMO"),
        TRIAL("TRIAL"),
        STARTER("STARTER"),
        STANDARD("STANDARD"),
        PREMIUM("PREMIUM"),
        PREMIUM_20("PREMIUM_20"),
        PREMIUM_50("PREMIUM_50"),
        PREMIUM_100("PREMIUM_100"),
        LEDGER("LEDGER"),
        GST_CASHBOOK("GST_CASHBOOK"),
        NON_GST_CASHBOOK("NON_GST_CASHBOOK");

        private String value;

        private PropertyClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PropertyClassEnum fromValue(String text) {
            for (PropertyClassEnum b : PropertyClassEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum OrganisationEntityTypeEnum {
        COMPANY("COMPANY"),
        CHARITY("CHARITY"),
        CLUBSOCIETY("CLUBSOCIETY"),
        PARTNERSHIP("PARTNERSHIP"),
        PRACTICE("PRACTICE"),
        PERSON("PERSON"),
        SOLETRADER("SOLETRADER"),
        TRUST("TRUST");

        private String value;

        private OrganisationEntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrganisationEntityTypeEnum fromValue(String text) {
            for (OrganisationEntityTypeEnum b : OrganisationEntityTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum SalesTaxPeriodEnum {
        MONTHLY("MONTHLY"),
        QUARTERLY1("QUARTERLY1"),
        QUARTERLY2("QUARTERLY2"),
        QUARTERLY3("QUARTERLY3"),
        ANNUALLY("ANNUALLY"),
        ONEMONTHS("ONEMONTHS"),
        TWOMONTHS("TWOMONTHS"),
        SIXMONTHS("SIXMONTHS"),
        _1MONTHLY("1MONTHLY"),
        _2MONTHLY("2MONTHLY"),
        _3MONTHLY("3MONTHLY"),
        _6MONTHLY("6MONTHLY"),
        QUARTERLY("QUARTERLY"),
        YEARLY("YEARLY");

        private String value;

        private SalesTaxPeriodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SalesTaxPeriodEnum fromValue(String text) {
            for (SalesTaxPeriodEnum b : SalesTaxPeriodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum SalesTaxBasisEnum {
        PAYMENTS("PAYMENTS"),
        INVOICE("INVOICE"),
        NONE("NONE"),
        CASH("CASH"),
        ACCRUAL("ACCRUAL"),
        FLATRATECASH("FLATRATECASH"),
        FLATRATEACCRUAL("FLATRATEACCRUAL"),
        ACCRUALS("ACCRUALS");

        private String value;

        private SalesTaxBasisEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SalesTaxBasisEnum fromValue(String text) {
            for (SalesTaxBasisEnum b : SalesTaxBasisEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum OrganisationTypeEnum {
        COMPANY("COMPANY"),
        CHARITY("CHARITY"),
        CLUBSOCIETY("CLUBSOCIETY"),
        PARTNERSHIP("PARTNERSHIP"),
        PRACTICE("PRACTICE"),
        PERSON("PERSON"),
        SOLETRADER("SOLETRADER"),
        TRUST("TRUST");

        private String value;

        private OrganisationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrganisationTypeEnum fromValue(String text) {
            for (OrganisationTypeEnum b : OrganisationTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum VersionEnum {
        AU("AU"),
        NZ("NZ"),
        GLOBAL("GLOBAL"),
        UK("UK"),
        US("US"),
        AUONRAMP("AUONRAMP"),
        NZONRAMP("NZONRAMP"),
        GLOBALONRAMP("GLOBALONRAMP"),
        UKONRAMP("UKONRAMP"),
        USONRAMP("USONRAMP");

        private String value;

        private VersionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VersionEnum fromValue(String text) {
            for (VersionEnum b : VersionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

