/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Allocation;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Payment;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Overpayment {
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact = null;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes = null;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = null;
    @JsonProperty(value="SubTotal")
    private Float subTotal;
    @JsonProperty(value="TotalTax")
    private Float totalTax;
    @JsonProperty(value="Total")
    private Float total;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode = null;
    @JsonProperty(value="OverpaymentID")
    private UUID overpaymentID;
    @JsonProperty(value="CurrencyRate")
    private Float currencyRate;
    @JsonProperty(value="RemainingCredit")
    private String remainingCredit;
    @JsonProperty(value="Allocations")
    private List<Allocation> allocations = null;
    @JsonProperty(value="Payments")
    private List<Payment> payments = null;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;

    public Overpayment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="See Overpayment Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Overpayment contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Overpayment date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="The date the overpayment is created YYYY-MM-DD")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Overpayment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Overpayment Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Overpayment lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public Overpayment lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public Overpayment addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="See Overpayment Line Items")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public Overpayment subTotal(Float subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="The subtotal of the overpayment excluding taxes")
    public Float getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Float subTotal) {
        this.subTotal = subTotal;
    }

    public Overpayment totalTax(Float totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="The total tax on the overpayment")
    public Float getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Float totalTax) {
        this.totalTax = totalTax;
    }

    public Overpayment total(Float total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="The total of the overpayment (subtotal + total tax)")
    public Float getTotal() {
        return this.total;
    }

    public void setTotal(Float total) {
        this.total = total;
    }

    public Overpayment updatedDateUTC(OffsetDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
        return this;
    }

    @ApiModelProperty(value="UTC timestamp of last update to the overpayment")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public void setUpdatedDateUTC(OffsetDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
    }

    public Overpayment currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Overpayment overpaymentID(UUID overpaymentID) {
        this.overpaymentID = overpaymentID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier")
    public UUID getOverpaymentID() {
        return this.overpaymentID;
    }

    public void setOverpaymentID(UUID overpaymentID) {
        this.overpaymentID = overpaymentID;
    }

    public Overpayment currencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com day rate is used")
    public Float getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
    }

    public Overpayment remainingCredit(String remainingCredit) {
        this.remainingCredit = remainingCredit;
        return this;
    }

    @ApiModelProperty(value="The remaining credit balance on the overpayment")
    public String getRemainingCredit() {
        return this.remainingCredit;
    }

    public void setRemainingCredit(String remainingCredit) {
        this.remainingCredit = remainingCredit;
    }

    public Overpayment allocations(List<Allocation> allocations) {
        this.allocations = allocations;
        return this;
    }

    public Overpayment addAllocationsItem(Allocation allocationsItem) {
        if (this.allocations == null) {
            this.allocations = new ArrayList<Allocation>();
        }
        this.allocations.add(allocationsItem);
        return this;
    }

    @ApiModelProperty(value="See Allocations")
    public List<Allocation> getAllocations() {
        return this.allocations;
    }

    public void setAllocations(List<Allocation> allocations) {
        this.allocations = allocations;
    }

    public Overpayment payments(List<Payment> payments) {
        this.payments = payments;
        return this;
    }

    public Overpayment addPaymentsItem(Payment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(value="See Payments")
    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    public Overpayment hasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    @ApiModelProperty(value="boolean to indicate if a overpayment has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public void setHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Overpayment overpayment = (Overpayment)o;
        return Objects.equals((Object)this.type, (Object)overpayment.type) && Objects.equals(this.contact, overpayment.contact) && Objects.equals(this.date, overpayment.date) && Objects.equals((Object)this.status, (Object)overpayment.status) && Objects.equals((Object)this.lineAmountTypes, (Object)overpayment.lineAmountTypes) && Objects.equals(this.lineItems, overpayment.lineItems) && Objects.equals(this.subTotal, overpayment.subTotal) && Objects.equals(this.totalTax, overpayment.totalTax) && Objects.equals(this.total, overpayment.total) && Objects.equals(this.updatedDateUTC, overpayment.updatedDateUTC) && Objects.equals((Object)this.currencyCode, (Object)overpayment.currencyCode) && Objects.equals(this.overpaymentID, overpayment.overpaymentID) && Objects.equals(this.currencyRate, overpayment.currencyRate) && Objects.equals(this.remainingCredit, overpayment.remainingCredit) && Objects.equals(this.allocations, overpayment.allocations) && Objects.equals(this.payments, overpayment.payments) && Objects.equals(this.hasAttachments, overpayment.hasAttachments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.date, this.status, this.lineAmountTypes, this.lineItems, this.subTotal, this.totalTax, this.total, this.updatedDateUTC, this.currencyCode, this.overpaymentID, this.currencyRate, this.remainingCredit, this.allocations, this.payments, this.hasAttachments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Overpayment {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    overpaymentID: ").append(this.toIndentedString(this.overpaymentID)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    remainingCredit: ").append(this.toIndentedString(this.remainingCredit)).append("\n");
        sb.append("    allocations: ").append(this.toIndentedString(this.allocations)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        AUTHORISED("AUTHORISED"),
        PAID("PAID"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum TypeEnum {
        RECEIVE_OVERPAYMENT("RECEIVE-OVERPAYMENT"),
        SPEND_OVERPAYMENT("SPEND-OVERPAYMENT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

