/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.CreditNote;
import com.xero.models.accounting.Invoice;
import com.xero.models.accounting.Overpayment;
import com.xero.models.accounting.Prepayment;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Payment {
    @JsonProperty(value="Invoice")
    private Invoice invoice = null;
    @JsonProperty(value="CreditNote")
    private CreditNote creditNote = null;
    @JsonProperty(value="Prepayment")
    private Prepayment prepayment = null;
    @JsonProperty(value="Overpayment")
    private Overpayment overpayment = null;
    @JsonProperty(value="InvoiceNumber")
    private String invoiceNumber;
    @JsonProperty(value="CreditNoteNumber")
    private String creditNoteNumber;
    @JsonProperty(value="Account")
    private Account account = null;
    @JsonProperty(value="Code")
    private String code;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="CurrencyRate")
    private Float currencyRate;
    @JsonProperty(value="Amount")
    private Float amount;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="IsReconciled")
    private String isReconciled;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="PaymentType")
    private PaymentTypeEnum paymentType;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="PaymentID")
    private UUID paymentID;
    @JsonProperty(value="BankAccountNumber")
    private String bankAccountNumber;
    @JsonProperty(value="Particulars")
    private String particulars;
    @JsonProperty(value="Details")
    private String details;

    public Payment invoice(Invoice invoice) {
        this.invoice = invoice;
        return this;
    }

    @ApiModelProperty(value="")
    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public Payment creditNote(CreditNote creditNote) {
        this.creditNote = creditNote;
        return this;
    }

    @ApiModelProperty(value="")
    public CreditNote getCreditNote() {
        return this.creditNote;
    }

    public void setCreditNote(CreditNote creditNote) {
        this.creditNote = creditNote;
    }

    public Payment prepayment(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    @ApiModelProperty(value="")
    public Prepayment getPrepayment() {
        return this.prepayment;
    }

    public void setPrepayment(Prepayment prepayment) {
        this.prepayment = prepayment;
    }

    public Payment overpayment(Overpayment overpayment) {
        this.overpayment = overpayment;
        return this;
    }

    @ApiModelProperty(value="")
    public Overpayment getOverpayment() {
        return this.overpayment;
    }

    public void setOverpayment(Overpayment overpayment) {
        this.overpayment = overpayment;
    }

    public Payment invoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
        return this;
    }

    @ApiModelProperty(value="Number of invoice or credit note you are applying payment to e.g.INV-4003")
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public Payment creditNoteNumber(String creditNoteNumber) {
        this.creditNoteNumber = creditNoteNumber;
        return this;
    }

    @ApiModelProperty(value="Number of invoice or credit note you are applying payment to e.g. INV-4003")
    public String getCreditNoteNumber() {
        return this.creditNoteNumber;
    }

    public void setCreditNoteNumber(String creditNoteNumber) {
        this.creditNoteNumber = creditNoteNumber;
    }

    public Payment account(Account account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(value="")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Payment code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="Code of account you are using to make the payment e.g. 001 (note- not all accounts have a code value)")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Payment date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Payment currencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="Exchange rate when payment is received. Only used for non base currency invoices and credit notes e.g. 0.7500")
    public Float getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Float currencyRate) {
        this.currencyRate = currencyRate;
    }

    public Payment amount(Float amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount of the payment. Must be less than or equal to the outstanding amount owing on the invoice e.g. 200.00")
    public Float getAmount() {
        return this.amount;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }

    public Payment reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="An optional description for the payment e.g. Direct Debit")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Payment isReconciled(String isReconciled) {
        this.isReconciled = isReconciled;
        return this;
    }

    @ApiModelProperty(value="An optional parameter for the payment. A boolean indicating whether you would like the payment to be created as reconciled when using PUT, or whether a payment has been reconciled when using GET")
    public String getIsReconciled() {
        return this.isReconciled;
    }

    public void setIsReconciled(String isReconciled) {
        this.isReconciled = isReconciled;
    }

    public Payment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the payment.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @ApiModelProperty(value="See Payment Types.")
    public PaymentTypeEnum getPaymentType() {
        return this.paymentType;
    }

    @ApiModelProperty(value="UTC timestamp of last update to the payment")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public Payment paymentID(UUID paymentID) {
        this.paymentID = paymentID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for an Payment e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9")
    public UUID getPaymentID() {
        return this.paymentID;
    }

    public void setPaymentID(UUID paymentID) {
        this.paymentID = paymentID;
    }

    public Payment bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @ApiModelProperty(value="The suppliers bank account number the payment is being made to")
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public Payment particulars(String particulars) {
        this.particulars = particulars;
        return this;
    }

    @ApiModelProperty(value="The suppliers bank account number the payment is being made to")
    public String getParticulars() {
        return this.particulars;
    }

    public void setParticulars(String particulars) {
        this.particulars = particulars;
    }

    public Payment details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(value="The information to appear on the supplier's bank account")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.invoice, payment.invoice) && Objects.equals(this.creditNote, payment.creditNote) && Objects.equals(this.prepayment, payment.prepayment) && Objects.equals(this.overpayment, payment.overpayment) && Objects.equals(this.invoiceNumber, payment.invoiceNumber) && Objects.equals(this.creditNoteNumber, payment.creditNoteNumber) && Objects.equals(this.account, payment.account) && Objects.equals(this.code, payment.code) && Objects.equals(this.date, payment.date) && Objects.equals(this.currencyRate, payment.currencyRate) && Objects.equals(this.amount, payment.amount) && Objects.equals(this.reference, payment.reference) && Objects.equals(this.isReconciled, payment.isReconciled) && Objects.equals((Object)this.status, (Object)payment.status) && Objects.equals((Object)this.paymentType, (Object)payment.paymentType) && Objects.equals(this.updatedDateUTC, payment.updatedDateUTC) && Objects.equals(this.paymentID, payment.paymentID) && Objects.equals(this.bankAccountNumber, payment.bankAccountNumber) && Objects.equals(this.particulars, payment.particulars) && Objects.equals(this.details, payment.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.invoice, this.creditNote, this.prepayment, this.overpayment, this.invoiceNumber, this.creditNoteNumber, this.account, this.code, this.date, this.currencyRate, this.amount, this.reference, this.isReconciled, this.status, this.paymentType, this.updatedDateUTC, this.paymentID, this.bankAccountNumber, this.particulars, this.details});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payment {\n");
        sb.append("    invoice: ").append(this.toIndentedString(this.invoice)).append("\n");
        sb.append("    creditNote: ").append(this.toIndentedString(this.creditNote)).append("\n");
        sb.append("    prepayment: ").append(this.toIndentedString(this.prepayment)).append("\n");
        sb.append("    overpayment: ").append(this.toIndentedString(this.overpayment)).append("\n");
        sb.append("    invoiceNumber: ").append(this.toIndentedString(this.invoiceNumber)).append("\n");
        sb.append("    creditNoteNumber: ").append(this.toIndentedString(this.creditNoteNumber)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    isReconciled: ").append(this.toIndentedString(this.isReconciled)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    paymentType: ").append(this.toIndentedString((Object)this.paymentType)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    paymentID: ").append(this.toIndentedString(this.paymentID)).append("\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    particulars: ").append(this.toIndentedString(this.particulars)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PaymentTypeEnum {
        ACCRECPAYMENT("ACCRECPAYMENT"),
        ACCPAYPAYMENT("ACCPAYPAYMENT"),
        ARCREDITPAYMENT("ARCREDITPAYMENT"),
        APCREDITPAYMENT("APCREDITPAYMENT"),
        AROVERPAYMENTPAYMENT("AROVERPAYMENTPAYMENT"),
        ARPREPAYMENTPAYMENT("ARPREPAYMENTPAYMENT"),
        APPREPAYMENTPAYMENT("APPREPAYMENTPAYMENT"),
        APOVERPAYMENTPAYMENT("APOVERPAYMENTPAYMENT");

        private String value;

        private PaymentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentTypeEnum fromValue(String text) {
            for (PaymentTypeEnum b : PaymentTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum StatusEnum {
        AUTHORISED("AUTHORISED"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

