/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.models.accounting.TaxType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Purchase {
    @JsonProperty(value="UnitPrice")
    private Float unitPrice;
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="COGSAccountCode")
    private String coGSAccountCode;
    @JsonProperty(value="TaxType")
    private TaxType taxType = null;

    public Purchase unitPrice(Float unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @ApiModelProperty(value="Unit Price of the item. By default UnitPrice is rounded to two decimal places. You can use 4 decimal places by adding the unitdp=4 querystring parameter to your request.")
    public Float getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Float unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Purchase accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="Default account code to be used for purchased/sale. Not applicable to the purchase details of tracked items")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public Purchase coGSAccountCode(String coGSAccountCode) {
        this.coGSAccountCode = coGSAccountCode;
        return this;
    }

    @ApiModelProperty(value="Cost of goods sold account. Only applicable to the purchase details of tracked items.")
    public String getCoGSAccountCode() {
        return this.coGSAccountCode;
    }

    public void setCoGSAccountCode(String coGSAccountCode) {
        this.coGSAccountCode = coGSAccountCode;
    }

    public Purchase taxType(TaxType taxType) {
        this.taxType = taxType;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxType getTaxType() {
        return this.taxType;
    }

    public void setTaxType(TaxType taxType) {
        this.taxType = taxType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Purchase purchase = (Purchase)o;
        return Objects.equals(this.unitPrice, purchase.unitPrice) && Objects.equals(this.accountCode, purchase.accountCode) && Objects.equals(this.coGSAccountCode, purchase.coGSAccountCode) && Objects.equals((Object)this.taxType, (Object)purchase.taxType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unitPrice, this.accountCode, this.coGSAccountCode, this.taxType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Purchase {\n");
        sb.append("    unitPrice: ").append(this.toIndentedString(this.unitPrice)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    coGSAccountCode: ").append(this.toIndentedString(this.coGSAccountCode)).append("\n");
        sb.append("    taxType: ").append(this.toIndentedString((Object)this.taxType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

