/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class PurchaseOrder {
    @JsonProperty(value="Contact")
    private Contact contact = null;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="DeliveryDate")
    private LocalDate deliveryDate;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes = null;
    @JsonProperty(value="PurchaseOrderNumber")
    private String purchaseOrderNumber;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode = null;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="SentToContact")
    private Boolean sentToContact;
    @JsonProperty(value="DeliveryAddress")
    private String deliveryAddress;
    @JsonProperty(value="AttentionTo")
    private String attentionTo;
    @JsonProperty(value="Telephone")
    private String telephone;
    @JsonProperty(value="DeliveryInstructions")
    private String deliveryInstructions;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="ExpectedArrivalDate")
    private LocalDate expectedArrivalDate;
    @JsonProperty(value="PurchaseOrderID")
    private UUID purchaseOrderID;
    @JsonProperty(value="CurrencyRate")
    private Float currencyRate;
    @JsonProperty(value="SubTotal")
    private Float subTotal;
    @JsonProperty(value="TotalTax")
    private Float totalTax;
    @JsonProperty(value="Total")
    private Float total;
    @JsonProperty(value="TotalDiscount")
    private Float totalDiscount;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;

    public PurchaseOrder contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public PurchaseOrder lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PurchaseOrder addLineItemsItem(LineItem lineItemsItem) {
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="See LineItems")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PurchaseOrder date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date purchase order was issued \u2013 YYYY-MM-DD. If the Date element is not specified then it will default to the current date based on the timezone setting of the organisation")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public PurchaseOrder deliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
        return this;
    }

    @ApiModelProperty(value="Date the goods are to be delivered \u2013 YYYY-MM-DD")
    public LocalDate getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public PurchaseOrder lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public PurchaseOrder purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @ApiModelProperty(value="Unique alpha numeric code identifying purchase order (when missing will auto-generate from your Organisation Invoice Settings)")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public PurchaseOrder reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PurchaseOrder brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="See BrandingThemes")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public PurchaseOrder currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PurchaseOrder status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Purchase Order Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PurchaseOrder sentToContact(Boolean sentToContact) {
        this.sentToContact = sentToContact;
        return this;
    }

    @ApiModelProperty(value="Boolean to set whether the purchase order should be marked as \u201csent\u201d. This can be set only on purchase orders that have been approved or billed")
    public Boolean getSentToContact() {
        return this.sentToContact;
    }

    public void setSentToContact(Boolean sentToContact) {
        this.sentToContact = sentToContact;
    }

    public PurchaseOrder deliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="The address the goods are to be delivered to")
    public String getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public PurchaseOrder attentionTo(String attentionTo) {
        this.attentionTo = attentionTo;
        return this;
    }

    @ApiModelProperty(value="The person that the delivery is going to")
    public String getAttentionTo() {
        return this.attentionTo;
    }

    public void setAttentionTo(String attentionTo) {
        this.attentionTo = attentionTo;
    }

    public PurchaseOrder telephone(String telephone) {
        this.telephone = telephone;
        return this;
    }

    @ApiModelProperty(value="The phone number for the person accepting the delivery")
    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public PurchaseOrder deliveryInstructions(String deliveryInstructions) {
        this.deliveryInstructions = deliveryInstructions;
        return this;
    }

    @ApiModelProperty(value="A free text feild for instructions (500 characters max)")
    public String getDeliveryInstructions() {
        return this.deliveryInstructions;
    }

    public void setDeliveryInstructions(String deliveryInstructions) {
        this.deliveryInstructions = deliveryInstructions;
    }

    public PurchaseOrder expectedArrivalDate(LocalDate expectedArrivalDate) {
        this.expectedArrivalDate = expectedArrivalDate;
        return this;
    }

    @ApiModelProperty(value="The date the goods are expected to arrive.")
    public LocalDate getExpectedArrivalDate() {
        return this.expectedArrivalDate;
    }

    public void setExpectedArrivalDate(LocalDate expectedArrivalDate) {
        this.expectedArrivalDate = expectedArrivalDate;
    }

    public PurchaseOrder purchaseOrderID(UUID purchaseOrderID) {
        this.purchaseOrderID = purchaseOrderID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for purchase order")
    public UUID getPurchaseOrderID() {
        return this.purchaseOrderID;
    }

    public void setPurchaseOrderID(UUID purchaseOrderID) {
        this.purchaseOrderID = purchaseOrderID;
    }

    @ApiModelProperty(value="The currency rate for a multicurrency purchase order. As no rate can  be specified, the XE.com day rate is used.")
    public Float getCurrencyRate() {
        return this.currencyRate;
    }

    @ApiModelProperty(value="Total of purchase order excluding taxes")
    public Float getSubTotal() {
        return this.subTotal;
    }

    @ApiModelProperty(value="Total tax on purchase order")
    public Float getTotalTax() {
        return this.totalTax;
    }

    @ApiModelProperty(value="Total of Purchase Order tax inclusive (i.e. SubTotal + TotalTax)")
    public Float getTotal() {
        return this.total;
    }

    @ApiModelProperty(value="Total of discounts applied on the purchase order line items")
    public Float getTotalDiscount() {
        return this.totalDiscount;
    }

    @ApiModelProperty(value="boolean to indicate if a purchase order has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(value="Last modified date UTC format")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchaseOrder purchaseOrder = (PurchaseOrder)o;
        return Objects.equals(this.contact, purchaseOrder.contact) && Objects.equals(this.lineItems, purchaseOrder.lineItems) && Objects.equals(this.date, purchaseOrder.date) && Objects.equals(this.deliveryDate, purchaseOrder.deliveryDate) && Objects.equals((Object)this.lineAmountTypes, (Object)purchaseOrder.lineAmountTypes) && Objects.equals(this.purchaseOrderNumber, purchaseOrder.purchaseOrderNumber) && Objects.equals(this.reference, purchaseOrder.reference) && Objects.equals(this.brandingThemeID, purchaseOrder.brandingThemeID) && Objects.equals((Object)this.currencyCode, (Object)purchaseOrder.currencyCode) && Objects.equals((Object)this.status, (Object)purchaseOrder.status) && Objects.equals(this.sentToContact, purchaseOrder.sentToContact) && Objects.equals(this.deliveryAddress, purchaseOrder.deliveryAddress) && Objects.equals(this.attentionTo, purchaseOrder.attentionTo) && Objects.equals(this.telephone, purchaseOrder.telephone) && Objects.equals(this.deliveryInstructions, purchaseOrder.deliveryInstructions) && Objects.equals(this.expectedArrivalDate, purchaseOrder.expectedArrivalDate) && Objects.equals(this.purchaseOrderID, purchaseOrder.purchaseOrderID) && Objects.equals(this.currencyRate, purchaseOrder.currencyRate) && Objects.equals(this.subTotal, purchaseOrder.subTotal) && Objects.equals(this.totalTax, purchaseOrder.totalTax) && Objects.equals(this.total, purchaseOrder.total) && Objects.equals(this.totalDiscount, purchaseOrder.totalDiscount) && Objects.equals(this.hasAttachments, purchaseOrder.hasAttachments) && Objects.equals(this.updatedDateUTC, purchaseOrder.updatedDateUTC);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contact, this.lineItems, this.date, this.deliveryDate, this.lineAmountTypes, this.purchaseOrderNumber, this.reference, this.brandingThemeID, this.currencyCode, this.status, this.sentToContact, this.deliveryAddress, this.attentionTo, this.telephone, this.deliveryInstructions, this.expectedArrivalDate, this.purchaseOrderID, this.currencyRate, this.subTotal, this.totalTax, this.total, this.totalDiscount, this.hasAttachments, this.updatedDateUTC});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PurchaseOrder {\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    deliveryDate: ").append(this.toIndentedString(this.deliveryDate)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sentToContact: ").append(this.toIndentedString(this.sentToContact)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    attentionTo: ").append(this.toIndentedString(this.attentionTo)).append("\n");
        sb.append("    telephone: ").append(this.toIndentedString(this.telephone)).append("\n");
        sb.append("    deliveryInstructions: ").append(this.toIndentedString(this.deliveryInstructions)).append("\n");
        sb.append("    expectedArrivalDate: ").append(this.toIndentedString(this.expectedArrivalDate)).append("\n");
        sb.append("    purchaseOrderID: ").append(this.toIndentedString(this.purchaseOrderID)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    totalDiscount: ").append(this.toIndentedString(this.totalDiscount)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        SUBMITTED("SUBMITTED"),
        AUTHORISED("AUTHORISED"),
        BILLED("BILLED"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

