/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.User;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Receipt {
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="Date")
    private LocalDate date;
    @JsonProperty(value="Contact")
    private Contact contact = null;
    @JsonProperty(value="Lineitems")
    private List<LineItem> lineitems = new ArrayList<LineItem>();
    @JsonProperty(value="User")
    private User user = null;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes = null;
    @JsonProperty(value="SubTotal")
    private Float subTotal;
    @JsonProperty(value="TotalTax")
    private Float totalTax;
    @JsonProperty(value="Total")
    private Float total;
    @JsonProperty(value="ReceiptID")
    private UUID receiptID;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="ReceiptNumber")
    private String receiptNumber;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;
    @JsonProperty(value="Url")
    private String url;

    public Receipt date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="Date of receipt \u2013 YYYY-MM-DD")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Receipt contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Receipt lineitems(List<LineItem> lineitems) {
        this.lineitems = lineitems;
        return this;
    }

    public Receipt addLineitemsItem(LineItem lineitemsItem) {
        this.lineitems.add(lineitemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<LineItem> getLineitems() {
        return this.lineitems;
    }

    public void setLineitems(List<LineItem> lineitems) {
        this.lineitems = lineitems;
    }

    public Receipt user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Receipt reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Receipt lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public Receipt subTotal(Float subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="Total of receipt excluding taxes")
    public Float getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Float subTotal) {
        this.subTotal = subTotal;
    }

    public Receipt totalTax(Float totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="Total tax on receipt")
    public Float getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Float totalTax) {
        this.totalTax = totalTax;
    }

    public Receipt total(Float total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total of receipt tax inclusive (i.e. SubTotal + TotalTax)")
    public Float getTotal() {
        return this.total;
    }

    public void setTotal(Float total) {
        this.total = total;
    }

    public Receipt receiptID(UUID receiptID) {
        this.receiptID = receiptID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for receipt")
    public UUID getReceiptID() {
        return this.receiptID;
    }

    public void setReceiptID(UUID receiptID) {
        this.receiptID = receiptID;
    }

    public Receipt status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Current status of receipt \u2013 see status types")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @ApiModelProperty(value="Xero generated sequence number for receipt in current claim for a given user")
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @ApiModelProperty(value="Last modified date UTC format")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    @ApiModelProperty(value="boolean to indicate if a receipt has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(value="URL link to a source document \u2013 shown as \u201cGo to [appName]\u201d in the Xero app")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Receipt receipt = (Receipt)o;
        return Objects.equals(this.date, receipt.date) && Objects.equals(this.contact, receipt.contact) && Objects.equals(this.lineitems, receipt.lineitems) && Objects.equals(this.user, receipt.user) && Objects.equals(this.reference, receipt.reference) && Objects.equals((Object)this.lineAmountTypes, (Object)receipt.lineAmountTypes) && Objects.equals(this.subTotal, receipt.subTotal) && Objects.equals(this.totalTax, receipt.totalTax) && Objects.equals(this.total, receipt.total) && Objects.equals(this.receiptID, receipt.receiptID) && Objects.equals((Object)this.status, (Object)receipt.status) && Objects.equals(this.receiptNumber, receipt.receiptNumber) && Objects.equals(this.updatedDateUTC, receipt.updatedDateUTC) && Objects.equals(this.hasAttachments, receipt.hasAttachments) && Objects.equals(this.url, receipt.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.date, this.contact, this.lineitems, this.user, this.reference, this.lineAmountTypes, this.subTotal, this.totalTax, this.total, this.receiptID, this.status, this.receiptNumber, this.updatedDateUTC, this.hasAttachments, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Receipt {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    lineitems: ").append(this.toIndentedString(this.lineitems)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    receiptID: ").append(this.toIndentedString(this.receiptID)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    receiptNumber: ").append(this.toIndentedString(this.receiptNumber)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        SUBMITTED("SUBMITTED"),
        AUTHORIZED("AUTHORIZED"),
        DECLINED("DECLINED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

