/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Schedule;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class RepeatingInvoice {
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact = null;
    @JsonProperty(value="Schedule")
    private Schedule schedule = null;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = null;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes = null;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode = null;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="SubTotal")
    private Float subTotal;
    @JsonProperty(value="TotalTax")
    private Float totalTax;
    @JsonProperty(value="Total")
    private Float total;
    @JsonProperty(value="RepeatingInvoiceID")
    private UUID repeatingInvoiceID;
    @JsonProperty(value="ID")
    private UUID ID;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments;

    public RepeatingInvoice type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="See Invoice Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RepeatingInvoice contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public RepeatingInvoice schedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(value="")
    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public RepeatingInvoice lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public RepeatingInvoice addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="See LineItems")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public RepeatingInvoice lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public RepeatingInvoice reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="ACCREC only \u2013 additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public RepeatingInvoice brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="See BrandingThemes")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public RepeatingInvoice currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public RepeatingInvoice status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="One of the following - DRAFT or AUTHORISED \u2013 See Invoice Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public RepeatingInvoice subTotal(Float subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="Total of invoice excluding taxes")
    public Float getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Float subTotal) {
        this.subTotal = subTotal;
    }

    public RepeatingInvoice totalTax(Float totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="Total tax on invoice")
    public Float getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Float totalTax) {
        this.totalTax = totalTax;
    }

    public RepeatingInvoice total(Float total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total of Invoice tax inclusive (i.e. SubTotal + TotalTax)")
    public Float getTotal() {
        return this.total;
    }

    public void setTotal(Float total) {
        this.total = total;
    }

    public RepeatingInvoice repeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for repeating invoice template")
    public UUID getRepeatingInvoiceID() {
        return this.repeatingInvoiceID;
    }

    public void setRepeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
    }

    public RepeatingInvoice ID(UUID ID) {
        this.ID = ID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for repeating invoice template")
    public UUID getID() {
        return this.ID;
    }

    public void setID(UUID ID) {
        this.ID = ID;
    }

    public RepeatingInvoice hasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    @ApiModelProperty(value="boolean to indicate if an invoice has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public void setHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatingInvoice repeatingInvoice = (RepeatingInvoice)o;
        return Objects.equals((Object)this.type, (Object)repeatingInvoice.type) && Objects.equals(this.contact, repeatingInvoice.contact) && Objects.equals(this.schedule, repeatingInvoice.schedule) && Objects.equals(this.lineItems, repeatingInvoice.lineItems) && Objects.equals((Object)this.lineAmountTypes, (Object)repeatingInvoice.lineAmountTypes) && Objects.equals(this.reference, repeatingInvoice.reference) && Objects.equals(this.brandingThemeID, repeatingInvoice.brandingThemeID) && Objects.equals((Object)this.currencyCode, (Object)repeatingInvoice.currencyCode) && Objects.equals((Object)this.status, (Object)repeatingInvoice.status) && Objects.equals(this.subTotal, repeatingInvoice.subTotal) && Objects.equals(this.totalTax, repeatingInvoice.totalTax) && Objects.equals(this.total, repeatingInvoice.total) && Objects.equals(this.repeatingInvoiceID, repeatingInvoice.repeatingInvoiceID) && Objects.equals(this.ID, repeatingInvoice.ID) && Objects.equals(this.hasAttachments, repeatingInvoice.hasAttachments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.schedule, this.lineItems, this.lineAmountTypes, this.reference, this.brandingThemeID, this.currencyCode, this.status, this.subTotal, this.totalTax, this.total, this.repeatingInvoiceID, this.ID, this.hasAttachments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepeatingInvoice {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    repeatingInvoiceID: ").append(this.toIndentedString(this.repeatingInvoiceID)).append("\n");
        sb.append("    ID: ").append(this.toIndentedString(this.ID)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        AUTHORISED("AUTHORISED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum TypeEnum {
        ACCPAY("ACCPAY"),
        ACCREC("ACCREC");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

