/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.TenNinteyNineContact;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class Report {
    @JsonProperty(value="ReportID")
    private String reportID;
    @JsonProperty(value="ReportName")
    private String reportName;
    @JsonProperty(value="ReportType")
    private ReportTypeEnum reportType;
    @JsonProperty(value="ReportTitle")
    private String reportTitle;
    @JsonProperty(value="ReportDate")
    private String reportDate;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="Contacts")
    private List<TenNinteyNineContact> contacts = null;

    public Report reportID(String reportID) {
        this.reportID = reportID;
        return this;
    }

    @ApiModelProperty(value="See Prepayment Types")
    public String getReportID() {
        return this.reportID;
    }

    public void setReportID(String reportID) {
        this.reportID = reportID;
    }

    public Report reportName(String reportName) {
        this.reportName = reportName;
        return this;
    }

    @ApiModelProperty(value="See Prepayment Types")
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public Report reportType(ReportTypeEnum reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(value="See Prepayment Types")
    public ReportTypeEnum getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportTypeEnum reportType) {
        this.reportType = reportType;
    }

    public Report reportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
        return this;
    }

    @ApiModelProperty(value="See Prepayment Types")
    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public Report reportDate(String reportDate) {
        this.reportDate = reportDate;
        return this;
    }

    @ApiModelProperty(value="Date of report")
    public String getReportDate() {
        return this.reportDate;
    }

    public void setReportDate(String reportDate) {
        this.reportDate = reportDate;
    }

    public Report updatedDateUTC(OffsetDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
        return this;
    }

    @ApiModelProperty(value="Updated Date")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public void setUpdatedDateUTC(OffsetDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
    }

    public Report contacts(List<TenNinteyNineContact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public Report addContactsItem(TenNinteyNineContact contactsItem) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<TenNinteyNineContact>();
        }
        this.contacts.add(contactsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TenNinteyNineContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<TenNinteyNineContact> contacts) {
        this.contacts = contacts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        return Objects.equals(this.reportID, report.reportID) && Objects.equals(this.reportName, report.reportName) && Objects.equals((Object)this.reportType, (Object)report.reportType) && Objects.equals(this.reportTitle, report.reportTitle) && Objects.equals(this.reportDate, report.reportDate) && Objects.equals(this.updatedDateUTC, report.updatedDateUTC) && Objects.equals(this.contacts, report.contacts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reportID, this.reportName, this.reportType, this.reportTitle, this.reportDate, this.updatedDateUTC, this.contacts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Report {\n");
        sb.append("    reportID: ").append(this.toIndentedString(this.reportID)).append("\n");
        sb.append("    reportName: ").append(this.toIndentedString(this.reportName)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString((Object)this.reportType)).append("\n");
        sb.append("    reportTitle: ").append(this.toIndentedString(this.reportTitle)).append("\n");
        sb.append("    reportDate: ").append(this.toIndentedString(this.reportDate)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    contacts: ").append(this.toIndentedString(this.contacts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReportTypeEnum {
        AGEDPAYABLESBYCONTACT("AgedPayablesByContact");

        private String value;

        private ReportTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReportTypeEnum fromValue(String text) {
            for (ReportTypeEnum b : ReportTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

