/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomOffsetDateTimeDeserializer;
import com.xero.models.accounting.ReportFields;
import com.xero.models.accounting.ReportRows;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

public class ReportWithRow {
    @JsonProperty(value="ReportID")
    private String reportID;
    @JsonProperty(value="ReportName")
    private String reportName;
    @JsonProperty(value="ReportTitle")
    private String reportTitle;
    @JsonProperty(value="ReportType")
    private String reportType;
    @JsonProperty(value="ReportTitles")
    private List<String> reportTitles = null;
    @JsonProperty(value="ReportDate")
    private String reportDate;
    @JsonDeserialize(using=CustomOffsetDateTimeDeserializer.class)
    @JsonProperty(value="UpdatedDateUTC")
    private OffsetDateTime updatedDateUTC;
    @JsonProperty(value="Rows")
    private List<ReportRows> rows = null;
    @JsonProperty(value="Fields")
    private List<ReportFields> fields = null;

    public ReportWithRow reportID(String reportID) {
        this.reportID = reportID;
        return this;
    }

    @ApiModelProperty(value="Report id")
    public String getReportID() {
        return this.reportID;
    }

    public void setReportID(String reportID) {
        this.reportID = reportID;
    }

    public ReportWithRow reportName(String reportName) {
        this.reportName = reportName;
        return this;
    }

    @ApiModelProperty(value="Name of the report")
    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public ReportWithRow reportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
        return this;
    }

    @ApiModelProperty(value="Title of the report")
    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public ReportWithRow reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(value="The type of report (BalanceSheet,ProfitLoss, etc)")
    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public ReportWithRow reportTitles(List<String> reportTitles) {
        this.reportTitles = reportTitles;
        return this;
    }

    public ReportWithRow addReportTitlesItem(String reportTitlesItem) {
        if (this.reportTitles == null) {
            this.reportTitles = new ArrayList<String>();
        }
        this.reportTitles.add(reportTitlesItem);
        return this;
    }

    @ApiModelProperty(value="Report titles array (3 to 4 strings with the report name, orgnisation name and time frame of report)")
    public List<String> getReportTitles() {
        return this.reportTitles;
    }

    public void setReportTitles(List<String> reportTitles) {
        this.reportTitles = reportTitles;
    }

    public ReportWithRow reportDate(String reportDate) {
        this.reportDate = reportDate;
        return this;
    }

    @ApiModelProperty(value="Date of report")
    public String getReportDate() {
        return this.reportDate;
    }

    public void setReportDate(String reportDate) {
        this.reportDate = reportDate;
    }

    public ReportWithRow updatedDateUTC(OffsetDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
        return this;
    }

    @ApiModelProperty(value="Updated Date")
    public OffsetDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public void setUpdatedDateUTC(OffsetDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
    }

    public ReportWithRow rows(List<ReportRows> rows) {
        this.rows = rows;
        return this;
    }

    public ReportWithRow addRowsItem(ReportRows rowsItem) {
        if (this.rows == null) {
            this.rows = new ArrayList<ReportRows>();
        }
        this.rows.add(rowsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ReportRows> getRows() {
        return this.rows;
    }

    public void setRows(List<ReportRows> rows) {
        this.rows = rows;
    }

    public ReportWithRow fields(List<ReportFields> fields) {
        this.fields = fields;
        return this;
    }

    public ReportWithRow addFieldsItem(ReportFields fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<ReportFields>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ReportFields> getFields() {
        return this.fields;
    }

    public void setFields(List<ReportFields> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportWithRow reportWithRow = (ReportWithRow)o;
        return Objects.equals(this.reportID, reportWithRow.reportID) && Objects.equals(this.reportName, reportWithRow.reportName) && Objects.equals(this.reportTitle, reportWithRow.reportTitle) && Objects.equals(this.reportType, reportWithRow.reportType) && Objects.equals(this.reportTitles, reportWithRow.reportTitles) && Objects.equals(this.reportDate, reportWithRow.reportDate) && Objects.equals(this.updatedDateUTC, reportWithRow.updatedDateUTC) && Objects.equals(this.rows, reportWithRow.rows) && Objects.equals(this.fields, reportWithRow.fields);
    }

    public int hashCode() {
        return Objects.hash(this.reportID, this.reportName, this.reportTitle, this.reportType, this.reportTitles, this.reportDate, this.updatedDateUTC, this.rows, this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportWithRow {\n");
        sb.append("    reportID: ").append(this.toIndentedString(this.reportID)).append("\n");
        sb.append("    reportName: ").append(this.toIndentedString(this.reportName)).append("\n");
        sb.append("    reportTitle: ").append(this.toIndentedString(this.reportTitle)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString(this.reportType)).append("\n");
        sb.append("    reportTitles: ").append(this.toIndentedString(this.reportTitles)).append("\n");
        sb.append("    reportDate: ").append(this.toIndentedString(this.reportDate)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    rows: ").append(this.toIndentedString(this.rows)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

