/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.xero.api.CustomDateDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

public class Schedule {
    @JsonProperty(value="Period")
    private Integer period;
    @JsonProperty(value="Unit")
    private UnitEnum unit;
    @JsonProperty(value="DueDate")
    private Integer dueDate;
    @JsonProperty(value="DueDateType")
    private DueDateTypeEnum dueDateType;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="StartDate")
    private LocalDate startDate;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="NextScheduledDate")
    private LocalDate nextScheduledDate;
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonProperty(value="EndDate")
    private LocalDate endDate;

    public Schedule period(Integer period) {
        this.period = period;
        return this;
    }

    @ApiModelProperty(value="Integer used with the unit e.g. 1 (every 1 week), 2 (every 2 months)")
    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Schedule unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(value="One of the following - WEEKLY or MONTHLY")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public Schedule dueDate(Integer dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(value="Integer used with due date type e.g 20 (of following month), 31 (of current month)")
    public Integer getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Integer dueDate) {
        this.dueDate = dueDate;
    }

    public Schedule dueDateType(DueDateTypeEnum dueDateType) {
        this.dueDateType = dueDateType;
        return this;
    }

    @ApiModelProperty(value="the payment terms")
    public DueDateTypeEnum getDueDateType() {
        return this.dueDateType;
    }

    public void setDueDateType(DueDateTypeEnum dueDateType) {
        this.dueDateType = dueDateType;
    }

    public Schedule startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="Date the first invoice of the current version of the repeating schedule was generated (changes when repeating invoice is edited)")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Schedule nextScheduledDate(LocalDate nextScheduledDate) {
        this.nextScheduledDate = nextScheduledDate;
        return this;
    }

    @ApiModelProperty(value="The calendar date of the next invoice in the schedule to be generated")
    public LocalDate getNextScheduledDate() {
        return this.nextScheduledDate;
    }

    public void setNextScheduledDate(LocalDate nextScheduledDate) {
        this.nextScheduledDate = nextScheduledDate;
    }

    public Schedule endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="Invoice end date \u2013 only returned if the template has an end date set")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schedule schedule = (Schedule)o;
        return Objects.equals(this.period, schedule.period) && Objects.equals((Object)this.unit, (Object)schedule.unit) && Objects.equals(this.dueDate, schedule.dueDate) && Objects.equals((Object)this.dueDateType, (Object)schedule.dueDateType) && Objects.equals(this.startDate, schedule.startDate) && Objects.equals(this.nextScheduledDate, schedule.nextScheduledDate) && Objects.equals(this.endDate, schedule.endDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.period, this.unit, this.dueDate, this.dueDateType, this.startDate, this.nextScheduledDate, this.endDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Schedule {\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    dueDateType: ").append(this.toIndentedString((Object)this.dueDateType)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    nextScheduledDate: ").append(this.toIndentedString(this.nextScheduledDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DueDateTypeEnum {
        DAYSAFTERBILLDATE("DAYSAFTERBILLDATE"),
        DAYSAFTERBILLMONTH("DAYSAFTERBILLMONTH"),
        OFCURRENTMONTH("OFCURRENTMONTH"),
        OFFOLLOWINGMONTH("OFFOLLOWINGMONTH");

        private String value;

        private DueDateTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DueDateTypeEnum fromValue(String text) {
            for (DueDateTypeEnum b : DueDateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum UnitEnum {
        WEEKLY("WEEKLY"),
        MONTHLY("MONTHLY");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UnitEnum fromValue(String text) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

