/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.TaxComponent;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaxRate {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="TaxType")
    private String taxType;
    @JsonProperty(value="TaxComponents")
    private List<TaxComponent> taxComponents = null;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="ReportTaxType")
    private ReportTaxTypeEnum reportTaxType;
    @JsonProperty(value="CanApplyToAssets")
    private Boolean canApplyToAssets;
    @JsonProperty(value="CanApplyToEquity")
    private Boolean canApplyToEquity;
    @JsonProperty(value="CanApplyToExpenses")
    private Boolean canApplyToExpenses;
    @JsonProperty(value="CanApplyToLiabilities")
    private Boolean canApplyToLiabilities;
    @JsonProperty(value="CanApplyToRevenue")
    private Boolean canApplyToRevenue;
    @JsonProperty(value="DisplayTaxRate")
    private Float displayTaxRate;
    @JsonProperty(value="EffectiveRate")
    private Float effectiveRate;

    public TaxRate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of tax rate")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaxRate taxType(String taxType) {
        this.taxType = taxType;
        return this;
    }

    @ApiModelProperty(value="The tax type")
    public String getTaxType() {
        return this.taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public TaxRate taxComponents(List<TaxComponent> taxComponents) {
        this.taxComponents = taxComponents;
        return this;
    }

    public TaxRate addTaxComponentsItem(TaxComponent taxComponentsItem) {
        if (this.taxComponents == null) {
            this.taxComponents = new ArrayList<TaxComponent>();
        }
        this.taxComponents.add(taxComponentsItem);
        return this;
    }

    @ApiModelProperty(value="See TaxComponents")
    public List<TaxComponent> getTaxComponents() {
        return this.taxComponents;
    }

    public void setTaxComponents(List<TaxComponent> taxComponents) {
        this.taxComponents = taxComponents;
    }

    public TaxRate status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TaxRate reportTaxType(ReportTaxTypeEnum reportTaxType) {
        this.reportTaxType = reportTaxType;
        return this;
    }

    @ApiModelProperty(required=true, value="See ReportTaxTypes")
    public ReportTaxTypeEnum getReportTaxType() {
        return this.reportTaxType;
    }

    public void setReportTaxType(ReportTaxTypeEnum reportTaxType) {
        this.reportTaxType = reportTaxType;
    }

    @ApiModelProperty(value="Boolean to describe if tax rate can be used for asset accounts i.e.  true,false")
    public Boolean getCanApplyToAssets() {
        return this.canApplyToAssets;
    }

    @ApiModelProperty(value="Boolean to describe if tax rate can be used for equity accounts i.e true,false")
    public Boolean getCanApplyToEquity() {
        return this.canApplyToEquity;
    }

    @ApiModelProperty(value="Boolean to describe if tax rate can be used for expense accounts  i.e. true,false")
    public Boolean getCanApplyToExpenses() {
        return this.canApplyToExpenses;
    }

    @ApiModelProperty(value="Boolean to describe if tax rate can be used for liability accounts  i.e. true,false")
    public Boolean getCanApplyToLiabilities() {
        return this.canApplyToLiabilities;
    }

    @ApiModelProperty(value="Boolean to describe if tax rate can be used for revenue accounts i.e. true,false")
    public Boolean getCanApplyToRevenue() {
        return this.canApplyToRevenue;
    }

    @ApiModelProperty(value="Tax Rate (decimal to 4dp) e.g 12.5000")
    public Float getDisplayTaxRate() {
        return this.displayTaxRate;
    }

    @ApiModelProperty(value="Effective Tax Rate (decimal to 4dp) e.g 12.5000")
    public Float getEffectiveRate() {
        return this.effectiveRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxRate taxRate = (TaxRate)o;
        return Objects.equals(this.name, taxRate.name) && Objects.equals(this.taxType, taxRate.taxType) && Objects.equals(this.taxComponents, taxRate.taxComponents) && Objects.equals((Object)this.status, (Object)taxRate.status) && Objects.equals((Object)this.reportTaxType, (Object)taxRate.reportTaxType) && Objects.equals(this.canApplyToAssets, taxRate.canApplyToAssets) && Objects.equals(this.canApplyToEquity, taxRate.canApplyToEquity) && Objects.equals(this.canApplyToExpenses, taxRate.canApplyToExpenses) && Objects.equals(this.canApplyToLiabilities, taxRate.canApplyToLiabilities) && Objects.equals(this.canApplyToRevenue, taxRate.canApplyToRevenue) && Objects.equals(this.displayTaxRate, taxRate.displayTaxRate) && Objects.equals(this.effectiveRate, taxRate.effectiveRate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.taxType, this.taxComponents, this.status, this.reportTaxType, this.canApplyToAssets, this.canApplyToEquity, this.canApplyToExpenses, this.canApplyToLiabilities, this.canApplyToRevenue, this.displayTaxRate, this.effectiveRate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxRate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    taxType: ").append(this.toIndentedString(this.taxType)).append("\n");
        sb.append("    taxComponents: ").append(this.toIndentedString(this.taxComponents)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reportTaxType: ").append(this.toIndentedString((Object)this.reportTaxType)).append("\n");
        sb.append("    canApplyToAssets: ").append(this.toIndentedString(this.canApplyToAssets)).append("\n");
        sb.append("    canApplyToEquity: ").append(this.toIndentedString(this.canApplyToEquity)).append("\n");
        sb.append("    canApplyToExpenses: ").append(this.toIndentedString(this.canApplyToExpenses)).append("\n");
        sb.append("    canApplyToLiabilities: ").append(this.toIndentedString(this.canApplyToLiabilities)).append("\n");
        sb.append("    canApplyToRevenue: ").append(this.toIndentedString(this.canApplyToRevenue)).append("\n");
        sb.append("    displayTaxRate: ").append(this.toIndentedString(this.displayTaxRate)).append("\n");
        sb.append("    effectiveRate: ").append(this.toIndentedString(this.effectiveRate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReportTaxTypeEnum {
        OUTPUT("OUTPUT"),
        INPUT("INPUT"),
        EXEMPTOUTPUT("EXEMPTOUTPUT"),
        INPUTTAXED("INPUTTAXED"),
        BASEXCLUDED("BASEXCLUDED"),
        EXEMPTEXPENSES("EXEMPTEXPENSES"),
        EXEMPTINPUT("EXEMPTINPUT"),
        ECOUTPUT("ECOUTPUT"),
        ECOUTPUTSERVICES("ECOUTPUTSERVICES"),
        ECINPUT("ECINPUT"),
        ECACQUISITIONS("ECACQUISITIONS"),
        CAPITALSALESOUTPUT("CAPITALSALESOUTPUT"),
        CAPITALEXPENSESINPUT("CAPITALEXPENSESINPUT"),
        MOSSSALES("MOSSSALES"),
        NONE("NONE"),
        GSTONIMPORTS("GSTONIMPORTS");

        private String value;

        private ReportTaxTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReportTaxTypeEnum fromValue(String text) {
            for (ReportTaxTypeEnum b : ReportTaxTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        DELETED("DELETED"),
        ARCHIVED("ARCHIVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

