/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.accounting.TrackingOption;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class TrackingCategory {
    @JsonProperty(value="TrackingCategoryID")
    private UUID trackingCategoryID;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="Options")
    private List<TrackingOption> options = null;

    public TrackingCategory trackingCategoryID(UUID trackingCategoryID) {
        this.trackingCategoryID = trackingCategoryID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a tracking categorye.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9")
    public UUID getTrackingCategoryID() {
        return this.trackingCategoryID;
    }

    public void setTrackingCategoryID(UUID trackingCategoryID) {
        this.trackingCategoryID = trackingCategoryID;
    }

    public TrackingCategory name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the tracking category e.g. Department, Region (max length = 100)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TrackingCategory status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of a tracking category")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TrackingCategory options(List<TrackingOption> options) {
        this.options = options;
        return this;
    }

    public TrackingCategory addOptionsItem(TrackingOption optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<TrackingOption>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="See Tracking Options")
    public List<TrackingOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<TrackingOption> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackingCategory trackingCategory = (TrackingCategory)o;
        return Objects.equals(this.trackingCategoryID, trackingCategory.trackingCategoryID) && Objects.equals(this.name, trackingCategory.name) && Objects.equals((Object)this.status, (Object)trackingCategory.status) && Objects.equals(this.options, trackingCategory.options);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.trackingCategoryID, this.name, this.status, this.options});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrackingCategory {\n");
        sb.append("    trackingCategoryID: ").append(this.toIndentedString(this.trackingCategoryID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        ARCHIVED("ARCHIVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

