/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class TrackingOption {
    @JsonProperty(value="TrackingOptionID")
    private UUID trackingOptionID;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="TrackingCategoryID")
    private UUID trackingCategoryID;

    public TrackingOption trackingOptionID(UUID trackingOptionID) {
        this.trackingOptionID = trackingOptionID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a tracking optione.g. ae777a87-5ef3-4fa0-a4f0-d10e1f13073a")
    public UUID getTrackingOptionID() {
        return this.trackingOptionID;
    }

    public void setTrackingOptionID(UUID trackingOptionID) {
        this.trackingOptionID = trackingOptionID;
    }

    public TrackingOption name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the tracking option e.g. Marketing, East (max length = 50)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TrackingOption status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of a tracking option")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TrackingOption trackingCategoryID(UUID trackingCategoryID) {
        this.trackingCategoryID = trackingCategoryID;
        return this;
    }

    @ApiModelProperty(value="Filter by a tracking categorye.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9")
    public UUID getTrackingCategoryID() {
        return this.trackingCategoryID;
    }

    public void setTrackingCategoryID(UUID trackingCategoryID) {
        this.trackingCategoryID = trackingCategoryID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackingOption trackingOption = (TrackingOption)o;
        return Objects.equals(this.trackingOptionID, trackingOption.trackingOptionID) && Objects.equals(this.name, trackingOption.name) && Objects.equals((Object)this.status, (Object)trackingOption.status) && Objects.equals(this.trackingCategoryID, trackingOption.trackingCategoryID);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.trackingOptionID, this.name, this.status, this.trackingCategoryID});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrackingOption {\n");
        sb.append("    trackingOptionID: ").append(this.toIndentedString(this.trackingOptionID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    trackingCategoryID: ").append(this.toIndentedString(this.trackingCategoryID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        ARCHIVED("ARCHIVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + text + "'");
        }
    }
}

