/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.assets.BookDepreciationDetail;
import com.xero.models.assets.BookDepreciationSetting;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class Asset {
    @JsonProperty(value="assetId")
    private UUID assetId = null;
    @JsonProperty(value="assetName")
    private String assetName = null;
    @JsonProperty(value="assetNumber")
    private String assetNumber = null;
    @JsonProperty(value="purchaseDate")
    private LocalDate purchaseDate = null;
    @JsonProperty(value="purchasePrice")
    private Integer purchasePrice = null;
    @JsonProperty(value="disposalPrice")
    private Integer disposalPrice = null;
    @JsonProperty(value="assetStatus")
    private AssetStatusEnum assetStatus = null;
    @JsonProperty(value="warrantyExpiryDate")
    private String warrantyExpiryDate = null;
    @JsonProperty(value="serialNumber")
    private String serialNumber = null;
    @JsonProperty(value="bookDepreciationSetting")
    private BookDepreciationSetting bookDepreciationSetting = null;
    @JsonProperty(value="bookDepreciationDetail")
    private BookDepreciationDetail bookDepreciationDetail = null;
    @JsonProperty(value="canRollBack")
    private Boolean canRollBack = null;
    @JsonProperty(value="AccountingBookValue")
    private Integer accountingBookValue = null;

    public Asset assetId(UUID assetId) {
        this.assetId = assetId;
        return this;
    }

    @ApiModelProperty(example="3b5b3a38-5649-495f-87a1-14a4e5918634", required=true, value="The Xero-generated Id for the asset")
    public UUID getAssetId() {
        return this.assetId;
    }

    public void setAssetId(UUID assetId) {
        this.assetId = assetId;
    }

    public Asset assetName(String assetName) {
        this.assetName = assetName;
        return this;
    }

    @ApiModelProperty(example="Awesome Truck 3", required=true, value="The name of the asset")
    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public Asset assetNumber(String assetNumber) {
        this.assetNumber = assetNumber;
        return this;
    }

    @ApiModelProperty(example="FA-0013", value="Must be unique.")
    public String getAssetNumber() {
        return this.assetNumber;
    }

    public void setAssetNumber(String assetNumber) {
        this.assetNumber = assetNumber;
    }

    public Asset purchaseDate(LocalDate purchaseDate) {
        this.purchaseDate = purchaseDate;
        return this;
    }

    @ApiModelProperty(value="The date the asset was purchased YYYY-MM-DD")
    public LocalDate getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setPurchaseDate(LocalDate purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public Asset purchasePrice(Integer purchasePrice) {
        this.purchasePrice = purchasePrice;
        return this;
    }

    @ApiModelProperty(example="1000", value="The purchase price of the asset")
    public Integer getPurchasePrice() {
        return this.purchasePrice;
    }

    public void setPurchasePrice(Integer purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public Asset disposalPrice(Integer disposalPrice) {
        this.disposalPrice = disposalPrice;
        return this;
    }

    @ApiModelProperty(example="0", value="The price the asset was disposed at")
    public Integer getDisposalPrice() {
        return this.disposalPrice;
    }

    public void setDisposalPrice(Integer disposalPrice) {
        this.disposalPrice = disposalPrice;
    }

    public Asset assetStatus(AssetStatusEnum assetStatus) {
        this.assetStatus = assetStatus;
        return this;
    }

    @ApiModelProperty(example="Draft", value="See Asset Status Codes.")
    public AssetStatusEnum getAssetStatus() {
        return this.assetStatus;
    }

    public void setAssetStatus(AssetStatusEnum assetStatus) {
        this.assetStatus = assetStatus;
    }

    public Asset warrantyExpiryDate(String warrantyExpiryDate) {
        this.warrantyExpiryDate = warrantyExpiryDate;
        return this;
    }

    @ApiModelProperty(example="ca4c6b39-4f4f-43e8-98da-5e1f350a6694", value="The date the asset\u2019s warranty expires (if needed) YYYY-MM-DD")
    public String getWarrantyExpiryDate() {
        return this.warrantyExpiryDate;
    }

    public void setWarrantyExpiryDate(String warrantyExpiryDate) {
        this.warrantyExpiryDate = warrantyExpiryDate;
    }

    public Asset serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @ApiModelProperty(example="ca4c6b39-4f4f-43e8-98da-5e1f350a6694", value="The asset's serial number")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Asset bookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
        this.bookDepreciationSetting = bookDepreciationSetting;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BookDepreciationSetting getBookDepreciationSetting() {
        return this.bookDepreciationSetting;
    }

    public void setBookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
        this.bookDepreciationSetting = bookDepreciationSetting;
    }

    public Asset bookDepreciationDetail(BookDepreciationDetail bookDepreciationDetail) {
        this.bookDepreciationDetail = bookDepreciationDetail;
        return this;
    }

    @ApiModelProperty(value="")
    public BookDepreciationDetail getBookDepreciationDetail() {
        return this.bookDepreciationDetail;
    }

    public void setBookDepreciationDetail(BookDepreciationDetail bookDepreciationDetail) {
        this.bookDepreciationDetail = bookDepreciationDetail;
    }

    public Asset canRollBack(Boolean canRollBack) {
        this.canRollBack = canRollBack;
        return this;
    }

    @ApiModelProperty(value="Boolean to indicate whether depreciation can be rolled back for this asset individually. This is true if it doesn't have 'legacy' journal entries and if there is no lock period that would prevent this asset from rolling back.")
    public Boolean getCanRollBack() {
        return this.canRollBack;
    }

    public void setCanRollBack(Boolean canRollBack) {
        this.canRollBack = canRollBack;
    }

    public Asset accountingBookValue(Integer accountingBookValue) {
        this.accountingBookValue = accountingBookValue;
        return this;
    }

    @ApiModelProperty(example="0", value="The accounting value of the asset")
    public Integer getAccountingBookValue() {
        return this.accountingBookValue;
    }

    public void setAccountingBookValue(Integer accountingBookValue) {
        this.accountingBookValue = accountingBookValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asset asset = (Asset)o;
        return Objects.equals(this.assetId, asset.assetId) && Objects.equals(this.assetName, asset.assetName) && Objects.equals(this.assetNumber, asset.assetNumber) && Objects.equals(this.purchaseDate, asset.purchaseDate) && Objects.equals(this.purchasePrice, asset.purchasePrice) && Objects.equals(this.disposalPrice, asset.disposalPrice) && Objects.equals((Object)this.assetStatus, (Object)asset.assetStatus) && Objects.equals(this.warrantyExpiryDate, asset.warrantyExpiryDate) && Objects.equals(this.serialNumber, asset.serialNumber) && Objects.equals(this.bookDepreciationSetting, asset.bookDepreciationSetting) && Objects.equals(this.bookDepreciationDetail, asset.bookDepreciationDetail) && Objects.equals(this.canRollBack, asset.canRollBack) && Objects.equals(this.accountingBookValue, asset.accountingBookValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetId, this.assetName, this.assetNumber, this.purchaseDate, this.purchasePrice, this.disposalPrice, this.assetStatus, this.warrantyExpiryDate, this.serialNumber, this.bookDepreciationSetting, this.bookDepreciationDetail, this.canRollBack, this.accountingBookValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Asset {\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    assetName: ").append(this.toIndentedString(this.assetName)).append("\n");
        sb.append("    assetNumber: ").append(this.toIndentedString(this.assetNumber)).append("\n");
        sb.append("    purchaseDate: ").append(this.toIndentedString(this.purchaseDate)).append("\n");
        sb.append("    purchasePrice: ").append(this.toIndentedString(this.purchasePrice)).append("\n");
        sb.append("    disposalPrice: ").append(this.toIndentedString(this.disposalPrice)).append("\n");
        sb.append("    assetStatus: ").append(this.toIndentedString((Object)this.assetStatus)).append("\n");
        sb.append("    warrantyExpiryDate: ").append(this.toIndentedString(this.warrantyExpiryDate)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    bookDepreciationSetting: ").append(this.toIndentedString(this.bookDepreciationSetting)).append("\n");
        sb.append("    bookDepreciationDetail: ").append(this.toIndentedString(this.bookDepreciationDetail)).append("\n");
        sb.append("    canRollBack: ").append(this.toIndentedString(this.canRollBack)).append("\n");
        sb.append("    accountingBookValue: ").append(this.toIndentedString(this.accountingBookValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AssetStatusEnum {
        DRAFT("Draft"),
        REGISTERED("Registered"),
        DISPOSED("Disposed");

        private String value;

        private AssetStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssetStatusEnum fromValue(String text) {
            for (AssetStatusEnum b : AssetStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

