/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.models.assets.BookDepreciationSetting;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class AssetType {
    @JsonProperty(value="assetTypeId")
    private UUID assetTypeId = null;
    @JsonProperty(value="assetTypeName")
    private String assetTypeName = null;
    @JsonProperty(value="fixedAssetAccountId")
    private UUID fixedAssetAccountId = null;
    @JsonProperty(value="depreciationExpenseAccountId")
    private UUID depreciationExpenseAccountId = null;
    @JsonProperty(value="accumulatedDepreciationAccountId")
    private UUID accumulatedDepreciationAccountId = null;
    @JsonProperty(value="bookDepreciationSetting")
    private BookDepreciationSetting bookDepreciationSetting = null;
    @JsonProperty(value="locks")
    private Integer locks = null;

    public AssetType assetTypeId(UUID assetTypeId) {
        this.assetTypeId = assetTypeId;
        return this;
    }

    @ApiModelProperty(example="5da209c5-5e19-4a43-b925-71b776c49ced", required=true, value="Xero generated unique identifier for asset types")
    public UUID getAssetTypeId() {
        return this.assetTypeId;
    }

    public void setAssetTypeId(UUID assetTypeId) {
        this.assetTypeId = assetTypeId;
    }

    public AssetType assetTypeName(String assetTypeName) {
        this.assetTypeName = assetTypeName;
        return this;
    }

    @ApiModelProperty(example="Computer Equipment", required=true, value="The name of the asset type")
    public String getAssetTypeName() {
        return this.assetTypeName;
    }

    public void setAssetTypeName(String assetTypeName) {
        this.assetTypeName = assetTypeName;
    }

    public AssetType fixedAssetAccountId(UUID fixedAssetAccountId) {
        this.fixedAssetAccountId = fixedAssetAccountId;
        return this;
    }

    @ApiModelProperty(example="24e260f1-bfc4-4766-ad7f-8a8ce01de879", value="The asset account for fixed assets of this type")
    public UUID getFixedAssetAccountId() {
        return this.fixedAssetAccountId;
    }

    public void setFixedAssetAccountId(UUID fixedAssetAccountId) {
        this.fixedAssetAccountId = fixedAssetAccountId;
    }

    public AssetType depreciationExpenseAccountId(UUID depreciationExpenseAccountId) {
        this.depreciationExpenseAccountId = depreciationExpenseAccountId;
        return this;
    }

    @ApiModelProperty(example="b23fc79b-d66b-44b0-a240-e138e086fcbc", value="The expense account for the depreciation of fixed assets of this type")
    public UUID getDepreciationExpenseAccountId() {
        return this.depreciationExpenseAccountId;
    }

    public void setDepreciationExpenseAccountId(UUID depreciationExpenseAccountId) {
        this.depreciationExpenseAccountId = depreciationExpenseAccountId;
    }

    public AssetType accumulatedDepreciationAccountId(UUID accumulatedDepreciationAccountId) {
        this.accumulatedDepreciationAccountId = accumulatedDepreciationAccountId;
        return this;
    }

    @ApiModelProperty(example="ca4c6b39-4f4f-43e8-98da-5e1f350a6694", value="The account for accumulated depreciation of fixed assets of this type")
    public UUID getAccumulatedDepreciationAccountId() {
        return this.accumulatedDepreciationAccountId;
    }

    public void setAccumulatedDepreciationAccountId(UUID accumulatedDepreciationAccountId) {
        this.accumulatedDepreciationAccountId = accumulatedDepreciationAccountId;
    }

    public AssetType bookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
        this.bookDepreciationSetting = bookDepreciationSetting;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BookDepreciationSetting getBookDepreciationSetting() {
        return this.bookDepreciationSetting;
    }

    public void setBookDepreciationSetting(BookDepreciationSetting bookDepreciationSetting) {
        this.bookDepreciationSetting = bookDepreciationSetting;
    }

    public AssetType locks(Integer locks) {
        this.locks = locks;
        return this;
    }

    @ApiModelProperty(example="33", value="All asset types that have accumulated depreciation for any assets that use them are deemed \u2018locked\u2019 and cannot be removed.")
    public Integer getLocks() {
        return this.locks;
    }

    public void setLocks(Integer locks) {
        this.locks = locks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetType assetType = (AssetType)o;
        return Objects.equals(this.assetTypeId, assetType.assetTypeId) && Objects.equals(this.assetTypeName, assetType.assetTypeName) && Objects.equals(this.fixedAssetAccountId, assetType.fixedAssetAccountId) && Objects.equals(this.depreciationExpenseAccountId, assetType.depreciationExpenseAccountId) && Objects.equals(this.accumulatedDepreciationAccountId, assetType.accumulatedDepreciationAccountId) && Objects.equals(this.bookDepreciationSetting, assetType.bookDepreciationSetting) && Objects.equals(this.locks, assetType.locks);
    }

    public int hashCode() {
        return Objects.hash(this.assetTypeId, this.assetTypeName, this.fixedAssetAccountId, this.depreciationExpenseAccountId, this.accumulatedDepreciationAccountId, this.bookDepreciationSetting, this.locks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetType {\n");
        sb.append("    assetTypeId: ").append(this.toIndentedString(this.assetTypeId)).append("\n");
        sb.append("    assetTypeName: ").append(this.toIndentedString(this.assetTypeName)).append("\n");
        sb.append("    fixedAssetAccountId: ").append(this.toIndentedString(this.fixedAssetAccountId)).append("\n");
        sb.append("    depreciationExpenseAccountId: ").append(this.toIndentedString(this.depreciationExpenseAccountId)).append("\n");
        sb.append("    accumulatedDepreciationAccountId: ").append(this.toIndentedString(this.accumulatedDepreciationAccountId)).append("\n");
        sb.append("    bookDepreciationSetting: ").append(this.toIndentedString(this.bookDepreciationSetting)).append("\n");
        sb.append("    locks: ").append(this.toIndentedString(this.locks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

