/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

public class BookDepreciationDetail {
    @JsonProperty(value="currentCapitalGain")
    private Integer currentCapitalGain = null;
    @JsonProperty(value="currentGainLoss")
    private Integer currentGainLoss = null;
    @JsonProperty(value="depreciationStartDate")
    private LocalDate depreciationStartDate = null;
    @JsonProperty(value="costLimit")
    private Integer costLimit = null;
    @JsonProperty(value="residualValue")
    private Integer residualValue = null;
    @JsonProperty(value="priorAccumDepreciationAmount")
    private Integer priorAccumDepreciationAmount = null;
    @JsonProperty(value="currentAccumDepreciationAmount")
    private Integer currentAccumDepreciationAmount = null;

    public BookDepreciationDetail currentCapitalGain(Integer currentCapitalGain) {
        this.currentCapitalGain = currentCapitalGain;
        return this;
    }

    @ApiModelProperty(example="0", value="When an asset is disposed, this will be the sell price minus the purchase price if a profit was made.")
    public Integer getCurrentCapitalGain() {
        return this.currentCapitalGain;
    }

    public void setCurrentCapitalGain(Integer currentCapitalGain) {
        this.currentCapitalGain = currentCapitalGain;
    }

    public BookDepreciationDetail currentGainLoss(Integer currentGainLoss) {
        this.currentGainLoss = currentGainLoss;
        return this;
    }

    @ApiModelProperty(example="0", value="When an asset is disposed, this will be the lowest one of sell price or purchase price, minus the current book value.")
    public Integer getCurrentGainLoss() {
        return this.currentGainLoss;
    }

    public void setCurrentGainLoss(Integer currentGainLoss) {
        this.currentGainLoss = currentGainLoss;
    }

    public BookDepreciationDetail depreciationStartDate(LocalDate depreciationStartDate) {
        this.depreciationStartDate = depreciationStartDate;
        return this;
    }

    @ApiModelProperty(value="YYYY-MM-DD")
    public LocalDate getDepreciationStartDate() {
        return this.depreciationStartDate;
    }

    public void setDepreciationStartDate(LocalDate depreciationStartDate) {
        this.depreciationStartDate = depreciationStartDate;
    }

    public BookDepreciationDetail costLimit(Integer costLimit) {
        this.costLimit = costLimit;
        return this;
    }

    @ApiModelProperty(example="100000", value="The value of the asset you want to depreciate, if this is less than the cost of the asset.")
    public Integer getCostLimit() {
        return this.costLimit;
    }

    public void setCostLimit(Integer costLimit) {
        this.costLimit = costLimit;
    }

    public BookDepreciationDetail residualValue(Integer residualValue) {
        this.residualValue = residualValue;
        return this;
    }

    @ApiModelProperty(example="10000", value="The value of the asset remaining when you've fully depreciated it.")
    public Integer getResidualValue() {
        return this.residualValue;
    }

    public void setResidualValue(Integer residualValue) {
        this.residualValue = residualValue;
    }

    public BookDepreciationDetail priorAccumDepreciationAmount(Integer priorAccumDepreciationAmount) {
        this.priorAccumDepreciationAmount = priorAccumDepreciationAmount;
        return this;
    }

    @ApiModelProperty(example="0", value="All depreciation prior to the current financial year.")
    public Integer getPriorAccumDepreciationAmount() {
        return this.priorAccumDepreciationAmount;
    }

    public void setPriorAccumDepreciationAmount(Integer priorAccumDepreciationAmount) {
        this.priorAccumDepreciationAmount = priorAccumDepreciationAmount;
    }

    public BookDepreciationDetail currentAccumDepreciationAmount(Integer currentAccumDepreciationAmount) {
        this.currentAccumDepreciationAmount = currentAccumDepreciationAmount;
        return this;
    }

    @ApiModelProperty(example="0", value="All depreciation occurring in the current financial year.")
    public Integer getCurrentAccumDepreciationAmount() {
        return this.currentAccumDepreciationAmount;
    }

    public void setCurrentAccumDepreciationAmount(Integer currentAccumDepreciationAmount) {
        this.currentAccumDepreciationAmount = currentAccumDepreciationAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookDepreciationDetail bookDepreciationDetail = (BookDepreciationDetail)o;
        return Objects.equals(this.currentCapitalGain, bookDepreciationDetail.currentCapitalGain) && Objects.equals(this.currentGainLoss, bookDepreciationDetail.currentGainLoss) && Objects.equals(this.depreciationStartDate, bookDepreciationDetail.depreciationStartDate) && Objects.equals(this.costLimit, bookDepreciationDetail.costLimit) && Objects.equals(this.residualValue, bookDepreciationDetail.residualValue) && Objects.equals(this.priorAccumDepreciationAmount, bookDepreciationDetail.priorAccumDepreciationAmount) && Objects.equals(this.currentAccumDepreciationAmount, bookDepreciationDetail.currentAccumDepreciationAmount);
    }

    public int hashCode() {
        return Objects.hash(this.currentCapitalGain, this.currentGainLoss, this.depreciationStartDate, this.costLimit, this.residualValue, this.priorAccumDepreciationAmount, this.currentAccumDepreciationAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookDepreciationDetail {\n");
        sb.append("    currentCapitalGain: ").append(this.toIndentedString(this.currentCapitalGain)).append("\n");
        sb.append("    currentGainLoss: ").append(this.toIndentedString(this.currentGainLoss)).append("\n");
        sb.append("    depreciationStartDate: ").append(this.toIndentedString(this.depreciationStartDate)).append("\n");
        sb.append("    costLimit: ").append(this.toIndentedString(this.costLimit)).append("\n");
        sb.append("    residualValue: ").append(this.toIndentedString(this.residualValue)).append("\n");
        sb.append("    priorAccumDepreciationAmount: ").append(this.toIndentedString(this.priorAccumDepreciationAmount)).append("\n");
        sb.append("    currentAccumDepreciationAmount: ").append(this.toIndentedString(this.currentAccumDepreciationAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

