/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class BookDepreciationSetting {
    @JsonProperty(value="depreciationMethod")
    private DepreciationMethodEnum depreciationMethod = null;
    @JsonProperty(value="averagingMethod")
    private AveragingMethodEnum averagingMethod = null;
    @JsonProperty(value="depreciationRate")
    private Float depreciationRate = null;
    @JsonProperty(value="effectiveLifeYears")
    private Integer effectiveLifeYears = null;
    @JsonProperty(value="depreciationCalculationMethod")
    private DepreciationCalculationMethodEnum depreciationCalculationMethod = null;

    public BookDepreciationSetting depreciationMethod(DepreciationMethodEnum depreciationMethod) {
        this.depreciationMethod = depreciationMethod;
        return this;
    }

    @ApiModelProperty(example="StraightLine", value="The method of depreciation applied to this asset. See Depreciation Methods")
    public DepreciationMethodEnum getDepreciationMethod() {
        return this.depreciationMethod;
    }

    public void setDepreciationMethod(DepreciationMethodEnum depreciationMethod) {
        this.depreciationMethod = depreciationMethod;
    }

    public BookDepreciationSetting averagingMethod(AveragingMethodEnum averagingMethod) {
        this.averagingMethod = averagingMethod;
        return this;
    }

    @ApiModelProperty(example="ActualDays", value="The method of averaging applied to this asset. See Averaging Methods")
    public AveragingMethodEnum getAveragingMethod() {
        return this.averagingMethod;
    }

    public void setAveragingMethod(AveragingMethodEnum averagingMethod) {
        this.averagingMethod = averagingMethod;
    }

    public BookDepreciationSetting depreciationRate(Float depreciationRate) {
        this.depreciationRate = depreciationRate;
        return this;
    }

    @ApiModelProperty(example="0.05", value="The rate of depreciation (e.g. 0.05)")
    public Float getDepreciationRate() {
        return this.depreciationRate;
    }

    public void setDepreciationRate(Float depreciationRate) {
        this.depreciationRate = depreciationRate;
    }

    public BookDepreciationSetting effectiveLifeYears(Integer effectiveLifeYears) {
        this.effectiveLifeYears = effectiveLifeYears;
        return this;
    }

    @ApiModelProperty(example="5", value="Effective life of the asset in years (e.g. 5)")
    public Integer getEffectiveLifeYears() {
        return this.effectiveLifeYears;
    }

    public void setEffectiveLifeYears(Integer effectiveLifeYears) {
        this.effectiveLifeYears = effectiveLifeYears;
    }

    public BookDepreciationSetting depreciationCalculationMethod(DepreciationCalculationMethodEnum depreciationCalculationMethod) {
        this.depreciationCalculationMethod = depreciationCalculationMethod;
        return this;
    }

    @ApiModelProperty(example="None", value="See Depreciation Calculation Methods")
    public DepreciationCalculationMethodEnum getDepreciationCalculationMethod() {
        return this.depreciationCalculationMethod;
    }

    public void setDepreciationCalculationMethod(DepreciationCalculationMethodEnum depreciationCalculationMethod) {
        this.depreciationCalculationMethod = depreciationCalculationMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookDepreciationSetting bookDepreciationSetting = (BookDepreciationSetting)o;
        return Objects.equals((Object)this.depreciationMethod, (Object)bookDepreciationSetting.depreciationMethod) && Objects.equals((Object)this.averagingMethod, (Object)bookDepreciationSetting.averagingMethod) && Objects.equals(this.depreciationRate, bookDepreciationSetting.depreciationRate) && Objects.equals(this.effectiveLifeYears, bookDepreciationSetting.effectiveLifeYears) && Objects.equals((Object)this.depreciationCalculationMethod, (Object)bookDepreciationSetting.depreciationCalculationMethod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.depreciationMethod, this.averagingMethod, this.depreciationRate, this.effectiveLifeYears, this.depreciationCalculationMethod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookDepreciationSetting {\n");
        sb.append("    depreciationMethod: ").append(this.toIndentedString((Object)this.depreciationMethod)).append("\n");
        sb.append("    averagingMethod: ").append(this.toIndentedString((Object)this.averagingMethod)).append("\n");
        sb.append("    depreciationRate: ").append(this.toIndentedString(this.depreciationRate)).append("\n");
        sb.append("    effectiveLifeYears: ").append(this.toIndentedString(this.effectiveLifeYears)).append("\n");
        sb.append("    depreciationCalculationMethod: ").append(this.toIndentedString((Object)this.depreciationCalculationMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DepreciationCalculationMethodEnum {
        RATE("Rate"),
        LIFE("Life"),
        NONE("None");

        private String value;

        private DepreciationCalculationMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DepreciationCalculationMethodEnum fromValue(String text) {
            for (DepreciationCalculationMethodEnum b : DepreciationCalculationMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AveragingMethodEnum {
        FULLMONTH("FullMonth"),
        ACTUALDAYS("ActualDays");

        private String value;

        private AveragingMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AveragingMethodEnum fromValue(String text) {
            for (AveragingMethodEnum b : AveragingMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum DepreciationMethodEnum {
        NODEPRECIATION("NoDepreciation"),
        STRAIGHTLINE("StraightLine"),
        DIMINISHINGVALUE100("DiminishingValue100"),
        DIMINISHINGVALUE150("DiminishingValue150"),
        DIMINISHINGVALUE200("DiminishingValue200"),
        FULLDEPRECIATION("FullDepreciation");

        private String value;

        private DepreciationMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DepreciationMethodEnum fromValue(String text) {
            for (DepreciationMethodEnum b : DepreciationMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

