/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class Setting {
    @JsonProperty(value="assetNumberPrefix")
    private String assetNumberPrefix = null;
    @JsonProperty(value="assetNumberSequence")
    private String assetNumberSequence = null;
    @JsonProperty(value="assetStartDate")
    private LocalDate assetStartDate = null;
    @JsonProperty(value="lastDepreciationDate")
    private LocalDate lastDepreciationDate = null;
    @JsonProperty(value="defaultGainOnDisposalAccountId")
    private UUID defaultGainOnDisposalAccountId = null;
    @JsonProperty(value="defaultLossOnDisposalAccountId")
    private UUID defaultLossOnDisposalAccountId = null;
    @JsonProperty(value="defaultCapitalGainOnDisposalAccountId")
    private UUID defaultCapitalGainOnDisposalAccountId = null;
    @JsonProperty(value="optInForTax")
    private Boolean optInForTax = null;

    public Setting assetNumberPrefix(String assetNumberPrefix) {
        this.assetNumberPrefix = assetNumberPrefix;
        return this;
    }

    @ApiModelProperty(example="FA-", value="The prefix used for fixed asset numbers (\u201cFA-\u201d by default)")
    public String getAssetNumberPrefix() {
        return this.assetNumberPrefix;
    }

    public void setAssetNumberPrefix(String assetNumberPrefix) {
        this.assetNumberPrefix = assetNumberPrefix;
    }

    public Setting assetNumberSequence(String assetNumberSequence) {
        this.assetNumberSequence = assetNumberSequence;
        return this;
    }

    @ApiModelProperty(example="0022", value="The next available sequence number")
    public String getAssetNumberSequence() {
        return this.assetNumberSequence;
    }

    public void setAssetNumberSequence(String assetNumberSequence) {
        this.assetNumberSequence = assetNumberSequence;
    }

    public Setting assetStartDate(LocalDate assetStartDate) {
        this.assetStartDate = assetStartDate;
        return this;
    }

    @ApiModelProperty(value="The date depreciation calculations started on registered fixed assets in Xero")
    public LocalDate getAssetStartDate() {
        return this.assetStartDate;
    }

    public void setAssetStartDate(LocalDate assetStartDate) {
        this.assetStartDate = assetStartDate;
    }

    public Setting lastDepreciationDate(LocalDate lastDepreciationDate) {
        this.lastDepreciationDate = lastDepreciationDate;
        return this;
    }

    @ApiModelProperty(value="The last depreciation date")
    public LocalDate getLastDepreciationDate() {
        return this.lastDepreciationDate;
    }

    public void setLastDepreciationDate(LocalDate lastDepreciationDate) {
        this.lastDepreciationDate = lastDepreciationDate;
    }

    public Setting defaultGainOnDisposalAccountId(UUID defaultGainOnDisposalAccountId) {
        this.defaultGainOnDisposalAccountId = defaultGainOnDisposalAccountId;
        return this;
    }

    @ApiModelProperty(example="346ddb97-739a-4274-b43b-66aa3218d17c", value="Default account that gains are posted to")
    public UUID getDefaultGainOnDisposalAccountId() {
        return this.defaultGainOnDisposalAccountId;
    }

    public void setDefaultGainOnDisposalAccountId(UUID defaultGainOnDisposalAccountId) {
        this.defaultGainOnDisposalAccountId = defaultGainOnDisposalAccountId;
    }

    public Setting defaultLossOnDisposalAccountId(UUID defaultLossOnDisposalAccountId) {
        this.defaultLossOnDisposalAccountId = defaultLossOnDisposalAccountId;
        return this;
    }

    @ApiModelProperty(example="1b798541-24e2-4855-9309-c023a0b576f3", value="Default account that losses are posted to")
    public UUID getDefaultLossOnDisposalAccountId() {
        return this.defaultLossOnDisposalAccountId;
    }

    public void setDefaultLossOnDisposalAccountId(UUID defaultLossOnDisposalAccountId) {
        this.defaultLossOnDisposalAccountId = defaultLossOnDisposalAccountId;
    }

    public Setting defaultCapitalGainOnDisposalAccountId(UUID defaultCapitalGainOnDisposalAccountId) {
        this.defaultCapitalGainOnDisposalAccountId = defaultCapitalGainOnDisposalAccountId;
        return this;
    }

    @ApiModelProperty(example="6d6a0bdb-e118-45d8-a023-2ad617ec1cb7", value="Default account that capital gains are posted to")
    public UUID getDefaultCapitalGainOnDisposalAccountId() {
        return this.defaultCapitalGainOnDisposalAccountId;
    }

    public void setDefaultCapitalGainOnDisposalAccountId(UUID defaultCapitalGainOnDisposalAccountId) {
        this.defaultCapitalGainOnDisposalAccountId = defaultCapitalGainOnDisposalAccountId;
    }

    public Setting optInForTax(Boolean optInForTax) {
        this.optInForTax = optInForTax;
        return this;
    }

    @ApiModelProperty(value="opt in for tax calculation")
    public Boolean getOptInForTax() {
        return this.optInForTax;
    }

    public void setOptInForTax(Boolean optInForTax) {
        this.optInForTax = optInForTax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Setting setting = (Setting)o;
        return Objects.equals(this.assetNumberPrefix, setting.assetNumberPrefix) && Objects.equals(this.assetNumberSequence, setting.assetNumberSequence) && Objects.equals(this.assetStartDate, setting.assetStartDate) && Objects.equals(this.lastDepreciationDate, setting.lastDepreciationDate) && Objects.equals(this.defaultGainOnDisposalAccountId, setting.defaultGainOnDisposalAccountId) && Objects.equals(this.defaultLossOnDisposalAccountId, setting.defaultLossOnDisposalAccountId) && Objects.equals(this.defaultCapitalGainOnDisposalAccountId, setting.defaultCapitalGainOnDisposalAccountId) && Objects.equals(this.optInForTax, setting.optInForTax);
    }

    public int hashCode() {
        return Objects.hash(this.assetNumberPrefix, this.assetNumberSequence, this.assetStartDate, this.lastDepreciationDate, this.defaultGainOnDisposalAccountId, this.defaultLossOnDisposalAccountId, this.defaultCapitalGainOnDisposalAccountId, this.optInForTax);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Setting {\n");
        sb.append("    assetNumberPrefix: ").append(this.toIndentedString(this.assetNumberPrefix)).append("\n");
        sb.append("    assetNumberSequence: ").append(this.toIndentedString(this.assetNumberSequence)).append("\n");
        sb.append("    assetStartDate: ").append(this.toIndentedString(this.assetStartDate)).append("\n");
        sb.append("    lastDepreciationDate: ").append(this.toIndentedString(this.lastDepreciationDate)).append("\n");
        sb.append("    defaultGainOnDisposalAccountId: ").append(this.toIndentedString(this.defaultGainOnDisposalAccountId)).append("\n");
        sb.append("    defaultLossOnDisposalAccountId: ").append(this.toIndentedString(this.defaultLossOnDisposalAccountId)).append("\n");
        sb.append("    defaultCapitalGainOnDisposalAccountId: ").append(this.toIndentedString(this.defaultCapitalGainOnDisposalAccountId)).append("\n");
        sb.append("    optInForTax: ").append(this.toIndentedString(this.optInForTax)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

