/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.bankfeeds;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="On error, the API consumer will receive an HTTP response with a HTTP Status Code of 4xx or 5xx and a Content-Type of application/problem+json.")
public class Error {
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="status")
    private Integer status = null;
    @JsonProperty(value="detail")
    private String detail = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;

    public Error title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="Invalid Application", value="")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Error status(Integer status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="403", value="")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Error detail(String detail) {
        this.detail = detail;
        return this;
    }

    @ApiModelProperty(example="The application has not been configured to use these API endpoints.", value="")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Error type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="invalid-application", value="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.title, error.title) && Objects.equals(this.status, error.status) && Objects.equals(this.detail, error.detail) && Objects.equals((Object)this.type, (Object)error.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.status, this.detail, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INVALID_REQUEST("invalid-request"),
        INVALID_APPLICATION("invalid-application"),
        INVALID_FEED_CONNECTION("invalid-feed-connection"),
        DUPLICATE_STATEMENT("duplicate-statement"),
        INVALID_END_BALANCE("invalid-end-balance"),
        INVALID_START_AND_END_DATE("invalid-start-and-end-date"),
        INVALID_START_DATE("invalid-start-date"),
        INTERNAL_ERROR("internal-error");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

