/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.bankfeeds;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.models.bankfeeds.Error;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class FeedConnection {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="accountToken")
    private String accountToken = null;
    @JsonProperty(value="accountNumber")
    private String accountNumber = null;
    @JsonProperty(value="accountName")
    private String accountName = null;
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="accountType")
    private AccountTypeEnum accountType = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="country")
    private String country = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="error")
    private Error error = null;

    public FeedConnection id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="0d3cf8d-95dc-4466-8dc0-47e6d1197e28", required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FeedConnection accountToken(String accountToken) {
        this.accountToken = accountToken;
        return this;
    }

    @ApiModelProperty(example="10000123", value="")
    public String getAccountToken() {
        return this.accountToken;
    }

    public void setAccountToken(String accountToken) {
        this.accountToken = accountToken;
    }

    public FeedConnection accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(example="3809087654321500", value="")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public FeedConnection accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(example="Joe's Savings Account", value="")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public FeedConnection accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="079a88ea-276d-41fb-a1f1-366ef3e22921", value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public FeedConnection accountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(example="BANK", value="")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public FeedConnection currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(example="AUD", value="")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public FeedConnection country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="GB", value="")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public FeedConnection status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="REJECTED", value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public FeedConnection error(Error error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedConnection feedConnection = (FeedConnection)o;
        return Objects.equals(this.id, feedConnection.id) && Objects.equals(this.accountToken, feedConnection.accountToken) && Objects.equals(this.accountNumber, feedConnection.accountNumber) && Objects.equals(this.accountName, feedConnection.accountName) && Objects.equals(this.accountId, feedConnection.accountId) && Objects.equals((Object)this.accountType, (Object)feedConnection.accountType) && Objects.equals(this.currency, feedConnection.currency) && Objects.equals(this.country, feedConnection.country) && Objects.equals((Object)this.status, (Object)feedConnection.status) && Objects.equals(this.error, feedConnection.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.accountToken, this.accountNumber, this.accountName, this.accountId, this.accountType, this.currency, this.country, this.status, this.error});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeedConnection {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountToken: ").append(this.toIndentedString(this.accountToken)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("PENDING"),
        REJECTED("REJECTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AccountTypeEnum {
        BANK("BANK"),
        CREDITCARD("CREDITCARD");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountTypeEnum fromValue(String text) {
            for (AccountTypeEnum b : AccountTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

