/*
 * Xero Accounting API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

/** Overpayment */
public class Overpayment {
  StringUtil util = new StringUtil();
  /** See Overpayment Types */
  public enum TypeEnum {
    /** RECEIVE_OVERPAYMENT */
    RECEIVE_OVERPAYMENT("RECEIVE-OVERPAYMENT"),

    /** SPEND_OVERPAYMENT */
    SPEND_OVERPAYMENT("SPEND-OVERPAYMENT"),

    /** AROVERPAYMENT */
    AROVERPAYMENT("AROVERPAYMENT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Type")
  private TypeEnum type;

  @JsonProperty("Contact")
  private Contact contact;

  @JsonProperty("Date")
  private String date;
  /** See Overpayment Status Codes */
  public enum StatusEnum {
    /** AUTHORISED */
    AUTHORISED("AUTHORISED"),

    /** PAID */
    PAID("PAID"),

    /** VOIDED */
    VOIDED("VOIDED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    /**
     * getValue
     *
     * @return String value
     */
    @JsonValue
    public String getValue() {
      return value;
    }

    /**
     * toString
     *
     * @return String value
     */
    @Override
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * fromValue
     *
     * @param value String
     */
    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("Status")
  private StatusEnum status;

  @JsonProperty("LineAmountTypes")
  private LineAmountTypes lineAmountTypes;

  @JsonProperty("LineItems")
  private List<LineItem> lineItems = new ArrayList<LineItem>();

  @JsonProperty("SubTotal")
  private Double subTotal;

  @JsonProperty("TotalTax")
  private Double totalTax;

  @JsonProperty("Total")
  private Double total;

  @JsonProperty("UpdatedDateUTC")
  private String updatedDateUTC;

  @JsonProperty("CurrencyCode")
  private CurrencyCode currencyCode;

  @JsonProperty("OverpaymentID")
  private UUID overpaymentID;

  @JsonProperty("CurrencyRate")
  private Double currencyRate;

  @JsonProperty("RemainingCredit")
  private Double remainingCredit;

  @JsonProperty("Allocations")
  private List<Allocation> allocations = new ArrayList<Allocation>();

  @JsonProperty("AppliedAmount")
  private Double appliedAmount;

  @JsonProperty("Payments")
  private List<Payment> payments = new ArrayList<Payment>();

  @JsonProperty("HasAttachments")
  private Boolean hasAttachments = false;

  @JsonProperty("Attachments")
  private List<Attachment> attachments = new ArrayList<Attachment>();
  /**
   * See Overpayment Types
   *
   * @param type TypeEnum
   * @return Overpayment
   */
  public Overpayment type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * See Overpayment Types
   *
   * @return type
   */
  @ApiModelProperty(value = "See Overpayment Types")
  /**
   * See Overpayment Types
   *
   * @return type TypeEnum
   */
  public TypeEnum getType() {
    return type;
  }

  /**
   * See Overpayment Types
   *
   * @param type TypeEnum
   */
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * contact
   *
   * @param contact Contact
   * @return Overpayment
   */
  public Overpayment contact(Contact contact) {
    this.contact = contact;
    return this;
  }

  /**
   * Get contact
   *
   * @return contact
   */
  @ApiModelProperty(value = "")
  /**
   * contact
   *
   * @return contact Contact
   */
  public Contact getContact() {
    return contact;
  }

  /**
   * contact
   *
   * @param contact Contact
   */
  public void setContact(Contact contact) {
    this.contact = contact;
  }

  /**
   * The date the overpayment is created YYYY-MM-DD
   *
   * @param date String
   * @return Overpayment
   */
  public Overpayment date(String date) {
    this.date = date;
    return this;
  }

  /**
   * The date the overpayment is created YYYY-MM-DD
   *
   * @return date
   */
  @ApiModelProperty(value = "The date the overpayment is created YYYY-MM-DD")
  /**
   * The date the overpayment is created YYYY-MM-DD
   *
   * @return date String
   */
  public String getDate() {
    return date;
  }
  /**
   * The date the overpayment is created YYYY-MM-DD
   *
   * @return LocalDate
   */
  public LocalDate getDateAsDate() {
    if (this.date != null) {
      try {
        return util.convertStringToDate(this.date);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * The date the overpayment is created YYYY-MM-DD
   *
   * @param date String
   */
  public void setDate(String date) {
    this.date = date;
  }

  /**
   * The date the overpayment is created YYYY-MM-DD
   *
   * @param date LocalDateTime
   */
  public void setDate(LocalDate date) {
    // CONVERT LocalDate args into MS DateFromat String
    Instant instant = date.atStartOfDay(ZoneId.of("UTC").normalized()).toInstant();
    long timeInMillis = instant.toEpochMilli();

    this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
  }

  /**
   * See Overpayment Status Codes
   *
   * @param status StatusEnum
   * @return Overpayment
   */
  public Overpayment status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * See Overpayment Status Codes
   *
   * @return status
   */
  @ApiModelProperty(value = "See Overpayment Status Codes")
  /**
   * See Overpayment Status Codes
   *
   * @return status StatusEnum
   */
  public StatusEnum getStatus() {
    return status;
  }

  /**
   * See Overpayment Status Codes
   *
   * @param status StatusEnum
   */
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * lineAmountTypes
   *
   * @param lineAmountTypes LineAmountTypes
   * @return Overpayment
   */
  public Overpayment lineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
    return this;
  }

  /**
   * Get lineAmountTypes
   *
   * @return lineAmountTypes
   */
  @ApiModelProperty(value = "")
  /**
   * lineAmountTypes
   *
   * @return lineAmountTypes LineAmountTypes
   */
  public LineAmountTypes getLineAmountTypes() {
    return lineAmountTypes;
  }

  /**
   * lineAmountTypes
   *
   * @param lineAmountTypes LineAmountTypes
   */
  public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
    this.lineAmountTypes = lineAmountTypes;
  }

  /**
   * See Overpayment Line Items
   *
   * @param lineItems List&lt;LineItem&gt;
   * @return Overpayment
   */
  public Overpayment lineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  /**
   * See Overpayment Line Items
   *
   * @param lineItemsItem LineItem
   * @return Overpayment
   */
  public Overpayment addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<LineItem>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

  /**
   * See Overpayment Line Items
   *
   * @return lineItems
   */
  @ApiModelProperty(value = "See Overpayment Line Items")
  /**
   * See Overpayment Line Items
   *
   * @return lineItems List<LineItem>
   */
  public List<LineItem> getLineItems() {
    return lineItems;
  }

  /**
   * See Overpayment Line Items
   *
   * @param lineItems List&lt;LineItem&gt;
   */
  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }

  /**
   * The subtotal of the overpayment excluding taxes
   *
   * @param subTotal Double
   * @return Overpayment
   */
  public Overpayment subTotal(Double subTotal) {
    this.subTotal = subTotal;
    return this;
  }

  /**
   * The subtotal of the overpayment excluding taxes
   *
   * @return subTotal
   */
  @ApiModelProperty(value = "The subtotal of the overpayment excluding taxes")
  /**
   * The subtotal of the overpayment excluding taxes
   *
   * @return subTotal Double
   */
  public Double getSubTotal() {
    return subTotal;
  }

  /**
   * The subtotal of the overpayment excluding taxes
   *
   * @param subTotal Double
   */
  public void setSubTotal(Double subTotal) {
    this.subTotal = subTotal;
  }

  /**
   * The total tax on the overpayment
   *
   * @param totalTax Double
   * @return Overpayment
   */
  public Overpayment totalTax(Double totalTax) {
    this.totalTax = totalTax;
    return this;
  }

  /**
   * The total tax on the overpayment
   *
   * @return totalTax
   */
  @ApiModelProperty(value = "The total tax on the overpayment")
  /**
   * The total tax on the overpayment
   *
   * @return totalTax Double
   */
  public Double getTotalTax() {
    return totalTax;
  }

  /**
   * The total tax on the overpayment
   *
   * @param totalTax Double
   */
  public void setTotalTax(Double totalTax) {
    this.totalTax = totalTax;
  }

  /**
   * The total of the overpayment (subtotal + total tax)
   *
   * @param total Double
   * @return Overpayment
   */
  public Overpayment total(Double total) {
    this.total = total;
    return this;
  }

  /**
   * The total of the overpayment (subtotal + total tax)
   *
   * @return total
   */
  @ApiModelProperty(value = "The total of the overpayment (subtotal + total tax)")
  /**
   * The total of the overpayment (subtotal + total tax)
   *
   * @return total Double
   */
  public Double getTotal() {
    return total;
  }

  /**
   * The total of the overpayment (subtotal + total tax)
   *
   * @param total Double
   */
  public void setTotal(Double total) {
    this.total = total;
  }

  /**
   * UTC timestamp of last update to the overpayment
   *
   * @return updatedDateUTC
   */
  @ApiModelProperty(
      example = "/Date(1573755038314)/",
      value = "UTC timestamp of last update to the overpayment")
  /**
   * UTC timestamp of last update to the overpayment
   *
   * @return updatedDateUTC String
   */
  public String getUpdatedDateUTC() {
    return updatedDateUTC;
  }
  /**
   * UTC timestamp of last update to the overpayment
   *
   * @return OffsetDateTime
   */
  public OffsetDateTime getUpdatedDateUTCAsDate() {
    if (this.updatedDateUTC != null) {
      try {
        return util.convertStringToOffsetDateTime(this.updatedDateUTC);
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return null;
  }

  /**
   * currencyCode
   *
   * @param currencyCode CurrencyCode
   * @return Overpayment
   */
  public Overpayment currencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Get currencyCode
   *
   * @return currencyCode
   */
  @ApiModelProperty(value = "")
  /**
   * currencyCode
   *
   * @return currencyCode CurrencyCode
   */
  public CurrencyCode getCurrencyCode() {
    return currencyCode;
  }

  /**
   * currencyCode
   *
   * @param currencyCode CurrencyCode
   */
  public void setCurrencyCode(CurrencyCode currencyCode) {
    this.currencyCode = currencyCode;
  }

  /**
   * Xero generated unique identifier
   *
   * @param overpaymentID UUID
   * @return Overpayment
   */
  public Overpayment overpaymentID(UUID overpaymentID) {
    this.overpaymentID = overpaymentID;
    return this;
  }

  /**
   * Xero generated unique identifier
   *
   * @return overpaymentID
   */
  @ApiModelProperty(value = "Xero generated unique identifier")
  /**
   * Xero generated unique identifier
   *
   * @return overpaymentID UUID
   */
  public UUID getOverpaymentID() {
    return overpaymentID;
  }

  /**
   * Xero generated unique identifier
   *
   * @param overpaymentID UUID
   */
  public void setOverpaymentID(UUID overpaymentID) {
    this.overpaymentID = overpaymentID;
  }

  /**
   * The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com day rate
   * is used
   *
   * @param currencyRate Double
   * @return Overpayment
   */
  public Overpayment currencyRate(Double currencyRate) {
    this.currencyRate = currencyRate;
    return this;
  }

  /**
   * The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com day rate
   * is used
   *
   * @return currencyRate
   */
  @ApiModelProperty(
      value =
          "The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com"
              + " day rate is used")
  /**
   * The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com day rate
   * is used
   *
   * @return currencyRate Double
   */
  public Double getCurrencyRate() {
    return currencyRate;
  }

  /**
   * The currency rate for a multicurrency overpayment. If no rate is specified, the XE.com day rate
   * is used
   *
   * @param currencyRate Double
   */
  public void setCurrencyRate(Double currencyRate) {
    this.currencyRate = currencyRate;
  }

  /**
   * The remaining credit balance on the overpayment
   *
   * @param remainingCredit Double
   * @return Overpayment
   */
  public Overpayment remainingCredit(Double remainingCredit) {
    this.remainingCredit = remainingCredit;
    return this;
  }

  /**
   * The remaining credit balance on the overpayment
   *
   * @return remainingCredit
   */
  @ApiModelProperty(value = "The remaining credit balance on the overpayment")
  /**
   * The remaining credit balance on the overpayment
   *
   * @return remainingCredit Double
   */
  public Double getRemainingCredit() {
    return remainingCredit;
  }

  /**
   * The remaining credit balance on the overpayment
   *
   * @param remainingCredit Double
   */
  public void setRemainingCredit(Double remainingCredit) {
    this.remainingCredit = remainingCredit;
  }

  /**
   * See Allocations
   *
   * @param allocations List&lt;Allocation&gt;
   * @return Overpayment
   */
  public Overpayment allocations(List<Allocation> allocations) {
    this.allocations = allocations;
    return this;
  }

  /**
   * See Allocations
   *
   * @param allocationsItem Allocation
   * @return Overpayment
   */
  public Overpayment addAllocationsItem(Allocation allocationsItem) {
    if (this.allocations == null) {
      this.allocations = new ArrayList<Allocation>();
    }
    this.allocations.add(allocationsItem);
    return this;
  }

  /**
   * See Allocations
   *
   * @return allocations
   */
  @ApiModelProperty(value = "See Allocations")
  /**
   * See Allocations
   *
   * @return allocations List<Allocation>
   */
  public List<Allocation> getAllocations() {
    return allocations;
  }

  /**
   * See Allocations
   *
   * @param allocations List&lt;Allocation&gt;
   */
  public void setAllocations(List<Allocation> allocations) {
    this.allocations = allocations;
  }

  /**
   * The amount of applied to an invoice
   *
   * @param appliedAmount Double
   * @return Overpayment
   */
  public Overpayment appliedAmount(Double appliedAmount) {
    this.appliedAmount = appliedAmount;
    return this;
  }

  /**
   * The amount of applied to an invoice
   *
   * @return appliedAmount
   */
  @ApiModelProperty(example = "2.0", value = "The amount of applied to an invoice")
  /**
   * The amount of applied to an invoice
   *
   * @return appliedAmount Double
   */
  public Double getAppliedAmount() {
    return appliedAmount;
  }

  /**
   * The amount of applied to an invoice
   *
   * @param appliedAmount Double
   */
  public void setAppliedAmount(Double appliedAmount) {
    this.appliedAmount = appliedAmount;
  }

  /**
   * See Payments
   *
   * @param payments List&lt;Payment&gt;
   * @return Overpayment
   */
  public Overpayment payments(List<Payment> payments) {
    this.payments = payments;
    return this;
  }

  /**
   * See Payments
   *
   * @param paymentsItem Payment
   * @return Overpayment
   */
  public Overpayment addPaymentsItem(Payment paymentsItem) {
    if (this.payments == null) {
      this.payments = new ArrayList<Payment>();
    }
    this.payments.add(paymentsItem);
    return this;
  }

  /**
   * See Payments
   *
   * @return payments
   */
  @ApiModelProperty(value = "See Payments")
  /**
   * See Payments
   *
   * @return payments List<Payment>
   */
  public List<Payment> getPayments() {
    return payments;
  }

  /**
   * See Payments
   *
   * @param payments List&lt;Payment&gt;
   */
  public void setPayments(List<Payment> payments) {
    this.payments = payments;
  }

  /**
   * boolean to indicate if a overpayment has an attachment
   *
   * @return hasAttachments
   */
  @ApiModelProperty(
      example = "false",
      value = "boolean to indicate if a overpayment has an attachment")
  /**
   * boolean to indicate if a overpayment has an attachment
   *
   * @return hasAttachments Boolean
   */
  public Boolean getHasAttachments() {
    return hasAttachments;
  }

  /**
   * See Attachments
   *
   * @param attachments List&lt;Attachment&gt;
   * @return Overpayment
   */
  public Overpayment attachments(List<Attachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  /**
   * See Attachments
   *
   * @param attachmentsItem Attachment
   * @return Overpayment
   */
  public Overpayment addAttachmentsItem(Attachment attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<Attachment>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * See Attachments
   *
   * @return attachments
   */
  @ApiModelProperty(value = "See Attachments")
  /**
   * See Attachments
   *
   * @return attachments List<Attachment>
   */
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * See Attachments
   *
   * @param attachments List&lt;Attachment&gt;
   */
  public void setAttachments(List<Attachment> attachments) {
    this.attachments = attachments;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Overpayment overpayment = (Overpayment) o;
    return Objects.equals(this.type, overpayment.type)
        && Objects.equals(this.contact, overpayment.contact)
        && Objects.equals(this.date, overpayment.date)
        && Objects.equals(this.status, overpayment.status)
        && Objects.equals(this.lineAmountTypes, overpayment.lineAmountTypes)
        && Objects.equals(this.lineItems, overpayment.lineItems)
        && Objects.equals(this.subTotal, overpayment.subTotal)
        && Objects.equals(this.totalTax, overpayment.totalTax)
        && Objects.equals(this.total, overpayment.total)
        && Objects.equals(this.updatedDateUTC, overpayment.updatedDateUTC)
        && Objects.equals(this.currencyCode, overpayment.currencyCode)
        && Objects.equals(this.overpaymentID, overpayment.overpaymentID)
        && Objects.equals(this.currencyRate, overpayment.currencyRate)
        && Objects.equals(this.remainingCredit, overpayment.remainingCredit)
        && Objects.equals(this.allocations, overpayment.allocations)
        && Objects.equals(this.appliedAmount, overpayment.appliedAmount)
        && Objects.equals(this.payments, overpayment.payments)
        && Objects.equals(this.hasAttachments, overpayment.hasAttachments)
        && Objects.equals(this.attachments, overpayment.attachments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        type,
        contact,
        date,
        status,
        lineAmountTypes,
        lineItems,
        subTotal,
        totalTax,
        total,
        updatedDateUTC,
        currencyCode,
        overpaymentID,
        currencyRate,
        remainingCredit,
        allocations,
        appliedAmount,
        payments,
        hasAttachments,
        attachments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Overpayment {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    lineAmountTypes: ").append(toIndentedString(lineAmountTypes)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    subTotal: ").append(toIndentedString(subTotal)).append("\n");
    sb.append("    totalTax: ").append(toIndentedString(totalTax)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    updatedDateUTC: ").append(toIndentedString(updatedDateUTC)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    overpaymentID: ").append(toIndentedString(overpaymentID)).append("\n");
    sb.append("    currencyRate: ").append(toIndentedString(currencyRate)).append("\n");
    sb.append("    remainingCredit: ").append(toIndentedString(remainingCredit)).append("\n");
    sb.append("    allocations: ").append(toIndentedString(allocations)).append("\n");
    sb.append("    appliedAmount: ").append(toIndentedString(appliedAmount)).append("\n");
    sb.append("    payments: ").append(toIndentedString(payments)).append("\n");
    sb.append("    hasAttachments: ").append(toIndentedString(hasAttachments)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
