/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.api.client.http.HttpResponseException;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiException;
import com.xero.api.XeroAppMinuteRateLimitException;
import com.xero.api.XeroBadRequestException;
import com.xero.api.XeroConflictException;
import com.xero.api.XeroDailyRateLimitException;
import com.xero.api.XeroForbiddenException;
import com.xero.api.XeroMethodNotAllowedException;
import com.xero.api.XeroMinuteRateLimitException;
import com.xero.api.XeroNotAvailableException;
import com.xero.api.XeroNotFoundException;
import com.xero.api.XeroNotImplementedException;
import com.xero.api.XeroRateLimitException;
import com.xero.api.XeroServerErrorException;
import com.xero.api.XeroUnauthorizedException;
import com.xero.models.accounting.Element;
import com.xero.models.accounting.Error;
import com.xero.models.accounting.ValidationError;
import com.xero.models.bankfeeds.FeedConnections;
import com.xero.models.bankfeeds.Statements;
import com.xero.models.payrollau.Employees;
import com.xero.models.payrollau.LeaveApplications;
import com.xero.models.payrollau.PayItems;
import com.xero.models.payrollau.PayRuns;
import com.xero.models.payrollau.PayrollCalendars;
import com.xero.models.payrollau.SuperFunds;
import com.xero.models.payrollau.Timesheets;
import com.xero.models.payrollnz.Problem;
import java.io.IOException;

public class XeroApiExceptionHandler {
    public void validationError(String objectType, Error error, Exception e) {
        throw new XeroBadRequestException(objectType, error, e);
    }

    public void validationError(String objectType, com.xero.models.assets.Error error, Exception e) {
        throw new XeroBadRequestException(objectType, error, e);
    }

    public void validationError(String objectType, Statements error, Exception e) {
        throw new XeroBadRequestException(objectType, error, e);
    }

    public void validationError(String objectType, FeedConnections error, Exception e) {
        throw new XeroBadRequestException(objectType, error, e);
    }

    public void validationError(Integer statusCode, String objectType, com.xero.models.payrolluk.Problem error, Exception e) {
        if (statusCode == 400) {
            throw new XeroBadRequestException(objectType, error, e);
        }
        if (statusCode == 405) {
            throw new XeroMethodNotAllowedException(objectType, error, e);
        }
    }

    public void validationError(Integer statusCode, String objectType, Problem error, Exception e) {
        if (statusCode == 400) {
            throw new XeroBadRequestException(objectType, error, e);
        }
        if (statusCode == 405) {
            throw new XeroMethodNotAllowedException(objectType, error, e);
        }
        if (statusCode == 409) {
            throw new XeroConflictException(objectType, error, e);
        }
    }

    public void validationError(String objectType, Employees employees, Exception e) {
        throw new XeroBadRequestException(objectType, employees, e);
    }

    public void validationError(String objectType, LeaveApplications leaveApplications, Exception e) {
        throw new XeroBadRequestException(objectType, leaveApplications, e);
    }

    public void validationError(String objectType, PayItems payItems, Exception e) {
        throw new XeroBadRequestException(objectType, payItems, e);
    }

    public void validationError(String objectType, PayRuns payRuns, Exception e) {
        throw new XeroBadRequestException(objectType, payRuns, e);
    }

    public void validationError(String objectType, PayrollCalendars payrollCalendars, Exception e) {
        throw new XeroBadRequestException(objectType, payrollCalendars, e);
    }

    public void validationError(String objectType, SuperFunds superFunds, Exception e) {
        throw new XeroBadRequestException(objectType, superFunds, e);
    }

    public void validationError(String objectType, Timesheets timesheets, Exception e) {
        throw new XeroBadRequestException(objectType, timesheets, e);
    }

    public void validationError(String objectType, String msg, Exception e) {
        throw new XeroBadRequestException(400, msg, e);
    }

    public void execute(HttpResponseException e) {
        int statusCode = e.getStatusCode();
        if (statusCode == 400) {
            String message = e.getMessage();
            throw new XeroBadRequestException(statusCode, message, (Exception)((Object)e));
        }
        if (statusCode == 401) {
            String message = "Unauthorized - check your scopes and confirm access to this resource";
            throw new XeroUnauthorizedException(statusCode, message, (Exception)((Object)e));
        }
        if (statusCode == 403) {
            String message = "Forbidden - authentication unsuccessful";
            throw new XeroForbiddenException(statusCode, message, (Exception)((Object)e));
        }
        if (statusCode == 404) {
            String message = "The resource you're looking for cannot be found";
            throw new XeroNotFoundException(statusCode, message, (Exception)((Object)e));
        }
        if (statusCode == 429) {
            String minuteLimitRemainingStr = e.getHeaders().getFirstHeaderStringValue("X-MinLimit-Remaining");
            Integer minuteLimitRemaining = minuteLimitRemainingStr == null ? null : Integer.valueOf(Integer.parseInt(minuteLimitRemainingStr));
            String dayLimitRemainingStr = e.getHeaders().getFirstHeaderStringValue("X-DayLimit-Remaining");
            Integer dayLimitRemaining = dayLimitRemainingStr == null ? null : Integer.valueOf(Integer.parseInt(dayLimitRemainingStr));
            String appMinuteLimitRemainingStr = e.getHeaders().getFirstHeaderStringValue("X-AppMinLimit-Remaining");
            Integer appMinuteLimitRemaining = appMinuteLimitRemainingStr == null ? null : Integer.valueOf(Integer.parseInt(appMinuteLimitRemainingStr));
            String retryAfterSecondsStr = e.getHeaders().getRetryAfter();
            Long retryAfterSeconds = retryAfterSecondsStr == null ? null : Long.valueOf(Long.parseLong(retryAfterSecondsStr));
            String rateLimitProblem = e.getHeaders().getFirstHeaderStringValue("X-Rate-Limit-Problem");
            String message = "You've exceeded the per " + rateLimitProblem + " rate limit";
            if (minuteLimitRemaining != null && minuteLimitRemaining <= 0) {
                throw new XeroMinuteRateLimitException(statusCode, appMinuteLimitRemaining, dayLimitRemaining, minuteLimitRemaining, retryAfterSeconds, message, (Exception)((Object)e));
            }
            if (dayLimitRemaining != null && dayLimitRemaining <= 0) {
                throw new XeroDailyRateLimitException(statusCode, appMinuteLimitRemaining, dayLimitRemaining, minuteLimitRemaining, retryAfterSeconds, message, (Exception)((Object)e));
            }
            if (appMinuteLimitRemaining != null && appMinuteLimitRemaining <= 0) {
                throw new XeroAppMinuteRateLimitException(statusCode, appMinuteLimitRemaining, dayLimitRemaining, minuteLimitRemaining, retryAfterSeconds, message, (Exception)((Object)e));
            }
            throw new XeroRateLimitException(statusCode, appMinuteLimitRemaining, dayLimitRemaining, minuteLimitRemaining, retryAfterSeconds, message, (Exception)((Object)e));
        }
        if (statusCode == 500) {
            String message = "An error occurred in Xero. Check the API Status page http://status.developer.xero.com for current service status.";
            throw new XeroServerErrorException(statusCode, message, (Exception)((Object)e));
        }
        if (statusCode == 501) {
            String message = "The method you have called has not been implemented";
            throw new XeroNotImplementedException(statusCode, message, (Exception)((Object)e));
        }
        if (statusCode == 503) {
            throw new XeroNotAvailableException(statusCode, e.getStatusMessage(), (Exception)((Object)e));
        }
        throw new XeroApiException(statusCode, e.getStatusMessage(), (Exception)((Object)e));
    }

    public void execute(HttpResponseException e, ApiClient apiClient) throws JsonParseException, JsonMappingException, IOException {
        Error error = null;
        int statusCode = e.getStatusCode();
        if (statusCode == 400) {
            TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
            error = (Error)apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
            throw new XeroApiException(statusCode, e.getStatusMessage(), error, (Exception)((Object)e));
        }
        if (statusCode == 404) {
            error = new Error();
            Element elementsItem = new Element();
            ValidationError ve = new ValidationError();
            ve.setMessage("The resource you're looking for cannot be found");
            elementsItem.addValidationErrorsItem(ve);
            error.addElementsItem(elementsItem);
            throw new XeroApiException(statusCode, error, (Exception)((Object)e));
        }
        if (statusCode == 429) {
            error = new Error();
            Element elementsItem = new Element();
            ValidationError ve = new ValidationError();
            ve.setMessage("You've exceeded the per " + e.getHeaders().get((Object)"x-rate-limit-problem") + " rate limit");
            elementsItem.addValidationErrorsItem(ve);
            error.addElementsItem(elementsItem);
            throw new XeroApiException(statusCode, error, (Exception)((Object)e));
        }
        if (statusCode == 401) {
            throw new XeroApiException(statusCode, "Unauthorized - check your scopes and confirm access to this resource", (Exception)((Object)e));
        }
        if (statusCode != 400) {
            throw new XeroApiException(statusCode, e.getStatusMessage(), (Exception)((Object)e));
        }
        throw e;
    }
}

