/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.assets.Asset;
import com.xero.models.assets.AssetStatusQueryParam;
import com.xero.models.assets.AssetType;
import com.xero.models.assets.Assets;
import com.xero.models.assets.Error;
import com.xero.models.assets.Setting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetApi {
    private ApiClient apiClient;
    private static AssetApi instance = null;
    private String userAgent = "Default";
    private String version = "4.12.0";
    static final Logger logger = LoggerFactory.getLogger(AssetApi.class);

    public AssetApi() {
        this(new ApiClient());
    }

    public static AssetApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new AssetApi(apiClient);
        }
        return instance;
    }

    public AssetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public Asset createAsset(String accessToken, String xeroTenantId, Asset asset) throws IOException {
        try {
            TypeReference<Asset> typeRef = new TypeReference<Asset>(){};
            HttpResponse response = this.createAssetForHttpResponse(accessToken, xeroTenantId, asset);
            return (Asset)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createAsset -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error assetError = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError("Asset", assetError, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createAssetForHttpResponse(String accessToken, String xeroTenantId, Asset asset) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createAsset");
        }
        if (asset == null) {
            throw new IllegalArgumentException("Missing the required parameter 'asset' when calling createAsset");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createAsset");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Assets"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(asset);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public AssetType createAssetType(String accessToken, String xeroTenantId, AssetType assetType) throws IOException {
        try {
            TypeReference<AssetType> typeRef = new TypeReference<AssetType>(){};
            HttpResponse response = this.createAssetTypeForHttpResponse(accessToken, xeroTenantId, assetType);
            return (AssetType)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createAssetType -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error assetError = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError("AssetType", assetError, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createAssetTypeForHttpResponse(String accessToken, String xeroTenantId, AssetType assetType) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createAssetType");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createAssetType");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/AssetTypes"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(assetType);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Asset getAssetById(String accessToken, String xeroTenantId, UUID id) throws IOException {
        try {
            TypeReference<Asset> typeRef = new TypeReference<Asset>(){};
            HttpResponse response = this.getAssetByIdForHttpResponse(accessToken, xeroTenantId, id);
            return (Asset)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAssetById -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAssetByIdForHttpResponse(String accessToken, String xeroTenantId, UUID id) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAssetById");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling getAssetById");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAssetById");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("id", id);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Assets/{id}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Setting getAssetSettings(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<Setting> typeRef = new TypeReference<Setting>(){};
            HttpResponse response = this.getAssetSettingsForHttpResponse(accessToken, xeroTenantId);
            return (Setting)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAssetSettings -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAssetSettingsForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAssetSettings");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAssetSettings");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Settings"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public List<AssetType> getAssetTypes(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<List<AssetType>> typeRef = new TypeReference<List<AssetType>>(){};
            HttpResponse response = this.getAssetTypesForHttpResponse(accessToken, xeroTenantId);
            return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAssetTypes -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAssetTypesForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAssetTypes");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAssetTypes");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/AssetTypes"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Assets getAssets(String accessToken, String xeroTenantId, AssetStatusQueryParam status, Integer page, Integer pageSize, String orderBy, String sortDirection, String filterBy) throws IOException {
        try {
            TypeReference<Assets> typeRef = new TypeReference<Assets>(){};
            HttpResponse response = this.getAssetsForHttpResponse(accessToken, xeroTenantId, status, page, pageSize, orderBy, sortDirection, filterBy);
            return (Assets)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAssets -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAssetsForHttpResponse(String accessToken, String xeroTenantId, AssetStatusQueryParam status, Integer page, Integer pageSize, String orderBy, String sortDirection, String filterBy) throws IOException {
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAssets");
        }
        if (status == null) {
            throw new IllegalArgumentException("Missing the required parameter 'status' when calling getAssets");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAssets");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Assets"));
        if (status != null) {
            key = "status";
            value = status;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (page != null) {
            key = "page";
            value = page;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (orderBy != null) {
            key = "orderBy";
            value = orderBy;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (sortDirection != null) {
            key = "sortDirection";
            value = sortDirection;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (filterBy != null) {
            key = "filterBy";
            value = filterBy;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream2;
        }
        finally {
            is.close();
        }
    }
}

