/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.accounting.Error;
import com.xero.models.payrollau.Employee;
import com.xero.models.payrollau.Employees;
import com.xero.models.payrollau.LeaveApplication;
import com.xero.models.payrollau.LeaveApplications;
import com.xero.models.payrollau.PayItem;
import com.xero.models.payrollau.PayItems;
import com.xero.models.payrollau.PayRun;
import com.xero.models.payrollau.PayRuns;
import com.xero.models.payrollau.PayrollCalendar;
import com.xero.models.payrollau.PayrollCalendars;
import com.xero.models.payrollau.PayslipLines;
import com.xero.models.payrollau.PayslipObject;
import com.xero.models.payrollau.Payslips;
import com.xero.models.payrollau.SettingsObject;
import com.xero.models.payrollau.SuperFund;
import com.xero.models.payrollau.SuperFundProducts;
import com.xero.models.payrollau.SuperFunds;
import com.xero.models.payrollau.Timesheet;
import com.xero.models.payrollau.TimesheetObject;
import com.xero.models.payrollau.Timesheets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayrollAuApi {
    private ApiClient apiClient;
    private static PayrollAuApi instance = null;
    private String userAgent = "Default";
    private String version = "4.12.0";
    static final Logger logger = LoggerFactory.getLogger(PayrollAuApi.class);

    public PayrollAuApi() {
        this(new ApiClient());
    }

    public static PayrollAuApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new PayrollAuApi(apiClient);
        }
        return instance;
    }

    public PayrollAuApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public Employees createEmployee(String accessToken, String xeroTenantId, List<Employee> employee) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.createEmployeeForHttpResponse(accessToken, xeroTenantId, employee);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createEmployee -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Employees> objectTypeRef = new TypeReference<Employees>(){};
                Employees object = (Employees)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)objectTypeRef);
                if (object.getEmployees() == null || object.getEmployees().isEmpty()) {
                    TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                    Error error = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                    handler.validationError("Error", error.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Employees", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createEmployeeForHttpResponse(String accessToken, String xeroTenantId, List<Employee> employee) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createEmployee");
        }
        if (employee == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employee' when calling createEmployee");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createEmployee");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employee);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LeaveApplications createLeaveApplication(String accessToken, String xeroTenantId, List<LeaveApplication> leaveApplication) throws IOException {
        try {
            TypeReference<LeaveApplications> typeRef = new TypeReference<LeaveApplications>(){};
            HttpResponse response = this.createLeaveApplicationForHttpResponse(accessToken, xeroTenantId, leaveApplication);
            return (LeaveApplications)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createLeaveApplication -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<LeaveApplications> objectTypeRef = new TypeReference<LeaveApplications>(){};
                LeaveApplications object = (LeaveApplications)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)objectTypeRef);
                if (object.getLeaveApplications() == null || object.getLeaveApplications().isEmpty()) {
                    TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                    Error error = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                    handler.validationError("Error", error.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("LeaveApplications", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createLeaveApplicationForHttpResponse(String accessToken, String xeroTenantId, List<LeaveApplication> leaveApplication) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createLeaveApplication");
        }
        if (leaveApplication == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveApplication' when calling createLeaveApplication");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createLeaveApplication");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LeaveApplications"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(leaveApplication);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayItems createPayItem(String accessToken, String xeroTenantId, PayItem payItem) throws IOException {
        try {
            TypeReference<PayItems> typeRef = new TypeReference<PayItems>(){};
            HttpResponse response = this.createPayItemForHttpResponse(accessToken, xeroTenantId, payItem);
            return (PayItems)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPayItem -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPayItemForHttpResponse(String accessToken, String xeroTenantId, PayItem payItem) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPayItem");
        }
        if (payItem == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payItem' when calling createPayItem");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPayItem");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayItems"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payItem);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRuns createPayRun(String accessToken, String xeroTenantId, List<PayRun> payRun) throws IOException {
        try {
            TypeReference<PayRuns> typeRef = new TypeReference<PayRuns>(){};
            HttpResponse response = this.createPayRunForHttpResponse(accessToken, xeroTenantId, payRun);
            return (PayRuns)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPayRun -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayRuns> objectTypeRef = new TypeReference<PayRuns>(){};
                PayRuns object = (PayRuns)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)objectTypeRef);
                if (object.getPayRuns() == null || object.getPayRuns().isEmpty()) {
                    TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                    Error error = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                    handler.validationError("Error", error.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("PayRuns", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPayRunForHttpResponse(String accessToken, String xeroTenantId, List<PayRun> payRun) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPayRun");
        }
        if (payRun == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRun' when calling createPayRun");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPayRun");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRuns"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payRun);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayrollCalendars createPayrollCalendar(String accessToken, String xeroTenantId, List<PayrollCalendar> payrollCalendar) throws IOException {
        try {
            TypeReference<PayrollCalendars> typeRef = new TypeReference<PayrollCalendars>(){};
            HttpResponse response = this.createPayrollCalendarForHttpResponse(accessToken, xeroTenantId, payrollCalendar);
            return (PayrollCalendars)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createPayrollCalendar -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<PayrollCalendars> objectTypeRef = new TypeReference<PayrollCalendars>(){};
                PayrollCalendars object = (PayrollCalendars)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)objectTypeRef);
                if (object.getPayrollCalendars() == null || object.getPayrollCalendars().isEmpty()) {
                    TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                    Error error = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                    handler.validationError("Error", error.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("PayrollCalendars", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createPayrollCalendarForHttpResponse(String accessToken, String xeroTenantId, List<PayrollCalendar> payrollCalendar) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createPayrollCalendar");
        }
        if (payrollCalendar == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payrollCalendar' when calling createPayrollCalendar");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createPayrollCalendar");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayrollCalendars"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payrollCalendar);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SuperFunds createSuperfund(String accessToken, String xeroTenantId, List<SuperFund> superFund) throws IOException {
        try {
            TypeReference<SuperFunds> typeRef = new TypeReference<SuperFunds>(){};
            HttpResponse response = this.createSuperfundForHttpResponse(accessToken, xeroTenantId, superFund);
            return (SuperFunds)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createSuperfund -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<SuperFunds> objectTypeRef = new TypeReference<SuperFunds>(){};
                SuperFunds object = (SuperFunds)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)objectTypeRef);
                if (object.getSuperFunds() == null || object.getSuperFunds().isEmpty()) {
                    TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                    Error error = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                    handler.validationError("Error", error.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("SuperFunds", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createSuperfundForHttpResponse(String accessToken, String xeroTenantId, List<SuperFund> superFund) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createSuperfund");
        }
        if (superFund == null) {
            throw new IllegalArgumentException("Missing the required parameter 'superFund' when calling createSuperfund");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createSuperfund");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Superfunds"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(superFund);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Timesheets createTimesheet(String accessToken, String xeroTenantId, List<Timesheet> timesheet) throws IOException {
        try {
            TypeReference<Timesheets> typeRef = new TypeReference<Timesheets>(){};
            HttpResponse response = this.createTimesheetForHttpResponse(accessToken, xeroTenantId, timesheet);
            return (Timesheets)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createTimesheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Timesheets> objectTypeRef = new TypeReference<Timesheets>(){};
                Timesheets object = (Timesheets)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)objectTypeRef);
                if (object.getTimesheets() == null || object.getTimesheets().isEmpty()) {
                    TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                    Error error = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                    handler.validationError("Error", error.getMessage(), (Exception)((Object)e));
                }
                handler.validationError("Timesheets", object, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createTimesheetForHttpResponse(String accessToken, String xeroTenantId, List<Timesheet> timesheet) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createTimesheet");
        }
        if (timesheet == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheet' when calling createTimesheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createTimesheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(timesheet);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Employees getEmployee(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.getEmployeeForHttpResponse(accessToken, xeroTenantId, employeeID);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployee -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeeForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployee");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling getEmployee");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployee");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Employees getEmployees(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.getEmployeesForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getEmployees -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getEmployeesForHttpResponse(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getEmployees");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getEmployees");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("If-Modified-Since", (Object)ifModifiedSince);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees"));
        if (where != null) {
            key = "where";
            value = where;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (order != null) {
            key = "order";
            value = order;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (page != null) {
            key = "page";
            value = page;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LeaveApplications getLeaveApplication(String accessToken, String xeroTenantId, UUID leaveApplicationID) throws IOException {
        try {
            TypeReference<LeaveApplications> typeRef = new TypeReference<LeaveApplications>(){};
            HttpResponse response = this.getLeaveApplicationForHttpResponse(accessToken, xeroTenantId, leaveApplicationID);
            return (LeaveApplications)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getLeaveApplication -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getLeaveApplicationForHttpResponse(String accessToken, String xeroTenantId, UUID leaveApplicationID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getLeaveApplication");
        }
        if (leaveApplicationID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveApplicationID' when calling getLeaveApplication");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getLeaveApplication");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("LeaveApplicationID", leaveApplicationID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LeaveApplications/{LeaveApplicationID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LeaveApplications getLeaveApplications(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            TypeReference<LeaveApplications> typeRef = new TypeReference<LeaveApplications>(){};
            HttpResponse response = this.getLeaveApplicationsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page);
            return (LeaveApplications)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getLeaveApplications -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getLeaveApplicationsForHttpResponse(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getLeaveApplications");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getLeaveApplications");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("If-Modified-Since", (Object)ifModifiedSince);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LeaveApplications"));
        if (where != null) {
            key = "where";
            value = where;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (order != null) {
            key = "order";
            value = order;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (page != null) {
            key = "page";
            value = page;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayItems getPayItems(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            TypeReference<PayItems> typeRef = new TypeReference<PayItems>(){};
            HttpResponse response = this.getPayItemsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page);
            return (PayItems)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayItems -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayItemsForHttpResponse(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayItems");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayItems");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("If-Modified-Since", (Object)ifModifiedSince);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayItems"));
        if (where != null) {
            key = "where";
            value = where;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (order != null) {
            key = "order";
            value = order;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (page != null) {
            key = "page";
            value = page;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRuns getPayRun(String accessToken, String xeroTenantId, UUID payRunID) throws IOException {
        try {
            TypeReference<PayRuns> typeRef = new TypeReference<PayRuns>(){};
            HttpResponse response = this.getPayRunForHttpResponse(accessToken, xeroTenantId, payRunID);
            return (PayRuns)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayRun -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayRunForHttpResponse(String accessToken, String xeroTenantId, UUID payRunID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayRun");
        }
        if (payRunID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRunID' when calling getPayRun");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayRun");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayRunID", payRunID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRuns/{PayRunID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRuns getPayRuns(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            TypeReference<PayRuns> typeRef = new TypeReference<PayRuns>(){};
            HttpResponse response = this.getPayRunsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page);
            return (PayRuns)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayRuns -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayRunsForHttpResponse(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayRuns");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayRuns");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("If-Modified-Since", (Object)ifModifiedSince);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRuns"));
        if (where != null) {
            key = "where";
            value = where;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (order != null) {
            key = "order";
            value = order;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (page != null) {
            key = "page";
            value = page;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayrollCalendars getPayrollCalendar(String accessToken, String xeroTenantId, UUID payrollCalendarID) throws IOException {
        try {
            TypeReference<PayrollCalendars> typeRef = new TypeReference<PayrollCalendars>(){};
            HttpResponse response = this.getPayrollCalendarForHttpResponse(accessToken, xeroTenantId, payrollCalendarID);
            return (PayrollCalendars)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayrollCalendar -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayrollCalendarForHttpResponse(String accessToken, String xeroTenantId, UUID payrollCalendarID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayrollCalendar");
        }
        if (payrollCalendarID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payrollCalendarID' when calling getPayrollCalendar");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayrollCalendar");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayrollCalendarID", payrollCalendarID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayrollCalendars/{PayrollCalendarID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayrollCalendars getPayrollCalendars(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            TypeReference<PayrollCalendars> typeRef = new TypeReference<PayrollCalendars>(){};
            HttpResponse response = this.getPayrollCalendarsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page);
            return (PayrollCalendars)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayrollCalendars -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayrollCalendarsForHttpResponse(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayrollCalendars");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayrollCalendars");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("If-Modified-Since", (Object)ifModifiedSince);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayrollCalendars"));
        if (where != null) {
            key = "where";
            value = where;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (order != null) {
            key = "order";
            value = order;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (page != null) {
            key = "page";
            value = page;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayslipObject getPayslip(String accessToken, String xeroTenantId, UUID payslipID) throws IOException {
        try {
            TypeReference<PayslipObject> typeRef = new TypeReference<PayslipObject>(){};
            HttpResponse response = this.getPayslipForHttpResponse(accessToken, xeroTenantId, payslipID);
            return (PayslipObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getPayslip -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getPayslipForHttpResponse(String accessToken, String xeroTenantId, UUID payslipID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getPayslip");
        }
        if (payslipID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payslipID' when calling getPayslip");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getPayslip");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayslipID", payslipID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payslip/{PayslipID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SettingsObject getSettings(String accessToken, String xeroTenantId) throws IOException {
        try {
            TypeReference<SettingsObject> typeRef = new TypeReference<SettingsObject>(){};
            HttpResponse response = this.getSettingsForHttpResponse(accessToken, xeroTenantId);
            return (SettingsObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getSettings -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getSettingsForHttpResponse(String accessToken, String xeroTenantId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getSettings");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getSettings");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Settings"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SuperFunds getSuperfund(String accessToken, String xeroTenantId, UUID superFundID) throws IOException {
        try {
            TypeReference<SuperFunds> typeRef = new TypeReference<SuperFunds>(){};
            HttpResponse response = this.getSuperfundForHttpResponse(accessToken, xeroTenantId, superFundID);
            return (SuperFunds)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getSuperfund -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getSuperfundForHttpResponse(String accessToken, String xeroTenantId, UUID superFundID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getSuperfund");
        }
        if (superFundID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'superFundID' when calling getSuperfund");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getSuperfund");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("SuperFundID", superFundID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Superfunds/{SuperFundID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SuperFundProducts getSuperfundProducts(String accessToken, String xeroTenantId, String ABN, String USI) throws IOException {
        try {
            TypeReference<SuperFundProducts> typeRef = new TypeReference<SuperFundProducts>(){};
            HttpResponse response = this.getSuperfundProductsForHttpResponse(accessToken, xeroTenantId, ABN, USI);
            return (SuperFundProducts)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getSuperfundProducts -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getSuperfundProductsForHttpResponse(String accessToken, String xeroTenantId, String ABN, String USI) throws IOException {
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getSuperfundProducts");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getSuperfundProducts");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/SuperfundProducts"));
        if (ABN != null) {
            key = "ABN";
            value = ABN;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (USI != null) {
            key = "USI";
            value = USI;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SuperFunds getSuperfunds(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            TypeReference<SuperFunds> typeRef = new TypeReference<SuperFunds>(){};
            HttpResponse response = this.getSuperfundsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page);
            return (SuperFunds)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getSuperfunds -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getSuperfundsForHttpResponse(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getSuperfunds");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getSuperfunds");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("If-Modified-Since", (Object)ifModifiedSince);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Superfunds"));
        if (where != null) {
            key = "where";
            value = where;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (order != null) {
            key = "order";
            value = order;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (page != null) {
            key = "page";
            value = page;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimesheetObject getTimesheet(String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
        try {
            TypeReference<TimesheetObject> typeRef = new TypeReference<TimesheetObject>(){};
            HttpResponse response = this.getTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID);
            return (TimesheetObject)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTimesheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTimesheetForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTimesheet");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling getTimesheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTimesheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Timesheets getTimesheets(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        try {
            TypeReference<Timesheets> typeRef = new TypeReference<Timesheets>(){};
            HttpResponse response = this.getTimesheetsForHttpResponse(accessToken, xeroTenantId, ifModifiedSince, where, order, page);
            return (Timesheets)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTimesheets -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTimesheetsForHttpResponse(String accessToken, String xeroTenantId, String ifModifiedSince, String where, String order, Integer page) throws IOException {
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTimesheets");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTimesheets");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("If-Modified-Since", (Object)ifModifiedSince);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets"));
        if (where != null) {
            key = "where";
            value = where;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (order != null) {
            key = "order";
            value = order;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (page != null) {
            key = "page";
            value = page;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)value).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Employees updateEmployee(String accessToken, String xeroTenantId, UUID employeeID, List<Employee> employee) throws IOException {
        try {
            TypeReference<Employees> typeRef = new TypeReference<Employees>(){};
            HttpResponse response = this.updateEmployeeForHttpResponse(accessToken, xeroTenantId, employeeID, employee);
            return (Employees)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateEmployee -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateEmployeeForHttpResponse(String accessToken, String xeroTenantId, UUID employeeID, List<Employee> employee) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateEmployee");
        }
        if (employeeID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'employeeID' when calling updateEmployee");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateEmployee");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("EmployeeID", employeeID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Employees/{EmployeeID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(employee);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LeaveApplications updateLeaveApplication(String accessToken, String xeroTenantId, UUID leaveApplicationID, List<LeaveApplication> leaveApplication) throws IOException {
        try {
            TypeReference<LeaveApplications> typeRef = new TypeReference<LeaveApplications>(){};
            HttpResponse response = this.updateLeaveApplicationForHttpResponse(accessToken, xeroTenantId, leaveApplicationID, leaveApplication);
            return (LeaveApplications)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateLeaveApplication -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateLeaveApplicationForHttpResponse(String accessToken, String xeroTenantId, UUID leaveApplicationID, List<LeaveApplication> leaveApplication) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateLeaveApplication");
        }
        if (leaveApplicationID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveApplicationID' when calling updateLeaveApplication");
        }
        if (leaveApplication == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leaveApplication' when calling updateLeaveApplication");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateLeaveApplication");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("LeaveApplicationID", leaveApplicationID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/LeaveApplications/{LeaveApplicationID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(leaveApplication);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public PayRuns updatePayRun(String accessToken, String xeroTenantId, UUID payRunID, List<PayRun> payRun) throws IOException {
        try {
            TypeReference<PayRuns> typeRef = new TypeReference<PayRuns>(){};
            HttpResponse response = this.updatePayRunForHttpResponse(accessToken, xeroTenantId, payRunID, payRun);
            return (PayRuns)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updatePayRun -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updatePayRunForHttpResponse(String accessToken, String xeroTenantId, UUID payRunID, List<PayRun> payRun) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updatePayRun");
        }
        if (payRunID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payRunID' when calling updatePayRun");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updatePayRun");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayRunID", payRunID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/PayRuns/{PayRunID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payRun);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Payslips updatePayslip(String accessToken, String xeroTenantId, UUID payslipID, List<PayslipLines> payslipLines) throws IOException {
        try {
            TypeReference<Payslips> typeRef = new TypeReference<Payslips>(){};
            HttpResponse response = this.updatePayslipForHttpResponse(accessToken, xeroTenantId, payslipID, payslipLines);
            return (Payslips)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updatePayslip -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400 || e.getStatusCode() == 405) {
                TypeReference<Error> errorTypeRef = new TypeReference<Error>(){};
                Error error = (Error)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError("Error", error.getMessage(), (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updatePayslipForHttpResponse(String accessToken, String xeroTenantId, UUID payslipID, List<PayslipLines> payslipLines) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updatePayslip");
        }
        if (payslipID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'payslipID' when calling updatePayslip");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updatePayslip");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("PayslipID", payslipID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Payslip/{PayslipID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(payslipLines);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public SuperFunds updateSuperfund(String accessToken, String xeroTenantId, UUID superFundID, List<SuperFund> superFund) throws IOException {
        try {
            TypeReference<SuperFunds> typeRef = new TypeReference<SuperFunds>(){};
            HttpResponse response = this.updateSuperfundForHttpResponse(accessToken, xeroTenantId, superFundID, superFund);
            return (SuperFunds)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateSuperfund -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateSuperfundForHttpResponse(String accessToken, String xeroTenantId, UUID superFundID, List<SuperFund> superFund) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateSuperfund");
        }
        if (superFundID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'superFundID' when calling updateSuperfund");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateSuperfund");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("SuperFundID", superFundID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Superfunds/{SuperFundID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(superFund);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Timesheets updateTimesheet(String accessToken, String xeroTenantId, UUID timesheetID, List<Timesheet> timesheet) throws IOException {
        try {
            TypeReference<Timesheets> typeRef = new TypeReference<Timesheets>(){};
            HttpResponse response = this.updateTimesheetForHttpResponse(accessToken, xeroTenantId, timesheetID, timesheet);
            return (Timesheets)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateTimesheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse updateTimesheetForHttpResponse(String accessToken, String xeroTenantId, UUID timesheetID, List<Timesheet> timesheet) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateTimesheet");
        }
        if (timesheetID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timesheetID' when calling updateTimesheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateTimesheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("TimesheetID", timesheetID);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Timesheets/{TimesheetID}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        Objects.requireNonNull(apiClient);
        content = apiClient.new ApiClient.JacksonJsonHttpContent(timesheet);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream2;
        }
        finally {
            is.close();
        }
    }
}

