/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Account;
import com.xero.models.accounting.Payment;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class BatchPayment {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Account")
    private Account account;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="Particulars")
    private String particulars;
    @JsonProperty(value="Code")
    private String code;
    @JsonProperty(value="Details")
    private String details;
    @JsonProperty(value="Narrative")
    private String narrative;
    @JsonProperty(value="BatchPaymentID")
    private UUID batchPaymentID;
    @JsonProperty(value="DateString")
    private String dateString;
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="Amount")
    private Double amount;
    @JsonProperty(value="Payments")
    private List<Payment> payments = new ArrayList<Payment>();
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="TotalAmount")
    private String totalAmount;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="IsReconciled")
    private String isReconciled;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public BatchPayment account(Account account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(value="")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public BatchPayment reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="(NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BatchPayment particulars(String particulars) {
        this.particulars = particulars;
        return this;
    }

    @ApiModelProperty(value="(NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.")
    public String getParticulars() {
        return this.particulars;
    }

    public void setParticulars(String particulars) {
        this.particulars = particulars;
    }

    public BatchPayment code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="(NZ Only) Optional references for the batch payment transaction. It will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement you import into Xero.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BatchPayment details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(value="(Non-NZ Only) These details are sent to the org\u2019s bank as a reference for the batch payment transaction. They will also show with the batch payment transaction in the bank reconciliation Find & Match screen. Depending on your individual bank, the detail may also show on the bank statement imported into Xero. Maximum field length = 18")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public BatchPayment narrative(String narrative) {
        this.narrative = narrative;
        return this;
    }

    @ApiModelProperty(value="(UK Only) Only shows on the statement line in Xero. Max length =18")
    public String getNarrative() {
        return this.narrative;
    }

    public void setNarrative(String narrative) {
        this.narrative = narrative;
    }

    @ApiModelProperty(value="The Xero generated unique identifier for the bank transaction (read-only)")
    public UUID getBatchPaymentID() {
        return this.batchPaymentID;
    }

    public BatchPayment dateString(String dateString) {
        this.dateString = dateString;
        return this;
    }

    @ApiModelProperty(value="Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06")
    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public BatchPayment date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public BatchPayment amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount of the payment. Must be less than or equal to the outstanding amount owing on the invoice e.g. 200.00")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public BatchPayment payments(List<Payment> payments) {
        this.payments = payments;
        return this;
    }

    public BatchPayment addPaymentsItem(Payment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(value="An array of payments")
    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    @ApiModelProperty(value="PAYBATCH for bill payments or RECBATCH for sales invoice payments (read-only)")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(value="AUTHORISED or DELETED (read-only). New batch payments will have a status of AUTHORISED. It is not possible to delete batch payments via the API.")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(value="The total of the payments that make up the batch (read-only)")
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="UTC timestamp of last update to the payment")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @ApiModelProperty(value="Booelan that tells you if the batch payment has been reconciled (read-only)")
    public String getIsReconciled() {
        return this.isReconciled;
    }

    public BatchPayment validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public BatchPayment addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPayment batchPayment = (BatchPayment)o;
        return Objects.equals(this.account, batchPayment.account) && Objects.equals(this.reference, batchPayment.reference) && Objects.equals(this.particulars, batchPayment.particulars) && Objects.equals(this.code, batchPayment.code) && Objects.equals(this.details, batchPayment.details) && Objects.equals(this.narrative, batchPayment.narrative) && Objects.equals(this.batchPaymentID, batchPayment.batchPaymentID) && Objects.equals(this.dateString, batchPayment.dateString) && Objects.equals(this.date, batchPayment.date) && Objects.equals(this.amount, batchPayment.amount) && Objects.equals(this.payments, batchPayment.payments) && Objects.equals((Object)this.type, (Object)batchPayment.type) && Objects.equals((Object)this.status, (Object)batchPayment.status) && Objects.equals(this.totalAmount, batchPayment.totalAmount) && Objects.equals(this.updatedDateUTC, batchPayment.updatedDateUTC) && Objects.equals(this.isReconciled, batchPayment.isReconciled) && Objects.equals(this.validationErrors, batchPayment.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.account, this.reference, this.particulars, this.code, this.details, this.narrative, this.batchPaymentID, this.dateString, this.date, this.amount, this.payments, this.type, this.status, this.totalAmount, this.updatedDateUTC, this.isReconciled, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchPayment {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    particulars: ").append(this.toIndentedString(this.particulars)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    narrative: ").append(this.toIndentedString(this.narrative)).append("\n");
        sb.append("    batchPaymentID: ").append(this.toIndentedString(this.batchPaymentID)).append("\n");
        sb.append("    dateString: ").append(this.toIndentedString(this.dateString)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    isReconciled: ").append(this.toIndentedString(this.isReconciled)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        AUTHORISED("AUTHORISED"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        PAYBATCH("PAYBATCH"),
        RECBATCH("RECBATCH");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

