/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;

public class BudgetBalance {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Period")
    private String period;
    @JsonProperty(value="Amount")
    private Integer amount;
    @JsonProperty(value="UnitAmount")
    private Integer unitAmount;
    @JsonProperty(value="Notes")
    private String notes;

    public BudgetBalance period(String period) {
        this.period = period;
        return this;
    }

    @ApiModelProperty(value="Period the amount applies to (e.g. \u201c2019-08\u201d)")
    public String getPeriod() {
        return this.period;
    }

    public LocalDate getPeriodAsDate() {
        if (this.period != null) {
            try {
                return this.util.convertStringToDate(this.period);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setPeriod(LocalDate period) {
        Instant instant = period.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.period = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public BudgetBalance amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="LineItem Quantity")
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public BudgetBalance unitAmount(Integer unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @ApiModelProperty(value="Budgeted amount")
    public Integer getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(Integer unitAmount) {
        this.unitAmount = unitAmount;
    }

    public BudgetBalance notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="Any footnotes associated with this balance")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BudgetBalance budgetBalance = (BudgetBalance)o;
        return Objects.equals(this.period, budgetBalance.period) && Objects.equals(this.amount, budgetBalance.amount) && Objects.equals(this.unitAmount, budgetBalance.unitAmount) && Objects.equals(this.notes, budgetBalance.notes);
    }

    public int hashCode() {
        return Objects.hash(this.period, this.amount, this.unitAmount, this.notes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BudgetBalance {\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

