/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Address;
import com.xero.models.accounting.Attachment;
import com.xero.models.accounting.Balances;
import com.xero.models.accounting.BatchPaymentDetails;
import com.xero.models.accounting.BrandingTheme;
import com.xero.models.accounting.ContactGroup;
import com.xero.models.accounting.ContactPerson;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.PaymentTerm;
import com.xero.models.accounting.Phone;
import com.xero.models.accounting.SalesTrackingCategory;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Contact {
    StringUtil util = new StringUtil();
    @JsonProperty(value="ContactID")
    private UUID contactID;
    @JsonProperty(value="ContactNumber")
    private String contactNumber;
    @JsonProperty(value="AccountNumber")
    private String accountNumber;
    @JsonProperty(value="ContactStatus")
    private ContactStatusEnum contactStatus;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="FirstName")
    private String firstName;
    @JsonProperty(value="LastName")
    private String lastName;
    @JsonProperty(value="EmailAddress")
    private String emailAddress;
    @JsonProperty(value="SkypeUserName")
    private String skypeUserName;
    @JsonProperty(value="ContactPersons")
    private List<ContactPerson> contactPersons = new ArrayList<ContactPerson>();
    @JsonProperty(value="BankAccountDetails")
    private String bankAccountDetails;
    @JsonProperty(value="TaxNumber")
    private String taxNumber;
    @JsonProperty(value="AccountsReceivableTaxType")
    private String accountsReceivableTaxType;
    @JsonProperty(value="AccountsPayableTaxType")
    private String accountsPayableTaxType;
    @JsonProperty(value="Addresses")
    private List<Address> addresses = new ArrayList<Address>();
    @JsonProperty(value="Phones")
    private List<Phone> phones = new ArrayList<Phone>();
    @JsonProperty(value="IsSupplier")
    private Boolean isSupplier;
    @JsonProperty(value="IsCustomer")
    private Boolean isCustomer;
    @JsonProperty(value="DefaultCurrency")
    private CurrencyCode defaultCurrency;
    @JsonProperty(value="XeroNetworkKey")
    private String xeroNetworkKey;
    @JsonProperty(value="SalesDefaultAccountCode")
    private String salesDefaultAccountCode;
    @JsonProperty(value="PurchasesDefaultAccountCode")
    private String purchasesDefaultAccountCode;
    @JsonProperty(value="SalesTrackingCategories")
    private List<SalesTrackingCategory> salesTrackingCategories = new ArrayList<SalesTrackingCategory>();
    @JsonProperty(value="PurchasesTrackingCategories")
    private List<SalesTrackingCategory> purchasesTrackingCategories = new ArrayList<SalesTrackingCategory>();
    @JsonProperty(value="TrackingCategoryName")
    private String trackingCategoryName;
    @JsonProperty(value="TrackingCategoryOption")
    private String trackingCategoryOption;
    @JsonProperty(value="PaymentTerms")
    private PaymentTerm paymentTerms;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="ContactGroups")
    private List<ContactGroup> contactGroups = new ArrayList<ContactGroup>();
    @JsonProperty(value="Website")
    private String website;
    @JsonProperty(value="BrandingTheme")
    private BrandingTheme brandingTheme;
    @JsonProperty(value="BatchPayments")
    private BatchPaymentDetails batchPayments;
    @JsonProperty(value="Discount")
    private Double discount;
    @JsonProperty(value="Balances")
    private Balances balances;
    @JsonProperty(value="Attachments")
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();
    @JsonProperty(value="HasValidationErrors")
    private Boolean hasValidationErrors = false;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;

    public Contact contactID(UUID contactID) {
        this.contactID = contactID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getContactID() {
        return this.contactID;
    }

    public void setContactID(UUID contactID) {
        this.contactID = contactID;
    }

    public Contact contactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
        return this;
    }

    @ApiModelProperty(value="This can be updated via the API only i.e. This field is read only on the Xero contact screen, used to identify contacts in external systems (max length = 50). If the Contact Number is used, this is displayed as Contact Code in the Contacts UI in Xero.")
    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public Contact accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(value="A user defined account number. This can be updated via the API and the Xero UI (max length = 50)")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Contact contactStatus(ContactStatusEnum contactStatus) {
        this.contactStatus = contactStatus;
        return this;
    }

    @ApiModelProperty(value="Current status of a contact \u2013 see contact status types")
    public ContactStatusEnum getContactStatus() {
        return this.contactStatus;
    }

    public void setContactStatus(ContactStatusEnum contactStatus) {
        this.contactStatus = contactStatus;
    }

    public Contact name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Full name of contact/organisation (max length = 255)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Contact firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="First name of contact person (max length = 255)")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Contact lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="Last name of contact person (max length = 255)")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Contact emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(value="Email address of contact person (umlauts not supported) (max length  = 255)")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Contact skypeUserName(String skypeUserName) {
        this.skypeUserName = skypeUserName;
        return this;
    }

    @ApiModelProperty(value="Skype user name of contact")
    public String getSkypeUserName() {
        return this.skypeUserName;
    }

    public void setSkypeUserName(String skypeUserName) {
        this.skypeUserName = skypeUserName;
    }

    public Contact contactPersons(List<ContactPerson> contactPersons) {
        this.contactPersons = contactPersons;
        return this;
    }

    public Contact addContactPersonsItem(ContactPerson contactPersonsItem) {
        if (this.contactPersons == null) {
            this.contactPersons = new ArrayList<ContactPerson>();
        }
        this.contactPersons.add(contactPersonsItem);
        return this;
    }

    @ApiModelProperty(value="See contact persons")
    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public void setContactPersons(List<ContactPerson> contactPersons) {
        this.contactPersons = contactPersons;
    }

    public Contact bankAccountDetails(String bankAccountDetails) {
        this.bankAccountDetails = bankAccountDetails;
        return this;
    }

    @ApiModelProperty(value="Bank account number of contact")
    public String getBankAccountDetails() {
        return this.bankAccountDetails;
    }

    public void setBankAccountDetails(String bankAccountDetails) {
        this.bankAccountDetails = bankAccountDetails;
    }

    public Contact taxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
        return this;
    }

    @ApiModelProperty(value="Tax number of contact \u2013 this is also known as the ABN (Australia), GST Number (New Zealand), VAT Number (UK) or Tax ID Number (US and global) in the Xero UI depending on which regionalized version of Xero you are using (max length = 50)")
    public String getTaxNumber() {
        return this.taxNumber;
    }

    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public Contact accountsReceivableTaxType(String accountsReceivableTaxType) {
        this.accountsReceivableTaxType = accountsReceivableTaxType;
        return this;
    }

    @ApiModelProperty(value="The tax type from TaxRates")
    public String getAccountsReceivableTaxType() {
        return this.accountsReceivableTaxType;
    }

    public void setAccountsReceivableTaxType(String accountsReceivableTaxType) {
        this.accountsReceivableTaxType = accountsReceivableTaxType;
    }

    public Contact accountsPayableTaxType(String accountsPayableTaxType) {
        this.accountsPayableTaxType = accountsPayableTaxType;
        return this;
    }

    @ApiModelProperty(value="The tax type from TaxRates")
    public String getAccountsPayableTaxType() {
        return this.accountsPayableTaxType;
    }

    public void setAccountsPayableTaxType(String accountsPayableTaxType) {
        this.accountsPayableTaxType = accountsPayableTaxType;
    }

    public Contact addresses(List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    public Contact addAddressesItem(Address addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Address>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @ApiModelProperty(value="Store certain address types for a contact \u2013 see address types")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public Contact phones(List<Phone> phones) {
        this.phones = phones;
        return this;
    }

    public Contact addPhonesItem(Phone phonesItem) {
        if (this.phones == null) {
            this.phones = new ArrayList<Phone>();
        }
        this.phones.add(phonesItem);
        return this;
    }

    @ApiModelProperty(value="Store certain phone types for a contact \u2013 see phone types")
    public List<Phone> getPhones() {
        return this.phones;
    }

    public void setPhones(List<Phone> phones) {
        this.phones = phones;
    }

    public Contact isSupplier(Boolean isSupplier) {
        this.isSupplier = isSupplier;
        return this;
    }

    @ApiModelProperty(value="true or false \u2013 Boolean that describes if a contact that has any AP  invoices entered against them. Cannot be set via PUT or POST \u2013 it is automatically set when an accounts payable invoice is generated against this contact.")
    public Boolean getIsSupplier() {
        return this.isSupplier;
    }

    public void setIsSupplier(Boolean isSupplier) {
        this.isSupplier = isSupplier;
    }

    public Contact isCustomer(Boolean isCustomer) {
        this.isCustomer = isCustomer;
        return this;
    }

    @ApiModelProperty(value="true or false \u2013 Boolean that describes if a contact has any AR invoices entered against them. Cannot be set via PUT or POST \u2013 it is automatically set when an accounts receivable invoice is generated against this contact.")
    public Boolean getIsCustomer() {
        return this.isCustomer;
    }

    public void setIsCustomer(Boolean isCustomer) {
        this.isCustomer = isCustomer;
    }

    public Contact defaultCurrency(CurrencyCode defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public void setDefaultCurrency(CurrencyCode defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    public Contact xeroNetworkKey(String xeroNetworkKey) {
        this.xeroNetworkKey = xeroNetworkKey;
        return this;
    }

    @ApiModelProperty(value="Store XeroNetworkKey for contacts.")
    public String getXeroNetworkKey() {
        return this.xeroNetworkKey;
    }

    public void setXeroNetworkKey(String xeroNetworkKey) {
        this.xeroNetworkKey = xeroNetworkKey;
    }

    public Contact salesDefaultAccountCode(String salesDefaultAccountCode) {
        this.salesDefaultAccountCode = salesDefaultAccountCode;
        return this;
    }

    @ApiModelProperty(value="The default sales account code for contacts")
    public String getSalesDefaultAccountCode() {
        return this.salesDefaultAccountCode;
    }

    public void setSalesDefaultAccountCode(String salesDefaultAccountCode) {
        this.salesDefaultAccountCode = salesDefaultAccountCode;
    }

    public Contact purchasesDefaultAccountCode(String purchasesDefaultAccountCode) {
        this.purchasesDefaultAccountCode = purchasesDefaultAccountCode;
        return this;
    }

    @ApiModelProperty(value="The default purchases account code for contacts")
    public String getPurchasesDefaultAccountCode() {
        return this.purchasesDefaultAccountCode;
    }

    public void setPurchasesDefaultAccountCode(String purchasesDefaultAccountCode) {
        this.purchasesDefaultAccountCode = purchasesDefaultAccountCode;
    }

    public Contact salesTrackingCategories(List<SalesTrackingCategory> salesTrackingCategories) {
        this.salesTrackingCategories = salesTrackingCategories;
        return this;
    }

    public Contact addSalesTrackingCategoriesItem(SalesTrackingCategory salesTrackingCategoriesItem) {
        if (this.salesTrackingCategories == null) {
            this.salesTrackingCategories = new ArrayList<SalesTrackingCategory>();
        }
        this.salesTrackingCategories.add(salesTrackingCategoriesItem);
        return this;
    }

    @ApiModelProperty(value="The default sales tracking categories for contacts")
    public List<SalesTrackingCategory> getSalesTrackingCategories() {
        return this.salesTrackingCategories;
    }

    public void setSalesTrackingCategories(List<SalesTrackingCategory> salesTrackingCategories) {
        this.salesTrackingCategories = salesTrackingCategories;
    }

    public Contact purchasesTrackingCategories(List<SalesTrackingCategory> purchasesTrackingCategories) {
        this.purchasesTrackingCategories = purchasesTrackingCategories;
        return this;
    }

    public Contact addPurchasesTrackingCategoriesItem(SalesTrackingCategory purchasesTrackingCategoriesItem) {
        if (this.purchasesTrackingCategories == null) {
            this.purchasesTrackingCategories = new ArrayList<SalesTrackingCategory>();
        }
        this.purchasesTrackingCategories.add(purchasesTrackingCategoriesItem);
        return this;
    }

    @ApiModelProperty(value="The default purchases tracking categories for contacts")
    public List<SalesTrackingCategory> getPurchasesTrackingCategories() {
        return this.purchasesTrackingCategories;
    }

    public void setPurchasesTrackingCategories(List<SalesTrackingCategory> purchasesTrackingCategories) {
        this.purchasesTrackingCategories = purchasesTrackingCategories;
    }

    public Contact trackingCategoryName(String trackingCategoryName) {
        this.trackingCategoryName = trackingCategoryName;
        return this;
    }

    @ApiModelProperty(value="The name of the Tracking Category assigned to the contact under SalesTrackingCategories and PurchasesTrackingCategories")
    public String getTrackingCategoryName() {
        return this.trackingCategoryName;
    }

    public void setTrackingCategoryName(String trackingCategoryName) {
        this.trackingCategoryName = trackingCategoryName;
    }

    public Contact trackingCategoryOption(String trackingCategoryOption) {
        this.trackingCategoryOption = trackingCategoryOption;
        return this;
    }

    @ApiModelProperty(value="The name of the Tracking Option assigned to the contact under SalesTrackingCategories and PurchasesTrackingCategories")
    public String getTrackingCategoryOption() {
        return this.trackingCategoryOption;
    }

    public void setTrackingCategoryOption(String trackingCategoryOption) {
        this.trackingCategoryOption = trackingCategoryOption;
    }

    public Contact paymentTerms(PaymentTerm paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentTerm getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(PaymentTerm paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="UTC timestamp of last update to contact")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Contact contactGroups(List<ContactGroup> contactGroups) {
        this.contactGroups = contactGroups;
        return this;
    }

    public Contact addContactGroupsItem(ContactGroup contactGroupsItem) {
        if (this.contactGroups == null) {
            this.contactGroups = new ArrayList<ContactGroup>();
        }
        this.contactGroups.add(contactGroupsItem);
        return this;
    }

    @ApiModelProperty(value="Displays which contact groups a contact is included in")
    public List<ContactGroup> getContactGroups() {
        return this.contactGroups;
    }

    public void setContactGroups(List<ContactGroup> contactGroups) {
        this.contactGroups = contactGroups;
    }

    @ApiModelProperty(value="Website address for contact (read only)")
    public String getWebsite() {
        return this.website;
    }

    public Contact brandingTheme(BrandingTheme brandingTheme) {
        this.brandingTheme = brandingTheme;
        return this;
    }

    @ApiModelProperty(value="")
    public BrandingTheme getBrandingTheme() {
        return this.brandingTheme;
    }

    public void setBrandingTheme(BrandingTheme brandingTheme) {
        this.brandingTheme = brandingTheme;
    }

    public Contact batchPayments(BatchPaymentDetails batchPayments) {
        this.batchPayments = batchPayments;
        return this;
    }

    @ApiModelProperty(value="")
    public BatchPaymentDetails getBatchPayments() {
        return this.batchPayments;
    }

    public void setBatchPayments(BatchPaymentDetails batchPayments) {
        this.batchPayments = batchPayments;
    }

    @ApiModelProperty(value="The default discount rate for the contact (read only)")
    public Double getDiscount() {
        return this.discount;
    }

    public Contact balances(Balances balances) {
        this.balances = balances;
        return this;
    }

    @ApiModelProperty(value="")
    public Balances getBalances() {
        return this.balances;
    }

    public void setBalances(Balances balances) {
        this.balances = balances;
    }

    public Contact attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Contact addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of attachments from the API")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Contact hasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    @ApiModelProperty(example="false", value="A boolean to indicate if a contact has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public void setHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }

    public Contact validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Contact addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays validation errors returned from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public Contact hasValidationErrors(Boolean hasValidationErrors) {
        this.hasValidationErrors = hasValidationErrors;
        return this;
    }

    @ApiModelProperty(example="false", value="A boolean to indicate if a contact has an validation errors")
    public Boolean getHasValidationErrors() {
        return this.hasValidationErrors;
    }

    public void setHasValidationErrors(Boolean hasValidationErrors) {
        this.hasValidationErrors = hasValidationErrors;
    }

    public Contact statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(value="Status of object")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.contactID, contact.contactID) && Objects.equals(this.contactNumber, contact.contactNumber) && Objects.equals(this.accountNumber, contact.accountNumber) && Objects.equals((Object)this.contactStatus, (Object)contact.contactStatus) && Objects.equals(this.name, contact.name) && Objects.equals(this.firstName, contact.firstName) && Objects.equals(this.lastName, contact.lastName) && Objects.equals(this.emailAddress, contact.emailAddress) && Objects.equals(this.skypeUserName, contact.skypeUserName) && Objects.equals(this.contactPersons, contact.contactPersons) && Objects.equals(this.bankAccountDetails, contact.bankAccountDetails) && Objects.equals(this.taxNumber, contact.taxNumber) && Objects.equals(this.accountsReceivableTaxType, contact.accountsReceivableTaxType) && Objects.equals(this.accountsPayableTaxType, contact.accountsPayableTaxType) && Objects.equals(this.addresses, contact.addresses) && Objects.equals(this.phones, contact.phones) && Objects.equals(this.isSupplier, contact.isSupplier) && Objects.equals(this.isCustomer, contact.isCustomer) && Objects.equals((Object)this.defaultCurrency, (Object)contact.defaultCurrency) && Objects.equals(this.xeroNetworkKey, contact.xeroNetworkKey) && Objects.equals(this.salesDefaultAccountCode, contact.salesDefaultAccountCode) && Objects.equals(this.purchasesDefaultAccountCode, contact.purchasesDefaultAccountCode) && Objects.equals(this.salesTrackingCategories, contact.salesTrackingCategories) && Objects.equals(this.purchasesTrackingCategories, contact.purchasesTrackingCategories) && Objects.equals(this.trackingCategoryName, contact.trackingCategoryName) && Objects.equals(this.trackingCategoryOption, contact.trackingCategoryOption) && Objects.equals(this.paymentTerms, contact.paymentTerms) && Objects.equals(this.updatedDateUTC, contact.updatedDateUTC) && Objects.equals(this.contactGroups, contact.contactGroups) && Objects.equals(this.website, contact.website) && Objects.equals(this.brandingTheme, contact.brandingTheme) && Objects.equals(this.batchPayments, contact.batchPayments) && Objects.equals(this.discount, contact.discount) && Objects.equals(this.balances, contact.balances) && Objects.equals(this.attachments, contact.attachments) && Objects.equals(this.hasAttachments, contact.hasAttachments) && Objects.equals(this.validationErrors, contact.validationErrors) && Objects.equals(this.hasValidationErrors, contact.hasValidationErrors) && Objects.equals(this.statusAttributeString, contact.statusAttributeString);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contactID, this.contactNumber, this.accountNumber, this.contactStatus, this.name, this.firstName, this.lastName, this.emailAddress, this.skypeUserName, this.contactPersons, this.bankAccountDetails, this.taxNumber, this.accountsReceivableTaxType, this.accountsPayableTaxType, this.addresses, this.phones, this.isSupplier, this.isCustomer, this.defaultCurrency, this.xeroNetworkKey, this.salesDefaultAccountCode, this.purchasesDefaultAccountCode, this.salesTrackingCategories, this.purchasesTrackingCategories, this.trackingCategoryName, this.trackingCategoryOption, this.paymentTerms, this.updatedDateUTC, this.contactGroups, this.website, this.brandingTheme, this.batchPayments, this.discount, this.balances, this.attachments, this.hasAttachments, this.validationErrors, this.hasValidationErrors, this.statusAttributeString});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    contactID: ").append(this.toIndentedString(this.contactID)).append("\n");
        sb.append("    contactNumber: ").append(this.toIndentedString(this.contactNumber)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    contactStatus: ").append(this.toIndentedString((Object)this.contactStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    skypeUserName: ").append(this.toIndentedString(this.skypeUserName)).append("\n");
        sb.append("    contactPersons: ").append(this.toIndentedString(this.contactPersons)).append("\n");
        sb.append("    bankAccountDetails: ").append(this.toIndentedString(this.bankAccountDetails)).append("\n");
        sb.append("    taxNumber: ").append(this.toIndentedString(this.taxNumber)).append("\n");
        sb.append("    accountsReceivableTaxType: ").append(this.toIndentedString(this.accountsReceivableTaxType)).append("\n");
        sb.append("    accountsPayableTaxType: ").append(this.toIndentedString(this.accountsPayableTaxType)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    phones: ").append(this.toIndentedString(this.phones)).append("\n");
        sb.append("    isSupplier: ").append(this.toIndentedString(this.isSupplier)).append("\n");
        sb.append("    isCustomer: ").append(this.toIndentedString(this.isCustomer)).append("\n");
        sb.append("    defaultCurrency: ").append(this.toIndentedString((Object)this.defaultCurrency)).append("\n");
        sb.append("    xeroNetworkKey: ").append(this.toIndentedString(this.xeroNetworkKey)).append("\n");
        sb.append("    salesDefaultAccountCode: ").append(this.toIndentedString(this.salesDefaultAccountCode)).append("\n");
        sb.append("    purchasesDefaultAccountCode: ").append(this.toIndentedString(this.purchasesDefaultAccountCode)).append("\n");
        sb.append("    salesTrackingCategories: ").append(this.toIndentedString(this.salesTrackingCategories)).append("\n");
        sb.append("    purchasesTrackingCategories: ").append(this.toIndentedString(this.purchasesTrackingCategories)).append("\n");
        sb.append("    trackingCategoryName: ").append(this.toIndentedString(this.trackingCategoryName)).append("\n");
        sb.append("    trackingCategoryOption: ").append(this.toIndentedString(this.trackingCategoryOption)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    contactGroups: ").append(this.toIndentedString(this.contactGroups)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    brandingTheme: ").append(this.toIndentedString(this.brandingTheme)).append("\n");
        sb.append("    batchPayments: ").append(this.toIndentedString(this.batchPayments)).append("\n");
        sb.append("    discount: ").append(this.toIndentedString(this.discount)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("    hasValidationErrors: ").append(this.toIndentedString(this.hasValidationErrors)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ContactStatusEnum {
        ACTIVE("ACTIVE"),
        ARCHIVED("ARCHIVED"),
        GDPRREQUEST("GDPRREQUEST");

        private String value;

        private ContactStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContactStatusEnum fromValue(String value) {
            for (ContactStatusEnum b : ContactStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

