/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Contact;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class ContactGroup {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="ContactGroupID")
    private UUID contactGroupID;
    @JsonProperty(value="Contacts")
    private List<Contact> contacts = new ArrayList<Contact>();

    public ContactGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The Name of the contact group. Required when creating a new contact  group")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContactGroup status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The Status of a contact group. To delete a contact group update the status to DELETED. Only contact groups with a status of ACTIVE are returned on GETs.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ContactGroup contactGroupID(UUID contactGroupID) {
        this.contactGroupID = contactGroupID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for an contact group \u2013 specified as a string following the endpoint name. e.g. /297c2dc5-cc47-4afd-8ec8-74990b8761e9")
    public UUID getContactGroupID() {
        return this.contactGroupID;
    }

    public void setContactGroupID(UUID contactGroupID) {
        this.contactGroupID = contactGroupID;
    }

    public ContactGroup contacts(List<Contact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public ContactGroup addContactsItem(Contact contactsItem) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<Contact>();
        }
        this.contacts.add(contactsItem);
        return this;
    }

    @ApiModelProperty(value="The ContactID and Name of Contacts in a contact group. Returned on GETs when the ContactGroupID is supplied in the URL.")
    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactGroup contactGroup = (ContactGroup)o;
        return Objects.equals(this.name, contactGroup.name) && Objects.equals((Object)this.status, (Object)contactGroup.status) && Objects.equals(this.contactGroupID, contactGroup.contactGroupID) && Objects.equals(this.contacts, contactGroup.contacts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.status, this.contactGroupID, this.contacts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactGroup {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    contactGroupID: ").append(this.toIndentedString(this.contactGroupID)).append("\n");
        sb.append("    contacts: ").append(this.toIndentedString(this.contacts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

