/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.accounting.BalanceDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Balance supplied for each account that has a value as at the conversion date.")
public class ConversionBalances {
    StringUtil util = new StringUtil();
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="Balance")
    private Double balance;
    @JsonProperty(value="BalanceDetails")
    private List<BalanceDetails> balanceDetails = new ArrayList<BalanceDetails>();

    public ConversionBalances accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The account code for a account")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public ConversionBalances balance(Double balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(value="The opening balances of the account. Debits are positive, credits are negative values")
    public Double getBalance() {
        return this.balance;
    }

    public void setBalance(Double balance) {
        this.balance = balance;
    }

    public ConversionBalances balanceDetails(List<BalanceDetails> balanceDetails) {
        this.balanceDetails = balanceDetails;
        return this;
    }

    public ConversionBalances addBalanceDetailsItem(BalanceDetails balanceDetailsItem) {
        if (this.balanceDetails == null) {
            this.balanceDetails = new ArrayList<BalanceDetails>();
        }
        this.balanceDetails.add(balanceDetailsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<BalanceDetails> getBalanceDetails() {
        return this.balanceDetails;
    }

    public void setBalanceDetails(List<BalanceDetails> balanceDetails) {
        this.balanceDetails = balanceDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionBalances conversionBalances = (ConversionBalances)o;
        return Objects.equals(this.accountCode, conversionBalances.accountCode) && Objects.equals(this.balance, conversionBalances.balance) && Objects.equals(this.balanceDetails, conversionBalances.balanceDetails);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.balance, this.balanceDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversionBalances {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    balanceDetails: ").append(this.toIndentedString(this.balanceDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

