/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Allocation;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Payment;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class CreditNote {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact;
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="DueDate")
    private String dueDate;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonProperty(value="SubTotal")
    private Double subTotal;
    @JsonProperty(value="TotalTax")
    private Double totalTax;
    @JsonProperty(value="Total")
    private Double total;
    @JsonProperty(value="CISDeduction")
    private Double ciSDeduction;
    @JsonProperty(value="CISRate")
    private Double ciSRate;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode;
    @JsonProperty(value="FullyPaidOnDate")
    private String fullyPaidOnDate;
    @JsonProperty(value="CreditNoteID")
    private UUID creditNoteID;
    @JsonProperty(value="CreditNoteNumber")
    private String creditNoteNumber;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="SentToContact")
    private Boolean sentToContact;
    @JsonProperty(value="CurrencyRate")
    private Double currencyRate;
    @JsonProperty(value="RemainingCredit")
    private Double remainingCredit;
    @JsonProperty(value="Allocations")
    private List<Allocation> allocations = new ArrayList<Allocation>();
    @JsonProperty(value="AppliedAmount")
    private Double appliedAmount;
    @JsonProperty(value="Payments")
    private List<Payment> payments = new ArrayList<Payment>();
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="HasErrors")
    private Boolean hasErrors = false;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();
    @JsonProperty(value="Warnings")
    private List<ValidationError> warnings = new ArrayList<ValidationError>();

    public CreditNote type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="See Credit Note Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreditNote contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public CreditNote date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="The date the credit note is issued YYYY-MM-DD. If the Date element is not specified then it will default to the current date based on the timezone setting of the organisation")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public CreditNote dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(value="Date invoice is due \u2013 YYYY-MM-DD")
    public String getDueDate() {
        return this.dueDate;
    }

    public LocalDate getDueDateAsDate() {
        if (this.dueDate != null) {
            try {
                return this.util.convertStringToDate(this.dueDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        Instant instant = dueDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.dueDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public CreditNote status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Credit Note Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CreditNote lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public CreditNote lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public CreditNote addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="See Invoice Line Items")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public CreditNote subTotal(Double subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="The subtotal of the credit note excluding taxes")
    public Double getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Double subTotal) {
        this.subTotal = subTotal;
    }

    public CreditNote totalTax(Double totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="The total tax on the credit note")
    public Double getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Double totalTax) {
        this.totalTax = totalTax;
    }

    public CreditNote total(Double total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="The total of the Credit Note(subtotal + total tax)")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    @ApiModelProperty(value="CIS deduction for UK contractors")
    public Double getCiSDeduction() {
        return this.ciSDeduction;
    }

    @ApiModelProperty(value="CIS Deduction rate for the organisation")
    public Double getCiSRate() {
        return this.ciSRate;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="UTC timestamp of last update to the credit note")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public CreditNote currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CreditNote fullyPaidOnDate(String fullyPaidOnDate) {
        this.fullyPaidOnDate = fullyPaidOnDate;
        return this;
    }

    @ApiModelProperty(value="Date when credit note was fully paid(UTC format)")
    public String getFullyPaidOnDate() {
        return this.fullyPaidOnDate;
    }

    public LocalDate getFullyPaidOnDateAsDate() {
        if (this.fullyPaidOnDate != null) {
            try {
                return this.util.convertStringToDate(this.fullyPaidOnDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setFullyPaidOnDate(String fullyPaidOnDate) {
        this.fullyPaidOnDate = fullyPaidOnDate;
    }

    public void setFullyPaidOnDate(LocalDate fullyPaidOnDate) {
        Instant instant = fullyPaidOnDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.fullyPaidOnDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public CreditNote creditNoteID(UUID creditNoteID) {
        this.creditNoteID = creditNoteID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier")
    public UUID getCreditNoteID() {
        return this.creditNoteID;
    }

    public void setCreditNoteID(UUID creditNoteID) {
        this.creditNoteID = creditNoteID;
    }

    public CreditNote creditNoteNumber(String creditNoteNumber) {
        this.creditNoteNumber = creditNoteNumber;
        return this;
    }

    @ApiModelProperty(value="ACCRECCREDIT \u2013 Unique alpha numeric code identifying credit note (when missing will auto-generate from your Organisation Invoice Settings)")
    public String getCreditNoteNumber() {
        return this.creditNoteNumber;
    }

    public void setCreditNoteNumber(String creditNoteNumber) {
        this.creditNoteNumber = creditNoteNumber;
    }

    public CreditNote reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="ACCRECCREDIT only \u2013 additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @ApiModelProperty(value="boolean to indicate if a credit note has been sent to a contact via  the Xero app (currently read only)")
    public Boolean getSentToContact() {
        return this.sentToContact;
    }

    public CreditNote currencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="The currency rate for a multicurrency invoice. If no rate is specified, the XE.com day rate is used")
    public Double getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
    }

    public CreditNote remainingCredit(Double remainingCredit) {
        this.remainingCredit = remainingCredit;
        return this;
    }

    @ApiModelProperty(value="The remaining credit balance on the Credit Note")
    public Double getRemainingCredit() {
        return this.remainingCredit;
    }

    public void setRemainingCredit(Double remainingCredit) {
        this.remainingCredit = remainingCredit;
    }

    public CreditNote allocations(List<Allocation> allocations) {
        this.allocations = allocations;
        return this;
    }

    public CreditNote addAllocationsItem(Allocation allocationsItem) {
        if (this.allocations == null) {
            this.allocations = new ArrayList<Allocation>();
        }
        this.allocations.add(allocationsItem);
        return this;
    }

    @ApiModelProperty(value="See Allocations")
    public List<Allocation> getAllocations() {
        return this.allocations;
    }

    public void setAllocations(List<Allocation> allocations) {
        this.allocations = allocations;
    }

    public CreditNote appliedAmount(Double appliedAmount) {
        this.appliedAmount = appliedAmount;
        return this;
    }

    @ApiModelProperty(example="2.0", value="The amount of applied to an invoice")
    public Double getAppliedAmount() {
        return this.appliedAmount;
    }

    public void setAppliedAmount(Double appliedAmount) {
        this.appliedAmount = appliedAmount;
    }

    public CreditNote payments(List<Payment> payments) {
        this.payments = payments;
        return this;
    }

    public CreditNote addPaymentsItem(Payment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(value="See Payments")
    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    public CreditNote brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="See BrandingThemes")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public CreditNote statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(value="A string to indicate if a invoice status")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public CreditNote hasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    @ApiModelProperty(example="false", value="boolean to indicate if a credit note has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public void setHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
    }

    public CreditNote hasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
        return this;
    }

    @ApiModelProperty(example="false", value="A boolean to indicate if a credit note has an validation errors")
    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public CreditNote validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public CreditNote addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public CreditNote warnings(List<ValidationError> warnings) {
        this.warnings = warnings;
        return this;
    }

    public CreditNote addWarningsItem(ValidationError warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<ValidationError>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of warning messages from the API")
    public List<ValidationError> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<ValidationError> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditNote creditNote = (CreditNote)o;
        return Objects.equals((Object)this.type, (Object)creditNote.type) && Objects.equals(this.contact, creditNote.contact) && Objects.equals(this.date, creditNote.date) && Objects.equals(this.dueDate, creditNote.dueDate) && Objects.equals((Object)this.status, (Object)creditNote.status) && Objects.equals((Object)this.lineAmountTypes, (Object)creditNote.lineAmountTypes) && Objects.equals(this.lineItems, creditNote.lineItems) && Objects.equals(this.subTotal, creditNote.subTotal) && Objects.equals(this.totalTax, creditNote.totalTax) && Objects.equals(this.total, creditNote.total) && Objects.equals(this.ciSDeduction, creditNote.ciSDeduction) && Objects.equals(this.ciSRate, creditNote.ciSRate) && Objects.equals(this.updatedDateUTC, creditNote.updatedDateUTC) && Objects.equals((Object)this.currencyCode, (Object)creditNote.currencyCode) && Objects.equals(this.fullyPaidOnDate, creditNote.fullyPaidOnDate) && Objects.equals(this.creditNoteID, creditNote.creditNoteID) && Objects.equals(this.creditNoteNumber, creditNote.creditNoteNumber) && Objects.equals(this.reference, creditNote.reference) && Objects.equals(this.sentToContact, creditNote.sentToContact) && Objects.equals(this.currencyRate, creditNote.currencyRate) && Objects.equals(this.remainingCredit, creditNote.remainingCredit) && Objects.equals(this.allocations, creditNote.allocations) && Objects.equals(this.appliedAmount, creditNote.appliedAmount) && Objects.equals(this.payments, creditNote.payments) && Objects.equals(this.brandingThemeID, creditNote.brandingThemeID) && Objects.equals(this.statusAttributeString, creditNote.statusAttributeString) && Objects.equals(this.hasAttachments, creditNote.hasAttachments) && Objects.equals(this.hasErrors, creditNote.hasErrors) && Objects.equals(this.validationErrors, creditNote.validationErrors) && Objects.equals(this.warnings, creditNote.warnings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.date, this.dueDate, this.status, this.lineAmountTypes, this.lineItems, this.subTotal, this.totalTax, this.total, this.ciSDeduction, this.ciSRate, this.updatedDateUTC, this.currencyCode, this.fullyPaidOnDate, this.creditNoteID, this.creditNoteNumber, this.reference, this.sentToContact, this.currencyRate, this.remainingCredit, this.allocations, this.appliedAmount, this.payments, this.brandingThemeID, this.statusAttributeString, this.hasAttachments, this.hasErrors, this.validationErrors, this.warnings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditNote {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    ciSDeduction: ").append(this.toIndentedString(this.ciSDeduction)).append("\n");
        sb.append("    ciSRate: ").append(this.toIndentedString(this.ciSRate)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    fullyPaidOnDate: ").append(this.toIndentedString(this.fullyPaidOnDate)).append("\n");
        sb.append("    creditNoteID: ").append(this.toIndentedString(this.creditNoteID)).append("\n");
        sb.append("    creditNoteNumber: ").append(this.toIndentedString(this.creditNoteNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    sentToContact: ").append(this.toIndentedString(this.sentToContact)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    remainingCredit: ").append(this.toIndentedString(this.remainingCredit)).append("\n");
        sb.append("    allocations: ").append(this.toIndentedString(this.allocations)).append("\n");
        sb.append("    appliedAmount: ").append(this.toIndentedString(this.appliedAmount)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    hasErrors: ").append(this.toIndentedString(this.hasErrors)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        SUBMITTED("SUBMITTED"),
        DELETED("DELETED"),
        AUTHORISED("AUTHORISED"),
        PAID("PAID"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ACCPAYCREDIT("ACCPAYCREDIT"),
        ACCRECCREDIT("ACCRECCREDIT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

