/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.ExternalLink;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Employee {
    StringUtil util = new StringUtil();
    @JsonProperty(value="EmployeeID")
    private UUID employeeID;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="FirstName")
    private String firstName;
    @JsonProperty(value="LastName")
    private String lastName;
    @JsonProperty(value="ExternalLink")
    private ExternalLink externalLink;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public Employee employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for an employee e.g. 297c2dc5-cc47-4afd-8ec8-74990b8761e9")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public Employee status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Current status of an employee \u2013 see contact status types")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Employee firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="First name of an employee (max length = 255)")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Employee lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="Last name of an employee (max length = 255)")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Employee externalLink(ExternalLink externalLink) {
        this.externalLink = externalLink;
        return this;
    }

    @ApiModelProperty(value="")
    public ExternalLink getExternalLink() {
        return this.externalLink;
    }

    public void setExternalLink(ExternalLink externalLink) {
        this.externalLink = externalLink;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Employee statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(example="ERROR", value="A string to indicate if a invoice status")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public Employee validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Employee addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employee employee = (Employee)o;
        return Objects.equals(this.employeeID, employee.employeeID) && Objects.equals((Object)this.status, (Object)employee.status) && Objects.equals(this.firstName, employee.firstName) && Objects.equals(this.lastName, employee.lastName) && Objects.equals(this.externalLink, employee.externalLink) && Objects.equals(this.updatedDateUTC, employee.updatedDateUTC) && Objects.equals(this.statusAttributeString, employee.statusAttributeString) && Objects.equals(this.validationErrors, employee.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.employeeID, this.status, this.firstName, this.lastName, this.externalLink, this.updatedDateUTC, this.statusAttributeString, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Employee {\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    externalLink: ").append(this.toIndentedString(this.externalLink)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        ARCHIVED("ARCHIVED"),
        GDPRREQUEST("GDPRREQUEST"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

