/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Purchase;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Item {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Code")
    private String code;
    @JsonProperty(value="InventoryAssetAccountCode")
    private String inventoryAssetAccountCode;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="IsSold")
    private Boolean isSold;
    @JsonProperty(value="IsPurchased")
    private Boolean isPurchased;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="PurchaseDescription")
    private String purchaseDescription;
    @JsonProperty(value="PurchaseDetails")
    private Purchase purchaseDetails;
    @JsonProperty(value="SalesDetails")
    private Purchase salesDetails;
    @JsonProperty(value="IsTrackedAsInventory")
    private Boolean isTrackedAsInventory;
    @JsonProperty(value="TotalCostPool")
    private Double totalCostPool;
    @JsonProperty(value="QuantityOnHand")
    private Double quantityOnHand;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="ItemID")
    private UUID itemID;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public Item code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="User defined item code (max length = 30)")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Item inventoryAssetAccountCode(String inventoryAssetAccountCode) {
        this.inventoryAssetAccountCode = inventoryAssetAccountCode;
        return this;
    }

    @ApiModelProperty(value="The inventory asset account for the item. The account must be of type INVENTORY. The  COGSAccountCode in PurchaseDetails is also required to create a tracked item")
    public String getInventoryAssetAccountCode() {
        return this.inventoryAssetAccountCode;
    }

    public void setInventoryAssetAccountCode(String inventoryAssetAccountCode) {
        this.inventoryAssetAccountCode = inventoryAssetAccountCode;
    }

    public Item name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the item (max length = 50)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Item isSold(Boolean isSold) {
        this.isSold = isSold;
        return this;
    }

    @ApiModelProperty(value="Boolean value, defaults to true. When IsSold is true the item will be available on sales transactions in the Xero UI. If IsSold is updated to false then Description and SalesDetails values will be nulled.")
    public Boolean getIsSold() {
        return this.isSold;
    }

    public void setIsSold(Boolean isSold) {
        this.isSold = isSold;
    }

    public Item isPurchased(Boolean isPurchased) {
        this.isPurchased = isPurchased;
        return this;
    }

    @ApiModelProperty(value="Boolean value, defaults to true. When IsPurchased is true the item is available for purchase transactions in the Xero UI. If IsPurchased is updated to false then PurchaseDescription and PurchaseDetails values will be nulled.")
    public Boolean getIsPurchased() {
        return this.isPurchased;
    }

    public void setIsPurchased(Boolean isPurchased) {
        this.isPurchased = isPurchased;
    }

    public Item description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The sales description of the item (max length = 4000)")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Item purchaseDescription(String purchaseDescription) {
        this.purchaseDescription = purchaseDescription;
        return this;
    }

    @ApiModelProperty(value="The purchase description of the item (max length = 4000)")
    public String getPurchaseDescription() {
        return this.purchaseDescription;
    }

    public void setPurchaseDescription(String purchaseDescription) {
        this.purchaseDescription = purchaseDescription;
    }

    public Item purchaseDetails(Purchase purchaseDetails) {
        this.purchaseDetails = purchaseDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public Purchase getPurchaseDetails() {
        return this.purchaseDetails;
    }

    public void setPurchaseDetails(Purchase purchaseDetails) {
        this.purchaseDetails = purchaseDetails;
    }

    public Item salesDetails(Purchase salesDetails) {
        this.salesDetails = salesDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public Purchase getSalesDetails() {
        return this.salesDetails;
    }

    public void setSalesDetails(Purchase salesDetails) {
        this.salesDetails = salesDetails;
    }

    public Item isTrackedAsInventory(Boolean isTrackedAsInventory) {
        this.isTrackedAsInventory = isTrackedAsInventory;
        return this;
    }

    @ApiModelProperty(value="True for items that are tracked as inventory. An item will be tracked as inventory if the InventoryAssetAccountCode and COGSAccountCode are set.")
    public Boolean getIsTrackedAsInventory() {
        return this.isTrackedAsInventory;
    }

    public void setIsTrackedAsInventory(Boolean isTrackedAsInventory) {
        this.isTrackedAsInventory = isTrackedAsInventory;
    }

    public Item totalCostPool(Double totalCostPool) {
        this.totalCostPool = totalCostPool;
        return this;
    }

    @ApiModelProperty(value="The value of the item on hand. Calculated using average cost accounting.")
    public Double getTotalCostPool() {
        return this.totalCostPool;
    }

    public void setTotalCostPool(Double totalCostPool) {
        this.totalCostPool = totalCostPool;
    }

    public Item quantityOnHand(Double quantityOnHand) {
        this.quantityOnHand = quantityOnHand;
        return this;
    }

    @ApiModelProperty(value="The quantity of the item on hand")
    public Double getQuantityOnHand() {
        return this.quantityOnHand;
    }

    public void setQuantityOnHand(Double quantityOnHand) {
        this.quantityOnHand = quantityOnHand;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Last modified date in UTC format")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Item itemID(UUID itemID) {
        this.itemID = itemID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for an Item")
    public UUID getItemID() {
        return this.itemID;
    }

    public void setItemID(UUID itemID) {
        this.itemID = itemID;
    }

    public Item statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(value="Status of object")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public Item validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Item addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.code, item.code) && Objects.equals(this.inventoryAssetAccountCode, item.inventoryAssetAccountCode) && Objects.equals(this.name, item.name) && Objects.equals(this.isSold, item.isSold) && Objects.equals(this.isPurchased, item.isPurchased) && Objects.equals(this.description, item.description) && Objects.equals(this.purchaseDescription, item.purchaseDescription) && Objects.equals(this.purchaseDetails, item.purchaseDetails) && Objects.equals(this.salesDetails, item.salesDetails) && Objects.equals(this.isTrackedAsInventory, item.isTrackedAsInventory) && Objects.equals(this.totalCostPool, item.totalCostPool) && Objects.equals(this.quantityOnHand, item.quantityOnHand) && Objects.equals(this.updatedDateUTC, item.updatedDateUTC) && Objects.equals(this.itemID, item.itemID) && Objects.equals(this.statusAttributeString, item.statusAttributeString) && Objects.equals(this.validationErrors, item.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.inventoryAssetAccountCode, this.name, this.isSold, this.isPurchased, this.description, this.purchaseDescription, this.purchaseDetails, this.salesDetails, this.isTrackedAsInventory, this.totalCostPool, this.quantityOnHand, this.updatedDateUTC, this.itemID, this.statusAttributeString, this.validationErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    inventoryAssetAccountCode: ").append(this.toIndentedString(this.inventoryAssetAccountCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    isSold: ").append(this.toIndentedString(this.isSold)).append("\n");
        sb.append("    isPurchased: ").append(this.toIndentedString(this.isPurchased)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    purchaseDescription: ").append(this.toIndentedString(this.purchaseDescription)).append("\n");
        sb.append("    purchaseDetails: ").append(this.toIndentedString(this.purchaseDetails)).append("\n");
        sb.append("    salesDetails: ").append(this.toIndentedString(this.salesDetails)).append("\n");
        sb.append("    isTrackedAsInventory: ").append(this.toIndentedString(this.isTrackedAsInventory)).append("\n");
        sb.append("    totalCostPool: ").append(this.toIndentedString(this.totalCostPool)).append("\n");
        sb.append("    quantityOnHand: ").append(this.toIndentedString(this.quantityOnHand)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    itemID: ").append(this.toIndentedString(this.itemID)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

