/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.accounting.AccountType;
import com.xero.models.accounting.TrackingCategory;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class JournalLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="JournalLineID")
    private UUID journalLineID;
    @JsonProperty(value="AccountID")
    private UUID accountID;
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="AccountType")
    private AccountType accountType;
    @JsonProperty(value="AccountName")
    private String accountName;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="NetAmount")
    private Double netAmount;
    @JsonProperty(value="GrossAmount")
    private Double grossAmount;
    @JsonProperty(value="TaxAmount")
    private Double taxAmount;
    @JsonProperty(value="TaxType")
    private String taxType;
    @JsonProperty(value="TaxName")
    private String taxName;
    @JsonProperty(value="TrackingCategories")
    private List<TrackingCategory> trackingCategories = new ArrayList<TrackingCategory>();

    public JournalLine journalLineID(UUID journalLineID) {
        this.journalLineID = journalLineID;
        return this;
    }

    @ApiModelProperty(example="7be9db36-3598-4755-ba5c-c2dbc8c4a7a2", value="Xero identifier for Journal")
    public UUID getJournalLineID() {
        return this.journalLineID;
    }

    public void setJournalLineID(UUID journalLineID) {
        this.journalLineID = journalLineID;
    }

    public JournalLine accountID(UUID accountID) {
        this.accountID = accountID;
        return this;
    }

    @ApiModelProperty(example="ceef66a5-a545-413b-9312-78a53caadbc4", value="See Accounts")
    public UUID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(UUID accountID) {
        this.accountID = accountID;
    }

    public JournalLine accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(example="90.0", value="See Accounts")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public JournalLine accountType(AccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="")
    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public JournalLine accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(example="Checking Account", value="See AccountCodes")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public JournalLine description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="My business checking account", value="The description from the source transaction line item. Only returned if populated.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JournalLine netAmount(Double netAmount) {
        this.netAmount = netAmount;
        return this;
    }

    @ApiModelProperty(example="4130.98", value="Net amount of journal line. This will be a positive value for a debit and negative for a credit")
    public Double getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(Double netAmount) {
        this.netAmount = netAmount;
    }

    public JournalLine grossAmount(Double grossAmount) {
        this.grossAmount = grossAmount;
        return this;
    }

    @ApiModelProperty(example="4130.98", value="Gross amount of journal line (NetAmount + TaxAmount).")
    public Double getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(Double grossAmount) {
        this.grossAmount = grossAmount;
    }

    @ApiModelProperty(example="0.0", value="Total tax on a journal line")
    public Double getTaxAmount() {
        return this.taxAmount;
    }

    public JournalLine taxType(String taxType) {
        this.taxType = taxType;
        return this;
    }

    @ApiModelProperty(value="The tax type from TaxRates")
    public String getTaxType() {
        return this.taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public JournalLine taxName(String taxName) {
        this.taxName = taxName;
        return this;
    }

    @ApiModelProperty(example="Tax Exempt", value="see TaxRates")
    public String getTaxName() {
        return this.taxName;
    }

    public void setTaxName(String taxName) {
        this.taxName = taxName;
    }

    public JournalLine trackingCategories(List<TrackingCategory> trackingCategories) {
        this.trackingCategories = trackingCategories;
        return this;
    }

    public JournalLine addTrackingCategoriesItem(TrackingCategory trackingCategoriesItem) {
        if (this.trackingCategories == null) {
            this.trackingCategories = new ArrayList<TrackingCategory>();
        }
        this.trackingCategories.add(trackingCategoriesItem);
        return this;
    }

    @ApiModelProperty(value="Optional Tracking Category \u2013 see Tracking. Any JournalLine can have a maximum of 2 <TrackingCategory> elements.")
    public List<TrackingCategory> getTrackingCategories() {
        return this.trackingCategories;
    }

    public void setTrackingCategories(List<TrackingCategory> trackingCategories) {
        this.trackingCategories = trackingCategories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JournalLine journalLine = (JournalLine)o;
        return Objects.equals(this.journalLineID, journalLine.journalLineID) && Objects.equals(this.accountID, journalLine.accountID) && Objects.equals(this.accountCode, journalLine.accountCode) && Objects.equals((Object)this.accountType, (Object)journalLine.accountType) && Objects.equals(this.accountName, journalLine.accountName) && Objects.equals(this.description, journalLine.description) && Objects.equals(this.netAmount, journalLine.netAmount) && Objects.equals(this.grossAmount, journalLine.grossAmount) && Objects.equals(this.taxAmount, journalLine.taxAmount) && Objects.equals(this.taxType, journalLine.taxType) && Objects.equals(this.taxName, journalLine.taxName) && Objects.equals(this.trackingCategories, journalLine.trackingCategories);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.journalLineID, this.accountID, this.accountCode, this.accountType, this.accountName, this.description, this.netAmount, this.grossAmount, this.taxAmount, this.taxType, this.taxName, this.trackingCategories});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JournalLine {\n");
        sb.append("    journalLineID: ").append(this.toIndentedString(this.journalLineID)).append("\n");
        sb.append("    accountID: ").append(this.toIndentedString(this.accountID)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    netAmount: ").append(this.toIndentedString(this.netAmount)).append("\n");
        sb.append("    grossAmount: ").append(this.toIndentedString(this.grossAmount)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxType: ").append(this.toIndentedString(this.taxType)).append("\n");
        sb.append("    taxName: ").append(this.toIndentedString(this.taxName)).append("\n");
        sb.append("    trackingCategories: ").append(this.toIndentedString(this.trackingCategories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

