/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Attachment;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.ManualJournalLine;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class ManualJournal {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Narration")
    private String narration;
    @JsonProperty(value="JournalLines")
    private List<ManualJournalLine> journalLines = new ArrayList<ManualJournalLine>();
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="Url")
    private String url;
    @JsonProperty(value="ShowOnCashBasisReports")
    private Boolean showOnCashBasisReports;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="ManualJournalID")
    private UUID manualJournalID;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;
    @JsonProperty(value="Warnings")
    private List<ValidationError> warnings = new ArrayList<ValidationError>();
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();
    @JsonProperty(value="Attachments")
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public ManualJournal narration(String narration) {
        this.narration = narration;
        return this;
    }

    @ApiModelProperty(required=true, value="Description of journal being posted")
    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public ManualJournal journalLines(List<ManualJournalLine> journalLines) {
        this.journalLines = journalLines;
        return this;
    }

    public ManualJournal addJournalLinesItem(ManualJournalLine journalLinesItem) {
        if (this.journalLines == null) {
            this.journalLines = new ArrayList<ManualJournalLine>();
        }
        this.journalLines.add(journalLinesItem);
        return this;
    }

    @ApiModelProperty(value="See JournalLines")
    public List<ManualJournalLine> getJournalLines() {
        return this.journalLines;
    }

    public void setJournalLines(List<ManualJournalLine> journalLines) {
        this.journalLines = journalLines;
    }

    public ManualJournal date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date journal was posted \u2013 YYYY-MM-DD")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public ManualJournal lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public ManualJournal status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Manual Journal Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ManualJournal url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Url link to a source document \u2013 shown as \u201cGo to [appName]\u201d in the Xero app")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ManualJournal showOnCashBasisReports(Boolean showOnCashBasisReports) {
        this.showOnCashBasisReports = showOnCashBasisReports;
        return this;
    }

    @ApiModelProperty(value="Boolean \u2013 default is true if not specified")
    public Boolean getShowOnCashBasisReports() {
        return this.showOnCashBasisReports;
    }

    public void setShowOnCashBasisReports(Boolean showOnCashBasisReports) {
        this.showOnCashBasisReports = showOnCashBasisReports;
    }

    @ApiModelProperty(example="false", value="Boolean to indicate if a manual journal has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Last modified date UTC format")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ManualJournal manualJournalID(UUID manualJournalID) {
        this.manualJournalID = manualJournalID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for a Manual Journal")
    public UUID getManualJournalID() {
        return this.manualJournalID;
    }

    public void setManualJournalID(UUID manualJournalID) {
        this.manualJournalID = manualJournalID;
    }

    public ManualJournal statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(example="ERROR", value="A string to indicate if a invoice status")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public ManualJournal warnings(List<ValidationError> warnings) {
        this.warnings = warnings;
        return this;
    }

    public ManualJournal addWarningsItem(ValidationError warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<ValidationError>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of warning messages from the API")
    public List<ValidationError> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<ValidationError> warnings) {
        this.warnings = warnings;
    }

    public ManualJournal validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public ManualJournal addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public ManualJournal attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public ManualJournal addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of attachments from the API")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualJournal manualJournal = (ManualJournal)o;
        return Objects.equals(this.narration, manualJournal.narration) && Objects.equals(this.journalLines, manualJournal.journalLines) && Objects.equals(this.date, manualJournal.date) && Objects.equals((Object)this.lineAmountTypes, (Object)manualJournal.lineAmountTypes) && Objects.equals((Object)this.status, (Object)manualJournal.status) && Objects.equals(this.url, manualJournal.url) && Objects.equals(this.showOnCashBasisReports, manualJournal.showOnCashBasisReports) && Objects.equals(this.hasAttachments, manualJournal.hasAttachments) && Objects.equals(this.updatedDateUTC, manualJournal.updatedDateUTC) && Objects.equals(this.manualJournalID, manualJournal.manualJournalID) && Objects.equals(this.statusAttributeString, manualJournal.statusAttributeString) && Objects.equals(this.warnings, manualJournal.warnings) && Objects.equals(this.validationErrors, manualJournal.validationErrors) && Objects.equals(this.attachments, manualJournal.attachments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.narration, this.journalLines, this.date, this.lineAmountTypes, this.status, this.url, this.showOnCashBasisReports, this.hasAttachments, this.updatedDateUTC, this.manualJournalID, this.statusAttributeString, this.warnings, this.validationErrors, this.attachments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManualJournal {\n");
        sb.append("    narration: ").append(this.toIndentedString(this.narration)).append("\n");
        sb.append("    journalLines: ").append(this.toIndentedString(this.journalLines)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    showOnCashBasisReports: ").append(this.toIndentedString(this.showOnCashBasisReports)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    manualJournalID: ").append(this.toIndentedString(this.manualJournalID)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        POSTED("POSTED"),
        DELETED("DELETED"),
        VOIDED("VOIDED"),
        ARCHIVED("ARCHIVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

