/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;

public class Schedule {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Period")
    private Integer period;
    @JsonProperty(value="Unit")
    private UnitEnum unit;
    @JsonProperty(value="DueDate")
    private Integer dueDate;
    @JsonProperty(value="DueDateType")
    private DueDateTypeEnum dueDateType;
    @JsonProperty(value="StartDate")
    private String startDate;
    @JsonProperty(value="NextScheduledDate")
    private String nextScheduledDate;
    @JsonProperty(value="EndDate")
    private String endDate;

    public Schedule period(Integer period) {
        this.period = period;
        return this;
    }

    @ApiModelProperty(value="Integer used with the unit e.g. 1 (every 1 week), 2 (every 2 months)")
    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Schedule unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(value="One of the following - WEEKLY or MONTHLY")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public Schedule dueDate(Integer dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(value="Integer used with due date type e.g 20 (of following month), 31 (of current month)")
    public Integer getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Integer dueDate) {
        this.dueDate = dueDate;
    }

    public Schedule dueDateType(DueDateTypeEnum dueDateType) {
        this.dueDateType = dueDateType;
        return this;
    }

    @ApiModelProperty(value="the payment terms")
    public DueDateTypeEnum getDueDateType() {
        return this.dueDateType;
    }

    public void setDueDateType(DueDateTypeEnum dueDateType) {
        this.dueDateType = dueDateType;
    }

    public Schedule startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="Date the first invoice of the current version of the repeating schedule was generated (changes when repeating invoice is edited)")
    public String getStartDate() {
        return this.startDate;
    }

    public LocalDate getStartDateAsDate() {
        if (this.startDate != null) {
            try {
                return this.util.convertStringToDate(this.startDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(LocalDate startDate) {
        Instant instant = startDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.startDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Schedule nextScheduledDate(String nextScheduledDate) {
        this.nextScheduledDate = nextScheduledDate;
        return this;
    }

    @ApiModelProperty(value="The calendar date of the next invoice in the schedule to be generated")
    public String getNextScheduledDate() {
        return this.nextScheduledDate;
    }

    public LocalDate getNextScheduledDateAsDate() {
        if (this.nextScheduledDate != null) {
            try {
                return this.util.convertStringToDate(this.nextScheduledDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setNextScheduledDate(String nextScheduledDate) {
        this.nextScheduledDate = nextScheduledDate;
    }

    public void setNextScheduledDate(LocalDate nextScheduledDate) {
        Instant instant = nextScheduledDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.nextScheduledDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Schedule endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="Invoice end date \u2013 only returned if the template has an end date set")
    public String getEndDate() {
        return this.endDate;
    }

    public LocalDate getEndDateAsDate() {
        if (this.endDate != null) {
            try {
                return this.util.convertStringToDate(this.endDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setEndDate(LocalDate endDate) {
        Instant instant = endDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.endDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schedule schedule = (Schedule)o;
        return Objects.equals(this.period, schedule.period) && Objects.equals((Object)this.unit, (Object)schedule.unit) && Objects.equals(this.dueDate, schedule.dueDate) && Objects.equals((Object)this.dueDateType, (Object)schedule.dueDateType) && Objects.equals(this.startDate, schedule.startDate) && Objects.equals(this.nextScheduledDate, schedule.nextScheduledDate) && Objects.equals(this.endDate, schedule.endDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.period, this.unit, this.dueDate, this.dueDateType, this.startDate, this.nextScheduledDate, this.endDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Schedule {\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    dueDateType: ").append(this.toIndentedString((Object)this.dueDateType)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    nextScheduledDate: ").append(this.toIndentedString(this.nextScheduledDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DueDateTypeEnum {
        DAYSAFTERBILLDATE("DAYSAFTERBILLDATE"),
        DAYSAFTERBILLMONTH("DAYSAFTERBILLMONTH"),
        DAYSAFTERINVOICEDATE("DAYSAFTERINVOICEDATE"),
        DAYSAFTERINVOICEMONTH("DAYSAFTERINVOICEMONTH"),
        OFCURRENTMONTH("OFCURRENTMONTH"),
        OFFOLLOWINGMONTH("OFFOLLOWINGMONTH");

        private String value;

        private DueDateTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DueDateTypeEnum fromValue(String value) {
            for (DueDateTypeEnum b : DueDateTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum UnitEnum {
        WEEKLY("WEEKLY"),
        MONTHLY("MONTHLY");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UnitEnum fromValue(String value) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

