/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.appstore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.appstore.SubscriptionItem;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class Plan {
    StringUtil util = new StringUtil();
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="subscriptionItems")
    private List<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();

    public Plan id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the plan")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Plan name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the plan. It is used in the invoice line item description. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Plan status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the plan. Available statuses are ACTIVE, PENDING_ACTIVATION. ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Plan subscriptionItems(List<SubscriptionItem> subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
        return this;
    }

    public Plan addSubscriptionItemsItem(SubscriptionItem subscriptionItemsItem) {
        this.subscriptionItems.add(subscriptionItemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of the subscription items belonging to the plan. It does not include cancelled subscription items. ")
    public List<SubscriptionItem> getSubscriptionItems() {
        return this.subscriptionItems;
    }

    public void setSubscriptionItems(List<SubscriptionItem> subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plan plan = (Plan)o;
        return Objects.equals(this.id, plan.id) && Objects.equals(this.name, plan.name) && Objects.equals((Object)this.status, (Object)plan.status) && Objects.equals(this.subscriptionItems, plan.subscriptionItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.status, this.subscriptionItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Plan {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subscriptionItems: ").append(this.toIndentedString(this.subscriptionItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        PENDING_ACTIVATION("PENDING_ACTIVATION");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

