/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.appstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.appstore.Plan;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Subscription {
    StringUtil util = new StringUtil();
    @JsonProperty(value="currentPeriodEnd")
    private OffsetDateTime currentPeriodEnd;
    @JsonProperty(value="endDate")
    private OffsetDateTime endDate;
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="organisationId")
    private UUID organisationId;
    @JsonProperty(value="plans")
    private List<Plan> plans = new ArrayList<Plan>();
    @JsonProperty(value="startDate")
    private OffsetDateTime startDate;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="testMode")
    private Boolean testMode;

    public Subscription currentPeriodEnd(OffsetDateTime currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
        return this;
    }

    @ApiModelProperty(required=true, value="End of the current period that the subscription has been invoiced for. ")
    public OffsetDateTime getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    public void setCurrentPeriodEnd(OffsetDateTime currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    public Subscription endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="If the subscription has been canceled, this is the date when the subscription ends. If null, the subscription is active and has not been cancelled")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public Subscription id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the subscription")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Subscription organisationId(UUID organisationId) {
        this.organisationId = organisationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Xero generated unique identifier for the organisation")
    public UUID getOrganisationId() {
        return this.organisationId;
    }

    public void setOrganisationId(UUID organisationId) {
        this.organisationId = organisationId;
    }

    public Subscription plans(List<Plan> plans) {
        this.plans = plans;
        return this;
    }

    public Subscription addPlansItem(Plan plansItem) {
        this.plans.add(plansItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of plans for the subscription.")
    public List<Plan> getPlans() {
        return this.plans;
    }

    public void setPlans(List<Plan> plans) {
        this.plans = plans;
    }

    public Subscription startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Date when the subscription was first created.")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public Subscription status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the subscription. Available statuses are ACTIVE, CANCELED, and PAST_DUE.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Subscription testMode(Boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    @ApiModelProperty(value="Boolean used to indicate if the subscription is in test mode")
    public Boolean getTestMode() {
        return this.testMode;
    }

    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription subscription = (Subscription)o;
        return Objects.equals(this.currentPeriodEnd, subscription.currentPeriodEnd) && Objects.equals(this.endDate, subscription.endDate) && Objects.equals(this.id, subscription.id) && Objects.equals(this.organisationId, subscription.organisationId) && Objects.equals(this.plans, subscription.plans) && Objects.equals(this.startDate, subscription.startDate) && Objects.equals(this.status, subscription.status) && Objects.equals(this.testMode, subscription.testMode);
    }

    public int hashCode() {
        return Objects.hash(this.currentPeriodEnd, this.endDate, this.id, this.organisationId, this.plans, this.startDate, this.status, this.testMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subscription {\n");
        sb.append("    currentPeriodEnd: ").append(this.toIndentedString(this.currentPeriodEnd)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    organisationId: ").append(this.toIndentedString(this.organisationId)).append("\n");
        sb.append("    plans: ").append(this.toIndentedString(this.plans)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    testMode: ").append(this.toIndentedString(this.testMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

