/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.appstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.appstore.Price;
import com.xero.models.appstore.Product;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class SubscriptionItem {
    StringUtil util = new StringUtil();
    @JsonProperty(value="endDate")
    private OffsetDateTime endDate;
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="price")
    private Price price;
    @JsonProperty(value="product")
    private Product product;
    @JsonProperty(value="startDate")
    private OffsetDateTime startDate;
    @JsonProperty(value="testMode")
    private Boolean testMode;

    public SubscriptionItem endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="Date when the subscription to this product will end")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public SubscriptionItem id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the subscription item.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SubscriptionItem price(Price price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price price) {
        this.price = price;
    }

    public SubscriptionItem product(Product product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public SubscriptionItem startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Date the subscription started, or will start. Note: this could be in the future for downgrades or reduced number of seats that haven't taken effect yet. ")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public SubscriptionItem testMode(Boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    @ApiModelProperty(value="If the subscription is a test subscription")
    public Boolean getTestMode() {
        return this.testMode;
    }

    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionItem subscriptionItem = (SubscriptionItem)o;
        return Objects.equals(this.endDate, subscriptionItem.endDate) && Objects.equals(this.id, subscriptionItem.id) && Objects.equals(this.price, subscriptionItem.price) && Objects.equals(this.product, subscriptionItem.product) && Objects.equals(this.startDate, subscriptionItem.startDate) && Objects.equals(this.testMode, subscriptionItem.testMode);
    }

    public int hashCode() {
        return Objects.hash(this.endDate, this.id, this.price, this.product, this.startDate, this.testMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionItem {\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    testMode: ").append(this.toIndentedString(this.testMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

