/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.bankfeeds;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.bankfeeds.CreditDebitIndicator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

@ApiModel(description="the lines details for a statement")
public class StatementLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="postedDate")
    private LocalDate postedDate;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="amount")
    private Double amount;
    @JsonProperty(value="creditDebitIndicator")
    private CreditDebitIndicator creditDebitIndicator;
    @JsonProperty(value="transactionId")
    private String transactionId;
    @JsonProperty(value="payeeName")
    private String payeeName;
    @JsonProperty(value="reference")
    private String reference;
    @JsonProperty(value="chequeNumber")
    private String chequeNumber;
    @JsonProperty(value="transactionType")
    private String transactionType;

    public StatementLine postedDate(LocalDate postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(example="Sun Jun 10 00:00:00 GMT 2018", value="The date that the transaction was processed or cleared as seen in internet banking ISO-8601 YYYY-MM-DD")
    public LocalDate getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(LocalDate postedDate) {
        this.postedDate = postedDate;
    }

    public StatementLine description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Description for statement line 2", value="Transaction description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StatementLine amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="5.00", value="Transaction amount")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public StatementLine creditDebitIndicator(CreditDebitIndicator creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @ApiModelProperty(value="")
    public CreditDebitIndicator getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(CreditDebitIndicator creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public StatementLine transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="transaction-id-2", value="Financial institute's internal transaction identifier. If provided this field is factored into duplicate detection.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public StatementLine payeeName(String payeeName) {
        this.payeeName = payeeName;
        return this;
    }

    @ApiModelProperty(example="Payee name for statement line 2", value="Typically the merchant or payee name")
    public String getPayeeName() {
        return this.payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public StatementLine reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(example="Reference for statement line 2", value="Optional field to enhance the Description")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public StatementLine chequeNumber(String chequeNumber) {
        this.chequeNumber = chequeNumber;
        return this;
    }

    @ApiModelProperty(example="021", value="The cheque/check number")
    public String getChequeNumber() {
        return this.chequeNumber;
    }

    public void setChequeNumber(String chequeNumber) {
        this.chequeNumber = chequeNumber;
    }

    public StatementLine transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @ApiModelProperty(example="Refund", value="Descriptive transaction type")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementLine statementLine = (StatementLine)o;
        return Objects.equals(this.postedDate, statementLine.postedDate) && Objects.equals(this.description, statementLine.description) && Objects.equals(this.amount, statementLine.amount) && Objects.equals((Object)this.creditDebitIndicator, (Object)statementLine.creditDebitIndicator) && Objects.equals(this.transactionId, statementLine.transactionId) && Objects.equals(this.payeeName, statementLine.payeeName) && Objects.equals(this.reference, statementLine.reference) && Objects.equals(this.chequeNumber, statementLine.chequeNumber) && Objects.equals(this.transactionType, statementLine.transactionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.postedDate, this.description, this.amount, this.creditDebitIndicator, this.transactionId, this.payeeName, this.reference, this.chequeNumber, this.transactionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatementLine {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    payeeName: ").append(this.toIndentedString(this.payeeName)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    chequeNumber: ").append(this.toIndentedString(this.chequeNumber)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

